/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.3.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Existing customer payment methods
 */
@JsonPropertyOrder({
  CustomerPaymentMethod.JSON_PROPERTY_PAYMENT_METHOD_ID,
  CustomerPaymentMethod.JSON_PROPERTY_BRAND,
  CustomerPaymentMethod.JSON_PROPERTY_NAME_ON_CARD,
  CustomerPaymentMethod.JSON_PROPERTY_LAST4,
  CustomerPaymentMethod.JSON_PROPERTY_EXPIRATION_DATE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-06T13:35:10.342386258+07:00[Asia/Bangkok]")
public class CustomerPaymentMethod {
  public static final String JSON_PROPERTY_PAYMENT_METHOD_ID = "paymentMethodId";
  private String paymentMethodId;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_NAME_ON_CARD = "nameOnCard";
  private String nameOnCard;

  public static final String JSON_PROPERTY_LAST4 = "last4";
  private String last4;

  public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
  private String expirationDate;

  public CustomerPaymentMethod() {
  }

  public CustomerPaymentMethod paymentMethodId(String paymentMethodId) {
    
    this.paymentMethodId = paymentMethodId;
    return this;
  }

   /**
   * Unique payment method identifier
   * @return paymentMethodId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentMethodId() {
    return paymentMethodId;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentMethodId(String paymentMethodId) {
    this.paymentMethodId = paymentMethodId;
  }


  public CustomerPaymentMethod brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Type of card
   * @return brand
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public CustomerPaymentMethod nameOnCard(String nameOnCard) {
    
    this.nameOnCard = nameOnCard;
    return this;
  }

   /**
   * Name on card
   * @return nameOnCard
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME_ON_CARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameOnCard() {
    return nameOnCard;
  }


  @JsonProperty(JSON_PROPERTY_NAME_ON_CARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNameOnCard(String nameOnCard) {
    this.nameOnCard = nameOnCard;
  }


  public CustomerPaymentMethod last4(String last4) {
    
    this.last4 = last4;
    return this;
  }

   /**
   * Last 4 digits of card
   * @return last4
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LAST4)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLast4() {
    return last4;
  }


  @JsonProperty(JSON_PROPERTY_LAST4)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLast4(String last4) {
    this.last4 = last4;
  }


  public CustomerPaymentMethod expirationDate(String expirationDate) {
    
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * Card expiration date
   * @return expirationDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExpirationDate() {
    return expirationDate;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExpirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomerPaymentMethod customerPaymentMethod = (CustomerPaymentMethod) o;
    return Objects.equals(this.paymentMethodId, customerPaymentMethod.paymentMethodId) &&
        Objects.equals(this.brand, customerPaymentMethod.brand) &&
        Objects.equals(this.nameOnCard, customerPaymentMethod.nameOnCard) &&
        Objects.equals(this.last4, customerPaymentMethod.last4) &&
        Objects.equals(this.expirationDate, customerPaymentMethod.expirationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentMethodId, brand, nameOnCard, last4, expirationDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomerPaymentMethod {\n");
    sb.append("    paymentMethodId: ").append(toIndentedString(paymentMethodId)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    nameOnCard: ").append(toIndentedString(nameOnCard)).append("\n");
    sb.append("    last4: ").append(toIndentedString(last4)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

