/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.3.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * TotalAggregateFunds
 */
@JsonPropertyOrder({
  TotalAggregateFunds.JSON_PROPERTY_SOURCE_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_DISPLAY_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_SUPPLIER_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_INTERNAL_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_CAPTURE_CURRENCY,
  TotalAggregateFunds.JSON_PROPERTY_SOURCE_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_DISPLAY_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_SUPPLIER_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_INTERNAL_AMOUNT,
  TotalAggregateFunds.JSON_PROPERTY_CAPTURE_AMOUNT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-06T13:35:10.342386258+07:00[Asia/Bangkok]")
public class TotalAggregateFunds {
  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private java.math.BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  private java.math.BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private java.math.BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private java.math.BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  private java.math.BigDecimal captureAmount;

  public TotalAggregateFunds() {
  }

  public TotalAggregateFunds sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * Get sourceCurrency
   * @return sourceCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public TotalAggregateFunds displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * Get displayCurrency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public TotalAggregateFunds supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * Get supplierCurrency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public TotalAggregateFunds internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * Get internalCurrency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public TotalAggregateFunds captureCurrency(String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

   /**
   * Get captureCurrency
   * @return captureCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureCurrency(String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }


  public TotalAggregateFunds sourceAmount(java.math.BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * Get sourceAmount
   * @return sourceAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmount(java.math.BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public TotalAggregateFunds displayAmount(java.math.BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

   /**
   * Get displayAmount
   * @return displayAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmount(java.math.BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }


  public TotalAggregateFunds supplierAmount(java.math.BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * Get supplierAmount
   * @return supplierAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmount(java.math.BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public TotalAggregateFunds internalAmount(java.math.BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * Get internalAmount
   * @return internalAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmount(java.math.BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }


  public TotalAggregateFunds captureAmount(java.math.BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

   /**
   * Get captureAmount
   * @return captureAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmount(java.math.BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TotalAggregateFunds totalAggregateFunds = (TotalAggregateFunds) o;
    return Objects.equals(this.sourceCurrency, totalAggregateFunds.sourceCurrency) &&
        Objects.equals(this.displayCurrency, totalAggregateFunds.displayCurrency) &&
        Objects.equals(this.supplierCurrency, totalAggregateFunds.supplierCurrency) &&
        Objects.equals(this.internalCurrency, totalAggregateFunds.internalCurrency) &&
        Objects.equals(this.captureCurrency, totalAggregateFunds.captureCurrency) &&
        Objects.equals(this.sourceAmount, totalAggregateFunds.sourceAmount) &&
        Objects.equals(this.displayAmount, totalAggregateFunds.displayAmount) &&
        Objects.equals(this.supplierAmount, totalAggregateFunds.supplierAmount) &&
        Objects.equals(this.internalAmount, totalAggregateFunds.internalAmount) &&
        Objects.equals(this.captureAmount, totalAggregateFunds.captureAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TotalAggregateFunds {\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

