/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.30.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateIssuingCardEphemeralKeyRequest
 */
@JsonPropertyOrder({
  CreateIssuingCardEphemeralKeyRequest.JSON_PROPERTY_VENDOR_IDENTIFIER,
  CreateIssuingCardEphemeralKeyRequest.JSON_PROPERTY_ISSUING_CARD,
  CreateIssuingCardEphemeralKeyRequest.JSON_PROPERTY_NONCE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-12-27T17:49:57.050766449+07:00[Asia/Bangkok]")
public class CreateIssuingCardEphemeralKeyRequest {
  public static final String JSON_PROPERTY_VENDOR_IDENTIFIER = "vendorIdentifier";
  private String vendorIdentifier;

  public static final String JSON_PROPERTY_ISSUING_CARD = "issuingCard";
  private String issuingCard;

  public static final String JSON_PROPERTY_NONCE = "nonce";
  private String nonce;

  public CreateIssuingCardEphemeralKeyRequest() {
  }

  public CreateIssuingCardEphemeralKeyRequest vendorIdentifier(String vendorIdentifier) {
    
    this.vendorIdentifier = vendorIdentifier;
    return this;
  }

   /**
   * Which coverage area is Stripe customer occurring in.
   * @return vendorIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVendorIdentifier() {
    return vendorIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorIdentifier(String vendorIdentifier) {
    this.vendorIdentifier = vendorIdentifier;
  }


  public CreateIssuingCardEphemeralKeyRequest issuingCard(String issuingCard) {
    
    this.issuingCard = issuingCard;
    return this;
  }

   /**
   * The cardholder unique ID.
   * @return issuingCard
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ISSUING_CARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIssuingCard() {
    return issuingCard;
  }


  @JsonProperty(JSON_PROPERTY_ISSUING_CARD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIssuingCard(String issuingCard) {
    this.issuingCard = issuingCard;
  }


  public CreateIssuingCardEphemeralKeyRequest nonce(String nonce) {
    
    this.nonce = nonce;
    return this;
  }

   /**
   * A unique none.
   * @return nonce
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NONCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNonce() {
    return nonce;
  }


  @JsonProperty(JSON_PROPERTY_NONCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNonce(String nonce) {
    this.nonce = nonce;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateIssuingCardEphemeralKeyRequest createIssuingCardEphemeralKeyRequest = (CreateIssuingCardEphemeralKeyRequest) o;
    return Objects.equals(this.vendorIdentifier, createIssuingCardEphemeralKeyRequest.vendorIdentifier) &&
        Objects.equals(this.issuingCard, createIssuingCardEphemeralKeyRequest.issuingCard) &&
        Objects.equals(this.nonce, createIssuingCardEphemeralKeyRequest.nonce);
  }

  @Override
  public int hashCode() {
    return Objects.hash(vendorIdentifier, issuingCard, nonce);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateIssuingCardEphemeralKeyRequest {\n");
    sb.append("    vendorIdentifier: ").append(toIndentedString(vendorIdentifier)).append("\n");
    sb.append("    issuingCard: ").append(toIndentedString(issuingCard)).append("\n");
    sb.append("    nonce: ").append(toIndentedString(nonce)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

