/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Beneficiary;
import io.trippay.sdk.payment.model.DailyRate;
import io.trippay.sdk.payment.model.GuestUser;
import io.trippay.sdk.payment.model.Itinerary;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"supplierItemBookingCode", "user", "nameInEnglish", "descriptionInEnglish", "itinerary", "pricingType", "type", "beneficiaryList", "payable", "policy", "externalIdentifier", "tokensEarned", "dailyRateList", "cancelled", "sourceCurrency", "displayCurrency", "supplierCurrency", "internalCurrency", "captureCurrency", "sourceAmount", "displayAmount", "supplierAmount", "internalAmount", "captureAmount", "sourceAmountRefundModifier", "displayAmountRefundModifier", "supplierAmountRefundModifier", "internalAmountRefundModifier", "captureAmountRefundModifier", "metadata", "cancellableBySupplier", "netSupplierAmount", "cancellableWithNoCharges", "cancellableWithPotentialCharges", "netCaptureAmount", "cancellableByTraveler", "netSourceAmount", "netDisplayAmount", "netInternalAmount"})
public class BookingContractItem {
    public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
    private String supplierItemBookingCode;
    public static final String JSON_PROPERTY_USER = "user";
    private GuestUser user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private Itinerary itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<Beneficiary> beneficiaryList = new ArrayList<Beneficiary>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicy policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
    private Long tokensEarned;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<DailyRate> dailyRateList;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled;
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private String sourceCurrency;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency;
    public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
    private String supplierCurrency;
    public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
    private String internalCurrency;
    public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
    private String captureCurrency;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    private BigDecimal sourceAmount;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
    private BigDecimal displayAmount;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
    private BigDecimal supplierAmount;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
    private BigDecimal internalAmount;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
    private BigDecimal captureAmount;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
    private BigDecimal sourceAmountRefundModifier;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
    private BigDecimal displayAmountRefundModifier;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
    private BigDecimal supplierAmountRefundModifier;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
    private BigDecimal internalAmountRefundModifier;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
    private BigDecimal captureAmountRefundModifier;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
    private BigDecimal netSupplierAmount;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
    private Boolean cancellableWithPotentialCharges;
    public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
    private BigDecimal netCaptureAmount;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
    private BigDecimal netSourceAmount;
    public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
    private BigDecimal netDisplayAmount;
    public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
    private BigDecimal netInternalAmount;

    public BookingContractItem supplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierItemBookingCode() {
        return this.supplierItemBookingCode;
    }

    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierItemBookingCode(String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
    }

    public BookingContractItem user(GuestUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GuestUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(GuestUser user) {
        this.user = user;
    }

    public BookingContractItem nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public BookingContractItem descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public BookingContractItem itinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Itinerary getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
    }

    public BookingContractItem pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public BookingContractItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BookingContractItem beneficiaryList(List<Beneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public BookingContractItem addBeneficiaryListItem(Beneficiary beneficiaryListItem) {
        if (this.beneficiaryList == null) {
            this.beneficiaryList = new ArrayList<Beneficiary>();
        }
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<Beneficiary> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<Beneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public BookingContractItem payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public BookingContractItem policy(SupplierContractItemPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicy policy) {
        this.policy = policy;
    }

    public BookingContractItem externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public BookingContractItem tokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
        return this;
    }

    @Nullable
    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTokensEarned() {
        return this.tokensEarned;
    }

    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokensEarned(Long tokensEarned) {
        this.tokensEarned = tokensEarned;
    }

    public BookingContractItem dailyRateList(List<DailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public BookingContractItem addDailyRateListItem(DailyRate dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<DailyRate>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DailyRate> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<DailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public BookingContractItem cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractItem sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public BookingContractItem displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public BookingContractItem supplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierCurrency() {
        return this.supplierCurrency;
    }

    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
    }

    public BookingContractItem internalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInternalCurrency() {
        return this.internalCurrency;
    }

    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
    }

    public BookingContractItem captureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCaptureCurrency() {
        return this.captureCurrency;
    }

    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
    }

    public BookingContractItem sourceAmount(BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSourceAmount() {
        return this.sourceAmount;
    }

    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAmount(BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public BookingContractItem displayAmount(BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getDisplayAmount() {
        return this.displayAmount;
    }

    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayAmount(BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
    }

    public BookingContractItem supplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSupplierAmount() {
        return this.supplierAmount;
    }

    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
    }

    public BookingContractItem internalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getInternalAmount() {
        return this.internalAmount;
    }

    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
    }

    public BookingContractItem captureAmount(BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getCaptureAmount() {
        return this.captureAmount;
    }

    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureAmount(BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
    }

    public BookingContractItem sourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getSourceAmountRefundModifier() {
        return this.sourceAmountRefundModifier;
    }

    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    }

    public BookingContractItem displayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getDisplayAmountRefundModifier() {
        return this.displayAmountRefundModifier;
    }

    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
    }

    public BookingContractItem supplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getSupplierAmountRefundModifier() {
        return this.supplierAmountRefundModifier;
    }

    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    }

    public BookingContractItem internalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getInternalAmountRefundModifier() {
        return this.internalAmountRefundModifier;
    }

    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
    }

    public BookingContractItem captureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getCaptureAmountRefundModifier() {
        return this.captureAmountRefundModifier;
    }

    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
    }

    public BookingContractItem metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BookingContractItem putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BookingContractItem cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractItem netSupplierAmount(BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetSupplierAmount() {
        return this.netSupplierAmount;
    }

    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetSupplierAmount(BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
    }

    public BookingContractItem cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContractItem cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharges() {
        return this.cancellableWithPotentialCharges;
    }

    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    }

    public BookingContractItem netCaptureAmount(BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetCaptureAmount() {
        return this.netCaptureAmount;
    }

    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCaptureAmount(BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
    }

    public BookingContractItem cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractItem netSourceAmount(BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetSourceAmount() {
        return this.netSourceAmount;
    }

    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetSourceAmount(BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
    }

    public BookingContractItem netDisplayAmount(BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetDisplayAmount() {
        return this.netDisplayAmount;
    }

    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetDisplayAmount(BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
    }

    public BookingContractItem netInternalAmount(BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getNetInternalAmount() {
        return this.netInternalAmount;
    }

    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetInternalAmount(BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractItem bookingContractItem = (BookingContractItem)o;
        return Objects.equals(this.supplierItemBookingCode, bookingContractItem.supplierItemBookingCode) && Objects.equals(this.user, bookingContractItem.user) && Objects.equals(this.nameInEnglish, bookingContractItem.nameInEnglish) && Objects.equals(this.descriptionInEnglish, bookingContractItem.descriptionInEnglish) && Objects.equals(this.itinerary, bookingContractItem.itinerary) && Objects.equals((Object)this.pricingType, (Object)bookingContractItem.pricingType) && Objects.equals((Object)this.type, (Object)bookingContractItem.type) && Objects.equals(this.beneficiaryList, bookingContractItem.beneficiaryList) && Objects.equals((Object)this.payable, (Object)bookingContractItem.payable) && Objects.equals(this.policy, bookingContractItem.policy) && Objects.equals(this.externalIdentifier, bookingContractItem.externalIdentifier) && Objects.equals(this.tokensEarned, bookingContractItem.tokensEarned) && Objects.equals(this.dailyRateList, bookingContractItem.dailyRateList) && Objects.equals(this.cancelled, bookingContractItem.cancelled) && Objects.equals(this.sourceCurrency, bookingContractItem.sourceCurrency) && Objects.equals(this.displayCurrency, bookingContractItem.displayCurrency) && Objects.equals(this.supplierCurrency, bookingContractItem.supplierCurrency) && Objects.equals(this.internalCurrency, bookingContractItem.internalCurrency) && Objects.equals(this.captureCurrency, bookingContractItem.captureCurrency) && Objects.equals(this.sourceAmount, bookingContractItem.sourceAmount) && Objects.equals(this.displayAmount, bookingContractItem.displayAmount) && Objects.equals(this.supplierAmount, bookingContractItem.supplierAmount) && Objects.equals(this.internalAmount, bookingContractItem.internalAmount) && Objects.equals(this.captureAmount, bookingContractItem.captureAmount) && Objects.equals(this.sourceAmountRefundModifier, bookingContractItem.sourceAmountRefundModifier) && Objects.equals(this.displayAmountRefundModifier, bookingContractItem.displayAmountRefundModifier) && Objects.equals(this.supplierAmountRefundModifier, bookingContractItem.supplierAmountRefundModifier) && Objects.equals(this.internalAmountRefundModifier, bookingContractItem.internalAmountRefundModifier) && Objects.equals(this.captureAmountRefundModifier, bookingContractItem.captureAmountRefundModifier) && Objects.equals(this.metadata, bookingContractItem.metadata) && Objects.equals(this.cancellableBySupplier, bookingContractItem.cancellableBySupplier) && Objects.equals(this.netSupplierAmount, bookingContractItem.netSupplierAmount) && Objects.equals(this.cancellableWithNoCharges, bookingContractItem.cancellableWithNoCharges) && Objects.equals(this.cancellableWithPotentialCharges, bookingContractItem.cancellableWithPotentialCharges) && Objects.equals(this.netCaptureAmount, bookingContractItem.netCaptureAmount) && Objects.equals(this.cancellableByTraveler, bookingContractItem.cancellableByTraveler) && Objects.equals(this.netSourceAmount, bookingContractItem.netSourceAmount) && Objects.equals(this.netDisplayAmount, bookingContractItem.netDisplayAmount) && Objects.equals(this.netInternalAmount, bookingContractItem.netInternalAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.supplierItemBookingCode, this.user, this.nameInEnglish, this.descriptionInEnglish, this.itinerary, this.pricingType, this.type, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.tokensEarned, this.dailyRateList, this.cancelled, this.sourceCurrency, this.displayCurrency, this.supplierCurrency, this.internalCurrency, this.captureCurrency, this.sourceAmount, this.displayAmount, this.supplierAmount, this.internalAmount, this.captureAmount, this.sourceAmountRefundModifier, this.displayAmountRefundModifier, this.supplierAmountRefundModifier, this.internalAmountRefundModifier, this.captureAmountRefundModifier, this.metadata, this.cancellableBySupplier, this.netSupplierAmount, this.cancellableWithNoCharges, this.cancellableWithPotentialCharges, this.netCaptureAmount, this.cancellableByTraveler, this.netSourceAmount, this.netDisplayAmount, this.netInternalAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractItem {\n");
        sb.append("    supplierItemBookingCode: ").append(this.toIndentedString(this.supplierItemBookingCode)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    tokensEarned: ").append(this.toIndentedString(this.tokensEarned)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    supplierCurrency: ").append(this.toIndentedString(this.supplierCurrency)).append("\n");
        sb.append("    internalCurrency: ").append(this.toIndentedString(this.internalCurrency)).append("\n");
        sb.append("    captureCurrency: ").append(this.toIndentedString(this.captureCurrency)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    displayAmount: ").append(this.toIndentedString(this.displayAmount)).append("\n");
        sb.append("    supplierAmount: ").append(this.toIndentedString(this.supplierAmount)).append("\n");
        sb.append("    internalAmount: ").append(this.toIndentedString(this.internalAmount)).append("\n");
        sb.append("    captureAmount: ").append(this.toIndentedString(this.captureAmount)).append("\n");
        sb.append("    sourceAmountRefundModifier: ").append(this.toIndentedString(this.sourceAmountRefundModifier)).append("\n");
        sb.append("    displayAmountRefundModifier: ").append(this.toIndentedString(this.displayAmountRefundModifier)).append("\n");
        sb.append("    supplierAmountRefundModifier: ").append(this.toIndentedString(this.supplierAmountRefundModifier)).append("\n");
        sb.append("    internalAmountRefundModifier: ").append(this.toIndentedString(this.internalAmountRefundModifier)).append("\n");
        sb.append("    captureAmountRefundModifier: ").append(this.toIndentedString(this.captureAmountRefundModifier)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    netSupplierAmount: ").append(this.toIndentedString(this.netSupplierAmount)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    cancellableWithPotentialCharges: ").append(this.toIndentedString(this.cancellableWithPotentialCharges)).append("\n");
        sb.append("    netCaptureAmount: ").append(this.toIndentedString(this.netCaptureAmount)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    netSourceAmount: ").append(this.toIndentedString(this.netSourceAmount)).append("\n");
        sb.append("    netDisplayAmount: ").append(this.toIndentedString(this.netDisplayAmount)).append("\n");
        sb.append("    netInternalAmount: ").append(this.toIndentedString(this.netInternalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

