/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.trippay.sdk.payment.model.Acquirer;
import io.trippay.sdk.payment.model.AuthenticatedUser;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import io.trippay.sdk.payment.model.PricedSupplierContractItem;
import io.trippay.sdk.payment.model.Quote;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"federatedOrganizationIdentifier", "federatedOrganizationName", "user", "ipAddress", "traceId", "sourceUrl", "identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "itemList", "acquirerList", "externalSupplierIdentifier", "externalSupplierBookingCode", "externalTransactionIdentifier", "metadata", "totalPrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice"})
public class PricedSupplierContract {
    public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER = "federatedOrganizationIdentifier";
    private String federatedOrganizationIdentifier;
    public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME = "federatedOrganizationName";
    private String federatedOrganizationName;
    public static final String JSON_PROPERTY_USER = "user";
    private AuthenticatedUser user;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private Quote displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private Quote supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private Quote internalPriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<PricedSupplierContractItem> itemList = new ArrayList<PricedSupplierContractItem>();
    public static final String JSON_PROPERTY_ACQUIRER_LIST = "acquirerList";
    private List<Acquirer> acquirerList = new ArrayList<Acquirer>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
    private CustomMonetaryAmount totalPrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private CustomMonetaryAmount totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private CustomMonetaryAmount totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private CustomMonetaryAmount totalInternalPrice;

    public PricedSupplierContract() {
    }

    @JsonCreator
    public PricedSupplierContract(@JsonProperty(value="itemList") List<PricedSupplierContractItem> itemList) {
        this();
        this.itemList = itemList;
    }

    public PricedSupplierContract federatedOrganizationIdentifier(String federatedOrganizationIdentifier) {
        this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="federatedOrganizationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFederatedOrganizationIdentifier() {
        return this.federatedOrganizationIdentifier;
    }

    @JsonProperty(value="federatedOrganizationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFederatedOrganizationIdentifier(String federatedOrganizationIdentifier) {
        this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
    }

    public PricedSupplierContract federatedOrganizationName(String federatedOrganizationName) {
        this.federatedOrganizationName = federatedOrganizationName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="federatedOrganizationName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFederatedOrganizationName() {
        return this.federatedOrganizationName;
    }

    @JsonProperty(value="federatedOrganizationName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFederatedOrganizationName(String federatedOrganizationName) {
        this.federatedOrganizationName = federatedOrganizationName;
    }

    public PricedSupplierContract user(AuthenticatedUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AuthenticatedUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(AuthenticatedUser user) {
        this.user = user;
    }

    public PricedSupplierContract ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public PricedSupplierContract traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public PricedSupplierContract sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public PricedSupplierContract identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public PricedSupplierContract supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public PricedSupplierContract supplierName(String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public PricedSupplierContract displayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(Quote displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public PricedSupplierContract supplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(Quote supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public PricedSupplierContract internalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Quote getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(Quote internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    @Nonnull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @Valid @Size(min=1, max=0x7FFFFFFF) List<PricedSupplierContractItem> getItemList() {
        return this.itemList;
    }

    public PricedSupplierContract acquirerList(List<Acquirer> acquirerList) {
        this.acquirerList = acquirerList;
        return this;
    }

    public PricedSupplierContract addAcquirerListItem(Acquirer acquirerListItem) {
        if (this.acquirerList == null) {
            this.acquirerList = new ArrayList<Acquirer>();
        }
        this.acquirerList.add(acquirerListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="acquirerList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<Acquirer> getAcquirerList() {
        return this.acquirerList;
    }

    @JsonProperty(value="acquirerList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAcquirerList(List<Acquirer> acquirerList) {
        this.acquirerList = acquirerList;
    }

    public PricedSupplierContract externalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
    }

    public PricedSupplierContract externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public PricedSupplierContract externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public PricedSupplierContract metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PricedSupplierContract putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PricedSupplierContract totalPrice(CustomMonetaryAmount totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="totalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalPrice(CustomMonetaryAmount totalPrice) {
        this.totalPrice = totalPrice;
    }

    public PricedSupplierContract totalDisplayPrice(CustomMonetaryAmount totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(CustomMonetaryAmount totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public PricedSupplierContract totalSupplierPrice(CustomMonetaryAmount totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(CustomMonetaryAmount totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public PricedSupplierContract totalInternalPrice(CustomMonetaryAmount totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(CustomMonetaryAmount totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedSupplierContract pricedSupplierContract = (PricedSupplierContract)o;
        return Objects.equals(this.federatedOrganizationIdentifier, pricedSupplierContract.federatedOrganizationIdentifier) && Objects.equals(this.federatedOrganizationName, pricedSupplierContract.federatedOrganizationName) && Objects.equals(this.user, pricedSupplierContract.user) && Objects.equals(this.ipAddress, pricedSupplierContract.ipAddress) && Objects.equals(this.traceId, pricedSupplierContract.traceId) && Objects.equals(this.sourceUrl, pricedSupplierContract.sourceUrl) && Objects.equals(this.identifier, pricedSupplierContract.identifier) && Objects.equals(this.supplierIdentifier, pricedSupplierContract.supplierIdentifier) && Objects.equals(this.supplierName, pricedSupplierContract.supplierName) && Objects.equals(this.displayPriceQuote, pricedSupplierContract.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, pricedSupplierContract.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, pricedSupplierContract.internalPriceQuote) && Objects.equals(this.itemList, pricedSupplierContract.itemList) && Objects.equals(this.acquirerList, pricedSupplierContract.acquirerList) && Objects.equals(this.externalSupplierIdentifier, pricedSupplierContract.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, pricedSupplierContract.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, pricedSupplierContract.externalTransactionIdentifier) && Objects.equals(this.metadata, pricedSupplierContract.metadata) && Objects.equals(this.totalPrice, pricedSupplierContract.totalPrice) && Objects.equals(this.totalDisplayPrice, pricedSupplierContract.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, pricedSupplierContract.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, pricedSupplierContract.totalInternalPrice);
    }

    public int hashCode() {
        return Objects.hash(this.federatedOrganizationIdentifier, this.federatedOrganizationName, this.user, this.ipAddress, this.traceId, this.sourceUrl, this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.itemList, this.acquirerList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.externalTransactionIdentifier, this.metadata, this.totalPrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedSupplierContract {\n");
        sb.append("    federatedOrganizationIdentifier: ").append(this.toIndentedString(this.federatedOrganizationIdentifier)).append("\n");
        sb.append("    federatedOrganizationName: ").append(this.toIndentedString(this.federatedOrganizationName)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    acquirerList: ").append(this.toIndentedString(this.acquirerList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

