package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.CreateAccountMappingRequest;
import io.trippay.sdk.payment.model.Mapping;
import io.trippay.sdk.payment.model.PageMapping;
import io.trippay.sdk.payment.model.RemoveEntryResponse;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.UpdateAccountMappingRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-23T12:38:48.722044943+07:00[Asia/Bangkok]")
public class AccountMappingsApi {
    private ApiClient apiClient;

    public AccountMappingsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountMappingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param createAccountMappingRequest The createAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAccountMappingRequestCreation(String accountIdentifier, CreateAccountMappingRequest createAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createAccountMappingRequest;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling createAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createAccountMappingRequest' is set
        if (createAccountMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAccountMappingRequest' when calling createAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param createAccountMappingRequest The createAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> createAccountMapping(String accountIdentifier, CreateAccountMappingRequest createAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createAccountMappingRequestCreation(accountIdentifier, createAccountMappingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param createAccountMappingRequest The createAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> createAccountMappingWithHttpInfo(String accountIdentifier, CreateAccountMappingRequest createAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createAccountMappingRequestCreation(accountIdentifier, createAccountMappingRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Account Mapping
     * Create a mapping between a local account and a remote account.
     * <p><b>201</b> - Created
     * @param accountIdentifier The accountIdentifier parameter
     * @param createAccountMappingRequest The createAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAccountMappingWithResponseSpec(String accountIdentifier, CreateAccountMappingRequest createAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        return createAccountMappingRequestCreation(accountIdentifier, createAccountMappingRequest, winkVersion);
    }
    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountMappingRequestCreation(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling loadAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> loadAccountMapping(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> loadAccountMappingWithHttpInfo(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Account Mapping
     * Show a specific mapping by account and mapping identifier
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountMappingWithResponseSpec(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        return loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion);
    }
    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageMapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadAccountMappingGridRequestCreation(String accountIdentifier, State state, String winkVersion) throws WebClientResponseException {
        Object postBody = state;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling loadAccountMappingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'state' is set
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling loadAccountMappingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageMapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageMapping> loadAccountMappingGrid(String accountIdentifier, State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>() {};
        return loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageMapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageMapping>> loadAccountMappingGridWithHttpInfo(String accountIdentifier, State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>() {};
        return loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Account Mappings
     * List all mappings belonging to a specific account.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadAccountMappingGridWithResponseSpec(String accountIdentifier, State state, String winkVersion) throws WebClientResponseException {
        return loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion);
    }
    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAccountMappingRequestCreation(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling removeAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAccountMapping(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removeAccountMappingWithHttpInfo(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Account Mapping
     * Delete a specific mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAccountMappingWithResponseSpec(String accountIdentifier, String id, String winkVersion) throws WebClientResponseException {
        return removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion);
    }
    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param updateAccountMappingRequest The updateAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAccountMappingRequestCreation(String accountIdentifier, String id, UpdateAccountMappingRequest updateAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = updateAccountMappingRequest;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateAccountMappingRequest' is set
        if (updateAccountMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateAccountMappingRequest' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param updateAccountMappingRequest The updateAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> updateAccountMapping(String accountIdentifier, String id, UpdateAccountMappingRequest updateAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateAccountMappingRequestCreation(accountIdentifier, id, updateAccountMappingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param updateAccountMappingRequest The updateAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> updateAccountMappingWithHttpInfo(String accountIdentifier, String id, UpdateAccountMappingRequest updateAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateAccountMappingRequestCreation(accountIdentifier, id, updateAccountMappingRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Account Mapping
     * Update an existing mapping owned by account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param id The id parameter
     * @param updateAccountMappingRequest The updateAccountMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAccountMappingWithResponseSpec(String accountIdentifier, String id, UpdateAccountMappingRequest updateAccountMappingRequest, String winkVersion) throws WebClientResponseException {
        return updateAccountMappingRequestCreation(accountIdentifier, id, updateAccountMappingRequest, winkVersion);
    }
}
