/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.41.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Fee;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Details of the payment. Payment details will be empty if account type is AGENT
 */
@JsonPropertyOrder({
  BookingContractPaymentDetails.JSON_PROPERTY_ACQUIRER_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_VENDOR,
  BookingContractPaymentDetails.JSON_PROPERTY_TRANSACTION_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_CUSTOMER_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_CHARGE_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_STATUS,
  BookingContractPaymentDetails.JSON_PROPERTY_AGENT_INVOICED_DATE,
  BookingContractPaymentDetails.JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER,
  BookingContractPaymentDetails.JSON_PROPERTY_REDIRECT_URL,
  BookingContractPaymentDetails.JSON_PROPERTY_FEES,
  BookingContractPaymentDetails.JSON_PROPERTY_VENDOR_SPECIFIC
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-23T12:38:48.722044943+07:00[Asia/Bangkok]")
public class BookingContractPaymentDetails {
  public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
  private String acquirerIdentifier;

  /**
   * Name of acquiring vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    AGENT("AGENT"),
    
    NMI("NMI"),
    
    WISE("WISE");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  public static final String JSON_PROPERTY_TRANSACTION_IDENTIFIER = "transactionIdentifier";
  private String transactionIdentifier;

  public static final String JSON_PROPERTY_CUSTOMER_IDENTIFIER = "customerIdentifier";
  private String customerIdentifier;

  public static final String JSON_PROPERTY_CHARGE_IDENTIFIER = "chargeIdentifier";
  private String chargeIdentifier;

  /**
   * Unique transaction id from the vendor upon a successful sale. Agent adds their transaction identifier.
   */
  public enum StatusEnum {
    INITIALIZED("INITIALIZED"),
    
    PROCESSING("PROCESSING"),
    
    SUCCEEDED("SUCCEEDED"),
    
    FAILED("FAILED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_AGENT_INVOICED_DATE = "agentInvoicedDate";
  private java.time.LocalDateTime agentInvoicedDate;

  public static final String JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER = "agentInvoiceIdentifier";
  private String agentInvoiceIdentifier;

  public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
  private String redirectUrl;

  public static final String JSON_PROPERTY_FEES = "fees";
  private List<Fee> fees;

  public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
  private Map<String, String> vendorSpecific = new HashMap<>();

  public BookingContractPaymentDetails() {
  }

  public BookingContractPaymentDetails acquirerIdentifier(String acquirerIdentifier) {
    
    this.acquirerIdentifier = acquirerIdentifier;
    return this;
  }

   /**
   * Unique acquiring identifier. Blank for agent payment
   * @return acquirerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAcquirerIdentifier() {
    return acquirerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerIdentifier(String acquirerIdentifier) {
    this.acquirerIdentifier = acquirerIdentifier;
  }


  public BookingContractPaymentDetails vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of acquiring vendor
   * @return vendor
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public BookingContractPaymentDetails transactionIdentifier(String transactionIdentifier) {
    
    this.transactionIdentifier = transactionIdentifier;
    return this;
  }

   /**
   * Unique transaction id from the vendor. Agent adds their transaction identifier.
   * @return transactionIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionIdentifier() {
    return transactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTransactionIdentifier(String transactionIdentifier) {
    this.transactionIdentifier = transactionIdentifier;
  }


  public BookingContractPaymentDetails customerIdentifier(String customerIdentifier) {
    
    this.customerIdentifier = customerIdentifier;
    return this;
  }

   /**
   * Unique customer id from the vendor. Agent adds their own customer identifier.
   * @return customerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCustomerIdentifier() {
    return customerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCustomerIdentifier(String customerIdentifier) {
    this.customerIdentifier = customerIdentifier;
  }


  public BookingContractPaymentDetails chargeIdentifier(String chargeIdentifier) {
    
    this.chargeIdentifier = chargeIdentifier;
    return this;
  }

   /**
   * Unique charge id from the vendor..
   * @return chargeIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHARGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getChargeIdentifier() {
    return chargeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHARGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChargeIdentifier(String chargeIdentifier) {
    this.chargeIdentifier = chargeIdentifier;
  }


  public BookingContractPaymentDetails status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Unique transaction id from the vendor upon a successful sale. Agent adds their transaction identifier.
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public BookingContractPaymentDetails agentInvoicedDate(java.time.LocalDateTime agentInvoicedDate) {
    
    this.agentInvoicedDate = agentInvoicedDate;
    return this;
  }

   /**
   * The date/time the invoice was generated
   * @return agentInvoicedDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getAgentInvoicedDate() {
    return agentInvoicedDate;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgentInvoicedDate(java.time.LocalDateTime agentInvoicedDate) {
    this.agentInvoicedDate = agentInvoicedDate;
  }


  public BookingContractPaymentDetails agentInvoiceIdentifier(String agentInvoiceIdentifier) {
    
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
    return this;
  }

   /**
   * The specific invoice this booking was registered on
   * @return agentInvoiceIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAgentInvoiceIdentifier() {
    return agentInvoiceIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgentInvoiceIdentifier(String agentInvoiceIdentifier) {
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
  }


  public BookingContractPaymentDetails redirectUrl(String redirectUrl) {
    
    this.redirectUrl = redirectUrl;
    return this;
  }

   /**
   * Where to redirect to after payment [in-]complete
   * @return redirectUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectUrl() {
    return redirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
  }


  public BookingContractPaymentDetails fees(List<Fee> fees) {
    
    this.fees = fees;
    return this;
  }

  public BookingContractPaymentDetails addFeesItem(Fee feesItem) {
    if (this.fees == null) {
      this.fees = new ArrayList<>();
    }
    this.fees.add(feesItem);
    return this;
  }

   /**
   * Get fees
   * @return fees
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Fee> getFees() {
    return fees;
  }


  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFees(List<Fee> fees) {
    this.fees = fees;
  }


  public BookingContractPaymentDetails vendorSpecific(Map<String, String> vendorSpecific) {
    
    this.vendorSpecific = vendorSpecific;
    return this;
  }

  public BookingContractPaymentDetails putVendorSpecificItem(String key, String vendorSpecificItem) {
    this.vendorSpecific.put(key, vendorSpecificItem);
    return this;
  }

   /**
   * Vendor specific values that are returned in a successful response
   * @return vendorSpecific
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Map<String, String> getVendorSpecific() {
    return vendorSpecific;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorSpecific(Map<String, String> vendorSpecific) {
    this.vendorSpecific = vendorSpecific;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractPaymentDetails bookingContractPaymentDetails = (BookingContractPaymentDetails) o;
    return Objects.equals(this.acquirerIdentifier, bookingContractPaymentDetails.acquirerIdentifier) &&
        Objects.equals(this.vendor, bookingContractPaymentDetails.vendor) &&
        Objects.equals(this.transactionIdentifier, bookingContractPaymentDetails.transactionIdentifier) &&
        Objects.equals(this.customerIdentifier, bookingContractPaymentDetails.customerIdentifier) &&
        Objects.equals(this.chargeIdentifier, bookingContractPaymentDetails.chargeIdentifier) &&
        Objects.equals(this.status, bookingContractPaymentDetails.status) &&
        Objects.equals(this.agentInvoicedDate, bookingContractPaymentDetails.agentInvoicedDate) &&
        Objects.equals(this.agentInvoiceIdentifier, bookingContractPaymentDetails.agentInvoiceIdentifier) &&
        Objects.equals(this.redirectUrl, bookingContractPaymentDetails.redirectUrl) &&
        Objects.equals(this.fees, bookingContractPaymentDetails.fees) &&
        Objects.equals(this.vendorSpecific, bookingContractPaymentDetails.vendorSpecific);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerIdentifier, vendor, transactionIdentifier, customerIdentifier, chargeIdentifier, status, agentInvoicedDate, agentInvoiceIdentifier, redirectUrl, fees, vendorSpecific);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractPaymentDetails {\n");
    sb.append("    acquirerIdentifier: ").append(toIndentedString(acquirerIdentifier)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    transactionIdentifier: ").append(toIndentedString(transactionIdentifier)).append("\n");
    sb.append("    customerIdentifier: ").append(toIndentedString(customerIdentifier)).append("\n");
    sb.append("    chargeIdentifier: ").append(toIndentedString(chargeIdentifier)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    agentInvoicedDate: ").append(toIndentedString(agentInvoicedDate)).append("\n");
    sb.append("    agentInvoiceIdentifier: ").append(toIndentedString(agentInvoiceIdentifier)).append("\n");
    sb.append("    redirectUrl: ").append(toIndentedString(redirectUrl)).append("\n");
    sb.append("    fees: ").append(toIndentedString(fees)).append("\n");
    sb.append("    vendorSpecific: ").append(toIndentedString(vendorSpecific)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

