/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.41.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ExternalEvent
 */
@JsonPropertyOrder({
  ExternalEvent.JSON_PROPERTY_ID,
  ExternalEvent.JSON_PROPERTY_CREATED_DATE,
  ExternalEvent.JSON_PROPERTY_LAST_UPDATE,
  ExternalEvent.JSON_PROPERTY_VERSION,
  ExternalEvent.JSON_PROPERTY_INSTANT,
  ExternalEvent.JSON_PROPERTY_SENDER,
  ExternalEvent.JSON_PROPERTY_RECEIVER,
  ExternalEvent.JSON_PROPERTY_TYPE,
  ExternalEvent.JSON_PROPERTY_ENTITY_IDENTIFIER,
  ExternalEvent.JSON_PROPERTY_REQUEST,
  ExternalEvent.JSON_PROPERTY_RESPONSE,
  ExternalEvent.JSON_PROPERTY_MEDIA_TYPE,
  ExternalEvent.JSON_PROPERTY_HTTP_RESPONSE_CODE,
  ExternalEvent.JSON_PROPERTY_SCORE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-23T12:38:48.722044943+07:00[Asia/Bangkok]")
public class ExternalEvent {
  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public static final String JSON_PROPERTY_INSTANT = "instant";
  private java.time.LocalDateTime instant;

  /**
   * The sender of the request payload
   */
  public enum SenderEnum {
    WINK("WINK"),
    
    TRIP_PAY("TRIP_PAY");

    private String value;

    SenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SenderEnum fromValue(String value) {
      for (SenderEnum b : SenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SENDER = "sender";
  private SenderEnum sender;

  /**
   * The receiver of the request payload
   */
  public enum ReceiverEnum {
    INVENTORY_WEBHOOK_LISTENER("INVENTORY_WEBHOOK_LISTENER"),
    
    PAYMENT_WEBHOOK_LISTENER("PAYMENT_WEBHOOK_LISTENER"),
    
    CHANNEL_MANAGER_ALLOTZ("CHANNEL_MANAGER_ALLOTZ"),
    
    CHANNEL_MANAGER_DEDGE("CHANNEL_MANAGER_DEDGE"),
    
    CHANNEL_MANAGER_CHANNEX("CHANNEL_MANAGER_CHANNEX"),
    
    CHANNEL_MANAGER_SITE_MINDER("CHANNEL_MANAGER_SITE_MINDER"),
    
    CHANNEL_MANAGER_TRAVELCLICK("CHANNEL_MANAGER_TRAVELCLICK"),
    
    CHANNEL_MANAGER_OMNIBEES("CHANNEL_MANAGER_OMNIBEES"),
    
    CHANNEL_MANAGER_EZEE("CHANNEL_MANAGER_EZEE"),
    
    CHANNEL_MANAGER_RATE_GAIN_SYNXIS("CHANNEL_MANAGER_RATE_GAIN_SYNXIS");

    private String value;

    ReceiverEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReceiverEnum fromValue(String value) {
      for (ReceiverEnum b : ReceiverEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECEIVER = "receiver";
  private ReceiverEnum receiver;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_ENTITY_IDENTIFIER = "entityIdentifier";
  private String entityIdentifier;

  public static final String JSON_PROPERTY_REQUEST = "request";
  private String request;

  public static final String JSON_PROPERTY_RESPONSE = "response";
  private String response;

  public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
  private String mediaType;

  public static final String JSON_PROPERTY_HTTP_RESPONSE_CODE = "httpResponseCode";
  private Integer httpResponseCode;

  public static final String JSON_PROPERTY_SCORE = "score";
  private Float score;

  public ExternalEvent() {
  }

  @JsonCreator
  public ExternalEvent(
    @JsonProperty(JSON_PROPERTY_ID) UUID id, 
    @JsonProperty(JSON_PROPERTY_CREATED_DATE) java.time.LocalDateTime createdDate, 
    @JsonProperty(JSON_PROPERTY_LAST_UPDATE) java.time.LocalDateTime lastUpdate, 
    @JsonProperty(JSON_PROPERTY_VERSION) Long version
  ) {
    this();
    this.id = id;
    this.createdDate = createdDate;
    this.lastUpdate = lastUpdate;
    this.version = version;
  }

   /**
   * Unique document identifier
   * @return id
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }




   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }




   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }




   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }




  public ExternalEvent instant(java.time.LocalDateTime instant) {
    
    this.instant = instant;
    return this;
  }

   /**
   * Date to attach TTL. Self-deletes after 3 weeks.
   * @return instant
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INSTANT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getInstant() {
    return instant;
  }


  @JsonProperty(JSON_PROPERTY_INSTANT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInstant(java.time.LocalDateTime instant) {
    this.instant = instant;
  }


  public ExternalEvent sender(SenderEnum sender) {
    
    this.sender = sender;
    return this;
  }

   /**
   * The sender of the request payload
   * @return sender
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SenderEnum getSender() {
    return sender;
  }


  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSender(SenderEnum sender) {
    this.sender = sender;
  }


  public ExternalEvent receiver(ReceiverEnum receiver) {
    
    this.receiver = receiver;
    return this;
  }

   /**
   * The receiver of the request payload
   * @return receiver
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_RECEIVER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReceiverEnum getReceiver() {
    return receiver;
  }


  @JsonProperty(JSON_PROPERTY_RECEIVER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReceiver(ReceiverEnum receiver) {
    this.receiver = receiver;
  }


  public ExternalEvent type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of request payload
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }


  public ExternalEvent entityIdentifier(String entityIdentifier) {
    
    this.entityIdentifier = entityIdentifier;
    return this;
  }

   /**
   * The ID of the remote event to query against
   * @return entityIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENTITY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEntityIdentifier() {
    return entityIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEntityIdentifier(String entityIdentifier) {
    this.entityIdentifier = entityIdentifier;
  }


  public ExternalEvent request(String request) {
    
    this.request = request;
    return this;
  }

   /**
   * Request sent to external endpoint
   * @return request
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRequest() {
    return request;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequest(String request) {
    this.request = request;
  }


  public ExternalEvent response(String response) {
    
    this.response = response;
    return this;
  }

   /**
   * Response from external endpoint
   * @return response
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResponse() {
    return response;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponse(String response) {
    this.response = response;
  }


  public ExternalEvent mediaType(String mediaType) {
    
    this.mediaType = mediaType;
    return this;
  }

   /**
   * The content MIME type
   * @return mediaType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MEDIA_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMediaType() {
    return mediaType;
  }


  @JsonProperty(JSON_PROPERTY_MEDIA_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMediaType(String mediaType) {
    this.mediaType = mediaType;
  }


  public ExternalEvent httpResponseCode(Integer httpResponseCode) {
    
    this.httpResponseCode = httpResponseCode;
    return this;
  }

   /**
   * Response status code
   * @return httpResponseCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HTTP_RESPONSE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHttpResponseCode() {
    return httpResponseCode;
  }


  @JsonProperty(JSON_PROPERTY_HTTP_RESPONSE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHttpResponseCode(Integer httpResponseCode) {
    this.httpResponseCode = httpResponseCode;
  }


  public ExternalEvent score(Float score) {
    
    this.score = score;
    return this;
  }

   /**
   * Get score
   * @return score
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getScore() {
    return score;
  }


  @JsonProperty(JSON_PROPERTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScore(Float score) {
    this.score = score;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExternalEvent externalEvent = (ExternalEvent) o;
    return Objects.equals(this.id, externalEvent.id) &&
        Objects.equals(this.createdDate, externalEvent.createdDate) &&
        Objects.equals(this.lastUpdate, externalEvent.lastUpdate) &&
        Objects.equals(this.version, externalEvent.version) &&
        Objects.equals(this.instant, externalEvent.instant) &&
        Objects.equals(this.sender, externalEvent.sender) &&
        Objects.equals(this.receiver, externalEvent.receiver) &&
        Objects.equals(this.type, externalEvent.type) &&
        Objects.equals(this.entityIdentifier, externalEvent.entityIdentifier) &&
        Objects.equals(this.request, externalEvent.request) &&
        Objects.equals(this.response, externalEvent.response) &&
        Objects.equals(this.mediaType, externalEvent.mediaType) &&
        Objects.equals(this.httpResponseCode, externalEvent.httpResponseCode) &&
        Objects.equals(this.score, externalEvent.score);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, instant, sender, receiver, type, entityIdentifier, request, response, mediaType, httpResponseCode, score);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExternalEvent {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    instant: ").append(toIndentedString(instant)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    receiver: ").append(toIndentedString(receiver)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    entityIdentifier: ").append(toIndentedString(entityIdentifier)).append("\n");
    sb.append("    request: ").append(toIndentedString(request)).append("\n");
    sb.append("    response: ").append(toIndentedString(response)).append("\n");
    sb.append("    mediaType: ").append(toIndentedString(mediaType)).append("\n");
    sb.append("    httpResponseCode: ").append(toIndentedString(httpResponseCode)).append("\n");
    sb.append("    score: ").append(toIndentedString(score)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

