/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.RawSupplierContract;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"affiliateAccountIdentifier", "affiliateAccountIdentifierType", "displayCurrency", "sourceUrl", "contractList", "traceId", "redirectUrl", "metadata"})
public class RawBookingContract {
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
    private String affiliateAccountIdentifier;
    public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
    private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_CONTRACT_LIST = "contractList";
    private List<RawSupplierContract> contractList = new ArrayList<RawSupplierContract>();
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    private String redirectUrl;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();

    public RawBookingContract affiliateAccountIdentifier(String affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAffiliateAccountIdentifier() {
        return this.affiliateAccountIdentifier;
    }

    @JsonProperty(value="affiliateAccountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifier(String affiliateAccountIdentifier) {
        this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    }

    public RawBookingContract affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
        return this.affiliateAccountIdentifierType;
    }

    @JsonProperty(value="affiliateAccountIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
        this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    }

    public RawBookingContract displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public RawBookingContract sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public RawBookingContract contractList(List<RawSupplierContract> contractList) {
        this.contractList = contractList;
        return this;
    }

    public RawBookingContract addContractListItem(RawSupplierContract contractListItem) {
        if (this.contractList == null) {
            this.contractList = new ArrayList<RawSupplierContract>();
        }
        this.contractList.add(contractListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RawSupplierContract> getContractList() {
        return this.contractList;
    }

    @JsonProperty(value="contractList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractList(List<RawSupplierContract> contractList) {
        this.contractList = contractList;
    }

    public RawBookingContract traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public RawBookingContract redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public RawBookingContract metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public RawBookingContract putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawBookingContract rawBookingContract = (RawBookingContract)o;
        return Objects.equals(this.affiliateAccountIdentifier, rawBookingContract.affiliateAccountIdentifier) && Objects.equals((Object)this.affiliateAccountIdentifierType, (Object)rawBookingContract.affiliateAccountIdentifierType) && Objects.equals(this.displayCurrency, rawBookingContract.displayCurrency) && Objects.equals(this.sourceUrl, rawBookingContract.sourceUrl) && Objects.equals(this.contractList, rawBookingContract.contractList) && Objects.equals(this.traceId, rawBookingContract.traceId) && Objects.equals(this.redirectUrl, rawBookingContract.redirectUrl) && Objects.equals(this.metadata, rawBookingContract.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.affiliateAccountIdentifier, this.affiliateAccountIdentifierType, this.displayCurrency, this.sourceUrl, this.contractList, this.traceId, this.redirectUrl, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RawBookingContract {\n");
        sb.append("    affiliateAccountIdentifier: ").append(this.toIndentedString(this.affiliateAccountIdentifier)).append("\n");
        sb.append("    affiliateAccountIdentifierType: ").append(this.toIndentedString((Object)this.affiliateAccountIdentifierType)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    contractList: ").append(this.toIndentedString(this.contractList)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AffiliateAccountIdentifierTypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private AffiliateAccountIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
            for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

