package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.ExternalEvent;
import io.trippay.sdk.payment.model.PageExternalEvent;
import io.trippay.sdk.payment.model.State;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-24T07:24:28.877872362+07:00[Asia/Bangkok]")
public class ExternalEventApi {
    private ApiClient apiClient;

    public ExternalEventApi() {
        this(new ApiClient());
    }

    @Autowired
    public ExternalEventApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show External Event
     * Displays external event for specified event ID.
     * <p><b>200</b> - OK
     * @param eventIdentifier ID of event to retrieve
     * @param winkVersion The winkVersion parameter
     * @return ExternalEvent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showExternalEventRequestCreation(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'eventIdentifier' is set
        if (eventIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'eventIdentifier' when calling showExternalEvent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("eventIdentifier", eventIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>() {};
        return apiClient.invokeAPI("/api/administration/external-event/{eventIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show External Event
     * Displays external event for specified event ID.
     * <p><b>200</b> - OK
     * @param eventIdentifier ID of event to retrieve
     * @param winkVersion The winkVersion parameter
     * @return ExternalEvent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ExternalEvent> showExternalEvent(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>() {};
        return showExternalEventRequestCreation(eventIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show External Event
     * Displays external event for specified event ID.
     * <p><b>200</b> - OK
     * @param eventIdentifier ID of event to retrieve
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ExternalEvent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ExternalEvent>> showExternalEventWithHttpInfo(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>() {};
        return showExternalEventRequestCreation(eventIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show External Event
     * Displays external event for specified event ID.
     * <p><b>200</b> - OK
     * @param eventIdentifier ID of event to retrieve
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showExternalEventWithResponseSpec(String eventIdentifier, String winkVersion) throws WebClientResponseException {
        return showExternalEventRequestCreation(eventIdentifier, winkVersion);
    }
    /**
     * Show External Event Grid
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageExternalEvent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showExternalEventGridRequestCreation(State state, String winkVersion) throws WebClientResponseException {
        Object postBody = state;
        // verify the required parameter 'state' is set
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showExternalEventGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageExternalEvent> localVarReturnType = new ParameterizedTypeReference<PageExternalEvent>() {};
        return apiClient.invokeAPI("/api/administration/external-event/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show External Event Grid
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageExternalEvent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageExternalEvent> showExternalEventGrid(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExternalEvent> localVarReturnType = new ParameterizedTypeReference<PageExternalEvent>() {};
        return showExternalEventGridRequestCreation(state, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show External Event Grid
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageExternalEvent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageExternalEvent>> showExternalEventGridWithHttpInfo(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageExternalEvent> localVarReturnType = new ParameterizedTypeReference<PageExternalEvent>() {};
        return showExternalEventGridRequestCreation(state, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show External Event Grid
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showExternalEventGridWithResponseSpec(State state, String winkVersion) throws WebClientResponseException {
        return showExternalEventGridRequestCreation(state, winkVersion);
    }
    /**
     * Show External Events
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ExternalEvent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showExternalEventListRequestCreation(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'entityIdentifier' is set
        if (entityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'entityIdentifier' when calling showExternalEventList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("entityIdentifier", entityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>() {};
        return apiClient.invokeAPI("/api/administration/external-event/{entityIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show External Events
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ExternalEvent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ExternalEvent> showExternalEventList(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>() {};
        return showExternalEventListRequestCreation(entityIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show External Events
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;ExternalEvent&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ExternalEvent>>> showExternalEventListWithHttpInfo(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalEvent> localVarReturnType = new ParameterizedTypeReference<ExternalEvent>() {};
        return showExternalEventListRequestCreation(entityIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show External Events
     * Displays external events for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showExternalEventListWithResponseSpec(String entityIdentifier, String winkVersion) throws WebClientResponseException {
        return showExternalEventListRequestCreation(entityIdentifier, winkVersion);
    }
}
