/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.48.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.ActivityStreamUser;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ActivityStream
 */
@JsonPropertyOrder({
  ActivityStream.JSON_PROPERTY_ID,
  ActivityStream.JSON_PROPERTY_CREATED_DATE,
  ActivityStream.JSON_PROPERTY_LAST_UPDATE,
  ActivityStream.JSON_PROPERTY_VERSION,
  ActivityStream.JSON_PROPERTY_ACL,
  ActivityStream.JSON_PROPERTY_ENTITY_IDENTIFIER,
  ActivityStream.JSON_PROPERTY_EMOTION,
  ActivityStream.JSON_PROPERTY_COMMENT,
  ActivityStream.JSON_PROPERTY_I18N_KEY,
  ActivityStream.JSON_PROPERTY_ATTACHMENT_ID,
  ActivityStream.JSON_PROPERTY_USER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-24T07:24:28.877872362+07:00[Asia/Bangkok]")
public class ActivityStream {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  /**
   * Who can track this stream?
   */
  public enum AclEnum {
    EVERYONE("EVERYONE"),
    
    AUTHENTICATED("AUTHENTICATED"),
    
    OWNER("OWNER"),
    
    ADMIN("ADMIN");

    private String value;

    AclEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AclEnum fromValue(String value) {
      for (AclEnum b : AclEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACL = "acl";
  private AclEnum acl;

  public static final String JSON_PROPERTY_ENTITY_IDENTIFIER = "entityIdentifier";
  private UUID entityIdentifier;

  public static final String JSON_PROPERTY_EMOTION = "emotion";
  private String emotion;

  public static final String JSON_PROPERTY_COMMENT = "comment";
  private String comment;

  public static final String JSON_PROPERTY_I18N_KEY = "i18nKey";
  private String i18nKey;

  public static final String JSON_PROPERTY_ATTACHMENT_ID = "attachmentId";
  private String attachmentId;

  public static final String JSON_PROPERTY_USER = "user";
  private ActivityStreamUser user;

  public ActivityStream() {
  }

  public ActivityStream id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public ActivityStream createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public ActivityStream lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public ActivityStream version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public ActivityStream acl(AclEnum acl) {
    
    this.acl = acl;
    return this;
  }

   /**
   * Who can track this stream?
   * @return acl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AclEnum getAcl() {
    return acl;
  }


  @JsonProperty(JSON_PROPERTY_ACL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcl(AclEnum acl) {
    this.acl = acl;
  }


  public ActivityStream entityIdentifier(UUID entityIdentifier) {
    
    this.entityIdentifier = entityIdentifier;
    return this;
  }

   /**
   * ID of tracked entity
   * @return entityIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENTITY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEntityIdentifier() {
    return entityIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEntityIdentifier(UUID entityIdentifier) {
    this.entityIdentifier = entityIdentifier;
  }


  public ActivityStream emotion(String emotion) {
    
    this.emotion = emotion;
    return this;
  }

   /**
   * Optional emotion. The actual implementation of the emotion is down to the consumer of the stream.
   * @return emotion
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmotion() {
    return emotion;
  }


  @JsonProperty(JSON_PROPERTY_EMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmotion(String emotion) {
    this.emotion = emotion;
  }


  public ActivityStream comment(String comment) {
    
    this.comment = comment;
    return this;
  }

   /**
   * Optional comment. For when the activity was created manually by a user. If i18nKey is not populated, comment is required.
   * @return comment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getComment() {
    return comment;
  }


  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComment(String comment) {
    this.comment = comment;
  }


  public ActivityStream i18nKey(String i18nKey) {
    
    this.i18nKey = i18nKey;
    return this;
  }

   /**
   * Localized key. Key will be used to generate text on the front-end. If comment is not populated, i18n is required.
   * @return i18nKey
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_I18N_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getI18nKey() {
    return i18nKey;
  }


  @JsonProperty(JSON_PROPERTY_I18N_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setI18nKey(String i18nKey) {
    this.i18nKey = i18nKey;
  }


  public ActivityStream attachmentId(String attachmentId) {
    
    this.attachmentId = attachmentId;
    return this;
  }

   /**
   * Optional attachment. For when we allow users to upload documents to the activity via Cloudinary.
   * @return attachmentId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTACHMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAttachmentId() {
    return attachmentId;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachmentId(String attachmentId) {
    this.attachmentId = attachmentId;
  }


  public ActivityStream user(ActivityStreamUser user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ActivityStreamUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(ActivityStreamUser user) {
    this.user = user;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivityStream activityStream = (ActivityStream) o;
    return Objects.equals(this.id, activityStream.id) &&
        Objects.equals(this.createdDate, activityStream.createdDate) &&
        Objects.equals(this.lastUpdate, activityStream.lastUpdate) &&
        Objects.equals(this.version, activityStream.version) &&
        Objects.equals(this.acl, activityStream.acl) &&
        Objects.equals(this.entityIdentifier, activityStream.entityIdentifier) &&
        Objects.equals(this.emotion, activityStream.emotion) &&
        Objects.equals(this.comment, activityStream.comment) &&
        Objects.equals(this.i18nKey, activityStream.i18nKey) &&
        Objects.equals(this.attachmentId, activityStream.attachmentId) &&
        Objects.equals(this.user, activityStream.user);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, acl, entityIdentifier, emotion, comment, i18nKey, attachmentId, user);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivityStream {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    acl: ").append(toIndentedString(acl)).append("\n");
    sb.append("    entityIdentifier: ").append(toIndentedString(entityIdentifier)).append("\n");
    sb.append("    emotion: ").append(toIndentedString(emotion)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    i18nKey: ").append(toIndentedString(i18nKey)).append("\n");
    sb.append("    attachmentId: ").append(toIndentedString(attachmentId)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

