package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.CreateIssuingCardEphemeralKeyRequest;
import io.trippay.sdk.payment.model.CreateIssuingCardEphemeralKeyResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T08:58:01.141341582+07:00[Asia/Bangkok]")
public class PayoutApi {
    private ApiClient apiClient;

    public PayoutApi() {
        this(new ApiClient());
    }

    @Autowired
    public PayoutApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Stripe ephemeral key
     * Ephemeral keys are required to do display an issuing card to the user, among other things.
     * <p><b>201</b> - Created
     * @param createIssuingCardEphemeralKeyRequest The createIssuingCardEphemeralKeyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreateIssuingCardEphemeralKeyResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createEphemeralKeyRequestCreation(CreateIssuingCardEphemeralKeyRequest createIssuingCardEphemeralKeyRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createIssuingCardEphemeralKeyRequest;
        // verify the required parameter 'createIssuingCardEphemeralKeyRequest' is set
        if (createIssuingCardEphemeralKeyRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createIssuingCardEphemeralKeyRequest' when calling createEphemeralKey", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CreateIssuingCardEphemeralKeyResponse> localVarReturnType = new ParameterizedTypeReference<CreateIssuingCardEphemeralKeyResponse>() {};
        return apiClient.invokeAPI("/api/issuing-card/ephemeral", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Stripe ephemeral key
     * Ephemeral keys are required to do display an issuing card to the user, among other things.
     * <p><b>201</b> - Created
     * @param createIssuingCardEphemeralKeyRequest The createIssuingCardEphemeralKeyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreateIssuingCardEphemeralKeyResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateIssuingCardEphemeralKeyResponse> createEphemeralKey(CreateIssuingCardEphemeralKeyRequest createIssuingCardEphemeralKeyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateIssuingCardEphemeralKeyResponse> localVarReturnType = new ParameterizedTypeReference<CreateIssuingCardEphemeralKeyResponse>() {};
        return createEphemeralKeyRequestCreation(createIssuingCardEphemeralKeyRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Stripe ephemeral key
     * Ephemeral keys are required to do display an issuing card to the user, among other things.
     * <p><b>201</b> - Created
     * @param createIssuingCardEphemeralKeyRequest The createIssuingCardEphemeralKeyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CreateIssuingCardEphemeralKeyResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CreateIssuingCardEphemeralKeyResponse>> createEphemeralKeyWithHttpInfo(CreateIssuingCardEphemeralKeyRequest createIssuingCardEphemeralKeyRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateIssuingCardEphemeralKeyResponse> localVarReturnType = new ParameterizedTypeReference<CreateIssuingCardEphemeralKeyResponse>() {};
        return createEphemeralKeyRequestCreation(createIssuingCardEphemeralKeyRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Stripe ephemeral key
     * Ephemeral keys are required to do display an issuing card to the user, among other things.
     * <p><b>201</b> - Created
     * @param createIssuingCardEphemeralKeyRequest The createIssuingCardEphemeralKeyRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createEphemeralKeyWithResponseSpec(CreateIssuingCardEphemeralKeyRequest createIssuingCardEphemeralKeyRequest, String winkVersion) throws WebClientResponseException {
        return createEphemeralKeyRequestCreation(createIssuingCardEphemeralKeyRequest, winkVersion);
    }
}
