/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2021-12-01: v1 - Initial release 
 *
 * The version of the OpenAPI document: 29.56.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BeneficiaryAggregateData
 */
@JsonPropertyOrder({
  BeneficiaryAggregateData.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  BeneficiaryAggregateData.JSON_PROPERTY_ACCOUNT_NAME,
  BeneficiaryAggregateData.JSON_PROPERTY_TYPE,
  BeneficiaryAggregateData.JSON_PROPERTY_TOTAL_ITEMS_SOLD,
  BeneficiaryAggregateData.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BeneficiaryAggregateData.JSON_PROPERTY_INTERNAL_CURRENCY,
  BeneficiaryAggregateData.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BeneficiaryAggregateData.JSON_PROPERTY_INTERNAL_AMOUNT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T08:58:01.141341582+07:00[Asia/Bangkok]")
public class BeneficiaryAggregateData {
  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private UUID accountIdentifier;

  public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
  private String accountName;

  /**
   * Type of payment to beneficiary
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    TRIP_PAY("TRIP_PAY"),
    
    SALE("SALE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_TOTAL_ITEMS_SOLD = "totalItemsSold";
  private Long totalItemsSold;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private BigDecimal internalAmount;

  public BeneficiaryAggregateData() {
  }

  public BeneficiaryAggregateData accountIdentifier(UUID accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

   /**
   * Beneficiary account identifier
   * @return accountIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(UUID accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }


  public BeneficiaryAggregateData accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * Beneficiary account name
   * @return accountName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountName() {
    return accountName;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public BeneficiaryAggregateData type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of payment to beneficiary
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BeneficiaryAggregateData totalItemsSold(Long totalItemsSold) {
    
    this.totalItemsSold = totalItemsSold;
    return this;
  }

   /**
   * Total items sold
   * @return totalItemsSold
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TOTAL_ITEMS_SOLD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getTotalItemsSold() {
    return totalItemsSold;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_ITEMS_SOLD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalItemsSold(Long totalItemsSold) {
    this.totalItemsSold = totalItemsSold;
  }


  public BeneficiaryAggregateData supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * The supplier currency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public BeneficiaryAggregateData internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * The internal currency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public BeneficiaryAggregateData supplierAmount(BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * Amount sold in supplier currency
   * @return supplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public BeneficiaryAggregateData internalAmount(BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * Amount sold in internal currency
   * @return internalAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalAmount(BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BeneficiaryAggregateData beneficiaryAggregateData = (BeneficiaryAggregateData) o;
    return Objects.equals(this.accountIdentifier, beneficiaryAggregateData.accountIdentifier) &&
        Objects.equals(this.accountName, beneficiaryAggregateData.accountName) &&
        Objects.equals(this.type, beneficiaryAggregateData.type) &&
        Objects.equals(this.totalItemsSold, beneficiaryAggregateData.totalItemsSold) &&
        Objects.equals(this.supplierCurrency, beneficiaryAggregateData.supplierCurrency) &&
        Objects.equals(this.internalCurrency, beneficiaryAggregateData.internalCurrency) &&
        Objects.equals(this.supplierAmount, beneficiaryAggregateData.supplierAmount) &&
        Objects.equals(this.internalAmount, beneficiaryAggregateData.internalAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentifier, accountName, type, totalItemsSold, supplierCurrency, internalCurrency, supplierAmount, internalAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BeneficiaryAggregateData {\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    totalItemsSold: ").append(toIndentedString(totalItemsSold)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

