package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.AffiliateDetailsRequest;
import io.trippay.sdk.payment.model.AffiliateInformation;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T22:21:19.072173344+07:00[Asia/Bangkok]")
public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Affiliate Details
     * Returns basic affiliate details.
     * <p><b>200</b> - OK
     * @param affiliateDetailsRequest The affiliateDetailsRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateInformation
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAffiliateDetailsRequestCreation(AffiliateDetailsRequest affiliateDetailsRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = affiliateDetailsRequest;
        // verify the required parameter 'affiliateDetailsRequest' is set
        if (affiliateDetailsRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'affiliateDetailsRequest' when calling showAffiliateDetails", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateInformation> localVarReturnType = new ParameterizedTypeReference<AffiliateInformation>() {};
        return apiClient.invokeAPI("/api/contract/affiliate/details", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Affiliate Details
     * Returns basic affiliate details.
     * <p><b>200</b> - OK
     * @param affiliateDetailsRequest The affiliateDetailsRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateInformation
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateInformation> showAffiliateDetails(AffiliateDetailsRequest affiliateDetailsRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateInformation> localVarReturnType = new ParameterizedTypeReference<AffiliateInformation>() {};
        return showAffiliateDetailsRequestCreation(affiliateDetailsRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Affiliate Details
     * Returns basic affiliate details.
     * <p><b>200</b> - OK
     * @param affiliateDetailsRequest The affiliateDetailsRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateInformation&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateInformation>> showAffiliateDetailsWithHttpInfo(AffiliateDetailsRequest affiliateDetailsRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateInformation> localVarReturnType = new ParameterizedTypeReference<AffiliateInformation>() {};
        return showAffiliateDetailsRequestCreation(affiliateDetailsRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Affiliate Details
     * Returns basic affiliate details.
     * <p><b>200</b> - OK
     * @param affiliateDetailsRequest The affiliateDetailsRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAffiliateDetailsWithResponseSpec(AffiliateDetailsRequest affiliateDetailsRequest, String winkVersion) throws WebClientResponseException {
        return showAffiliateDetailsRequestCreation(affiliateDetailsRequest, winkVersion);
    }
}
