/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.AccountStatusEntry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"accountIdentifier", "status", "taskList"})
public class AccountStatusResponse {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private UUID accountIdentifier;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TASK_LIST = "taskList";
    private List<AccountStatusEntry> taskList;

    public AccountStatusResponse accountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public AccountStatusResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AccountStatusResponse taskList(List<AccountStatusEntry> taskList) {
        this.taskList = taskList;
        return this;
    }

    public AccountStatusResponse addTaskListItem(AccountStatusEntry taskListItem) {
        if (this.taskList == null) {
            this.taskList = new ArrayList<AccountStatusEntry>();
        }
        this.taskList.add(taskListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="taskList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountStatusEntry> getTaskList() {
        return this.taskList;
    }

    @JsonProperty(value="taskList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskList(List<AccountStatusEntry> taskList) {
        this.taskList = taskList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountStatusResponse accountStatusResponse = (AccountStatusResponse)o;
        return Objects.equals(this.accountIdentifier, accountStatusResponse.accountIdentifier) && Objects.equals((Object)this.status, (Object)accountStatusResponse.status) && Objects.equals(this.taskList, accountStatusResponse.taskList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.status, this.taskList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountStatusResponse {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    taskList: ").append(this.toIndentedString(this.taskList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        REGISTERED("REGISTERED"),
        REVIEW("REVIEW"),
        APPROVED("APPROVED"),
        DEACTIVATED("DEACTIVATED"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

