package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.ManagingEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-17T14:03:57.601474390+07:00[Asia/Bangkok]")
public class ManagingEntityApi {
    private ApiClient apiClient;

    public ManagingEntityApi() {
        this(new ApiClient());
    }

    @Autowired
    public ManagingEntityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ManagingEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showManagingEntitiesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>() {};
        return apiClient.invokeAPI("/api/managing-entity/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ManagingEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ManagingEntity> showManagingEntities(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>() {};
        return showManagingEntitiesRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;ManagingEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ManagingEntity>>> showManagingEntitiesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>() {};
        return showManagingEntitiesRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showManagingEntitiesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showManagingEntitiesRequestCreation(winkVersion);
    }
}
