/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.CreateMappingRequest;
import io.trippay.sdk.payment.model.Mapping;
import io.trippay.sdk.payment.model.UpdateMappingRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MappingApi {
    private ApiClient apiClient;

    public MappingApi() {
        this(new ApiClient());
    }

    @Autowired
    public MappingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createMappingRequestCreation(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        CreateMappingRequest postBody = createMappingRequest;
        if (createMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMappingRequest' when calling createMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> createMapping(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.createMappingRequestCreation(createMappingRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> createMappingWithHttpInfo(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.createMappingRequestCreation(createMappingRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createMappingWithResponseSpec(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        return this.createMappingRequestCreation(createMappingRequest, winkVersion);
    }

    private WebClient.ResponseSpec loadMappingRequestCreation(String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> loadMapping(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingRequestCreation(id, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> loadMappingWithHttpInfo(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingRequestCreation(id, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadMappingWithResponseSpec(String id, String winkVersion) throws WebClientResponseException {
        return this.loadMappingRequestCreation(id, winkVersion);
    }

    private WebClient.ResponseSpec loadMappingByExternalIdentifierRequestCreation(String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> loadMappingByExternalIdentifier(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingByExternalIdentifierRequestCreation(id, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> loadMappingByExternalIdentifierWithHttpInfo(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingByExternalIdentifierRequestCreation(id, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadMappingByExternalIdentifierWithResponseSpec(String id, String winkVersion) throws WebClientResponseException {
        return this.loadMappingByExternalIdentifierRequestCreation(id, winkVersion);
    }

    private WebClient.ResponseSpec loadMappingsRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Mapping> loadMappings(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingsRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Mapping>>> loadMappingsWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.loadMappingsRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadMappingsWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.loadMappingsRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec removeMappingRequestCreation(String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> removeMapping(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingRequestCreation(id, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> removeMappingWithHttpInfo(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingRequestCreation(id, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMappingWithResponseSpec(String id, String winkVersion) throws WebClientResponseException {
        return this.removeMappingRequestCreation(id, winkVersion);
    }

    private WebClient.ResponseSpec removeMappingByExternalIdentifierRequestCreation(String id, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> removeMappingByExternalIdentifier(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingByExternalIdentifierRequestCreation(id, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> removeMappingByExternalIdentifierWithHttpInfo(String id, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.removeMappingByExternalIdentifierRequestCreation(id, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMappingByExternalIdentifierWithResponseSpec(String id, String winkVersion) throws WebClientResponseException {
        return this.removeMappingByExternalIdentifierRequestCreation(id, winkVersion);
    }

    private WebClient.ResponseSpec updateMappingRequestCreation(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        UpdateMappingRequest postBody = updateMappingRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> updateMapping(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingRequestCreation(id, updateMappingRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> updateMappingWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingRequestCreation(id, updateMappingRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMappingWithResponseSpec(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        return this.updateMappingRequestCreation(id, updateMappingRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateMappingByExternalIdentifierRequestCreation(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        UpdateMappingRequest postBody = updateMappingRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> updateMappingByExternalIdentifier(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> updateMappingByExternalIdentifierWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(){};
        return this.updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMappingByExternalIdentifierWithResponseSpec(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        return this.updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest, winkVersion);
    }
}

