package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.BookingContractResponse;
import io.trippay.sdk.payment.model.CreatePaymentIntentRequest;
import io.trippay.sdk.payment.model.CreatePaymentIntentResponse;
import io.trippay.sdk.payment.model.CreateStripeSaleRequest;
import io.trippay.sdk.payment.model.CustomerPaymentMethodsResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:59:48.074544651+07:00[Asia/Bangkok]")
public class AcquiringApi {
    private ApiClient apiClient;

    public AcquiringApi() {
        this(new ApiClient());
    }

    @Autowired
    public AcquiringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Complete Stripe Capture
     * Upon a successful card capture, we store customer details for later use.
     * <p><b>201</b> - Created
     * @param createStripeSaleRequest The createStripeSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec captureSaleRequestCreation(CreateStripeSaleRequest createStripeSaleRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createStripeSaleRequest;
        // verify the required parameter 'createStripeSaleRequest' is set
        if (createStripeSaleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStripeSaleRequest' when calling captureSale", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return apiClient.invokeAPI("/api/acquiring/stripe/sale", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Complete Stripe Capture
     * Upon a successful card capture, we store customer details for later use.
     * <p><b>201</b> - Created
     * @param createStripeSaleRequest The createStripeSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractResponse> captureSale(CreateStripeSaleRequest createStripeSaleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return captureSaleRequestCreation(createStripeSaleRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Complete Stripe Capture
     * Upon a successful card capture, we store customer details for later use.
     * <p><b>201</b> - Created
     * @param createStripeSaleRequest The createStripeSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContractResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContractResponse>> captureSaleWithHttpInfo(CreateStripeSaleRequest createStripeSaleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractResponse>() {};
        return captureSaleRequestCreation(createStripeSaleRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Complete Stripe Capture
     * Upon a successful card capture, we store customer details for later use.
     * <p><b>201</b> - Created
     * @param createStripeSaleRequest The createStripeSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec captureSaleWithResponseSpec(CreateStripeSaleRequest createStripeSaleRequest, String winkVersion) throws WebClientResponseException {
        return captureSaleRequestCreation(createStripeSaleRequest, winkVersion);
    }
    /**
     * Create Stripe Payment Intent
     * Creates a Stripe PaymentIntent and creates a new customer for that intent.
     * <p><b>201</b> - Created
     * @param createPaymentIntentRequest The createPaymentIntentRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreatePaymentIntentResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPaymentIntentRequestCreation(CreatePaymentIntentRequest createPaymentIntentRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createPaymentIntentRequest;
        // verify the required parameter 'createPaymentIntentRequest' is set
        if (createPaymentIntentRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createPaymentIntentRequest' when calling createPaymentIntent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CreatePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreatePaymentIntentResponse>() {};
        return apiClient.invokeAPI("/api/acquiring/stripe/payment/intent", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Stripe Payment Intent
     * Creates a Stripe PaymentIntent and creates a new customer for that intent.
     * <p><b>201</b> - Created
     * @param createPaymentIntentRequest The createPaymentIntentRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreatePaymentIntentResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreatePaymentIntentResponse> createPaymentIntent(CreatePaymentIntentRequest createPaymentIntentRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreatePaymentIntentResponse>() {};
        return createPaymentIntentRequestCreation(createPaymentIntentRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Stripe Payment Intent
     * Creates a Stripe PaymentIntent and creates a new customer for that intent.
     * <p><b>201</b> - Created
     * @param createPaymentIntentRequest The createPaymentIntentRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CreatePaymentIntentResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CreatePaymentIntentResponse>> createPaymentIntentWithHttpInfo(CreatePaymentIntentRequest createPaymentIntentRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePaymentIntentResponse> localVarReturnType = new ParameterizedTypeReference<CreatePaymentIntentResponse>() {};
        return createPaymentIntentRequestCreation(createPaymentIntentRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Stripe Payment Intent
     * Creates a Stripe PaymentIntent and creates a new customer for that intent.
     * <p><b>201</b> - Created
     * @param createPaymentIntentRequest The createPaymentIntentRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPaymentIntentWithResponseSpec(CreatePaymentIntentRequest createPaymentIntentRequest, String winkVersion) throws WebClientResponseException {
        return createPaymentIntentRequestCreation(createPaymentIntentRequest, winkVersion);
    }
    /**
     * List Payment Methods
     * List past payment methods by an existing customer record.
     * <p><b>200</b> - OK
     * @param acquirerId The acquirerId parameter
     * @param winkVersion The winkVersion parameter
     * @return CustomerPaymentMethodsResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCustomerPaymentMethodsRequestCreation(String acquirerId, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'acquirerId' is set
        if (acquirerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'acquirerId' when calling showCustomerPaymentMethods", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "acquirerId", acquirerId));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CustomerPaymentMethodsResponse> localVarReturnType = new ParameterizedTypeReference<CustomerPaymentMethodsResponse>() {};
        return apiClient.invokeAPI("/api/acquiring/stripe/payment/method/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List Payment Methods
     * List past payment methods by an existing customer record.
     * <p><b>200</b> - OK
     * @param acquirerId The acquirerId parameter
     * @param winkVersion The winkVersion parameter
     * @return CustomerPaymentMethodsResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CustomerPaymentMethodsResponse> showCustomerPaymentMethods(String acquirerId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CustomerPaymentMethodsResponse> localVarReturnType = new ParameterizedTypeReference<CustomerPaymentMethodsResponse>() {};
        return showCustomerPaymentMethodsRequestCreation(acquirerId, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * List Payment Methods
     * List past payment methods by an existing customer record.
     * <p><b>200</b> - OK
     * @param acquirerId The acquirerId parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CustomerPaymentMethodsResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CustomerPaymentMethodsResponse>> showCustomerPaymentMethodsWithHttpInfo(String acquirerId, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CustomerPaymentMethodsResponse> localVarReturnType = new ParameterizedTypeReference<CustomerPaymentMethodsResponse>() {};
        return showCustomerPaymentMethodsRequestCreation(acquirerId, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * List Payment Methods
     * List past payment methods by an existing customer record.
     * <p><b>200</b> - OK
     * @param acquirerId The acquirerId parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCustomerPaymentMethodsWithResponseSpec(String acquirerId, String winkVersion) throws WebClientResponseException {
        return showCustomerPaymentMethodsRequestCreation(acquirerId, winkVersion);
    }
}
