package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.CreateAgentSaleRequest;
import io.trippay.sdk.payment.model.MultiBookingContractResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:59:48.074544651+07:00[Asia/Bangkok]")
public class AgentApi {
    private ApiClient apiClient;

    public AgentApi() {
        this(new ApiClient());
    }

    @Autowired
    public AgentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Agent Sale
     * Attempt an immediate sale with Agent as acquirer. Checks for valid funds in account before booking instruction.
     * <p><b>201</b> - Created
     * @param createAgentSaleRequest The createAgentSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return MultiBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAgentSaleRequestCreation(CreateAgentSaleRequest createAgentSaleRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createAgentSaleRequest;
        // verify the required parameter 'createAgentSaleRequest' is set
        if (createAgentSaleRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentSaleRequest' when calling createAgentSale", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MultiBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<MultiBookingContractResponse>() {};
        return apiClient.invokeAPI("/api/contract/payment/agent/sale", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Agent Sale
     * Attempt an immediate sale with Agent as acquirer. Checks for valid funds in account before booking instruction.
     * <p><b>201</b> - Created
     * @param createAgentSaleRequest The createAgentSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return MultiBookingContractResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MultiBookingContractResponse> createAgentSale(CreateAgentSaleRequest createAgentSaleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultiBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<MultiBookingContractResponse>() {};
        return createAgentSaleRequestCreation(createAgentSaleRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Agent Sale
     * Attempt an immediate sale with Agent as acquirer. Checks for valid funds in account before booking instruction.
     * <p><b>201</b> - Created
     * @param createAgentSaleRequest The createAgentSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MultiBookingContractResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MultiBookingContractResponse>> createAgentSaleWithHttpInfo(CreateAgentSaleRequest createAgentSaleRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultiBookingContractResponse> localVarReturnType = new ParameterizedTypeReference<MultiBookingContractResponse>() {};
        return createAgentSaleRequestCreation(createAgentSaleRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Agent Sale
     * Attempt an immediate sale with Agent as acquirer. Checks for valid funds in account before booking instruction.
     * <p><b>201</b> - Created
     * @param createAgentSaleRequest The createAgentSaleRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAgentSaleWithResponseSpec(CreateAgentSaleRequest createAgentSaleRequest, String winkVersion) throws WebClientResponseException {
        return createAgentSaleRequestCreation(createAgentSaleRequest, winkVersion);
    }
}
