/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"accountIdentifier", "accountName", "type", "totalItemsSold", "supplierCurrency", "internalCurrency", "supplierAmount", "internalAmount"})
public class BeneficiaryAggregateData {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private UUID accountIdentifier;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_TOTAL_ITEMS_SOLD = "totalItemsSold";
    private Long totalItemsSold;
    public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
    private String supplierCurrency;
    public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
    private String internalCurrency;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
    private BigDecimal supplierAmount;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
    private BigDecimal internalAmount;

    public BeneficiaryAggregateData accountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public BeneficiaryAggregateData accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountName() {
        return this.accountName;
    }

    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public BeneficiaryAggregateData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BeneficiaryAggregateData totalItemsSold(Long totalItemsSold) {
        this.totalItemsSold = totalItemsSold;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="totalItemsSold")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTotalItemsSold() {
        return this.totalItemsSold;
    }

    @JsonProperty(value="totalItemsSold")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalItemsSold(Long totalItemsSold) {
        this.totalItemsSold = totalItemsSold;
    }

    public BeneficiaryAggregateData supplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierCurrency() {
        return this.supplierCurrency;
    }

    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
    }

    public BeneficiaryAggregateData internalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInternalCurrency() {
        return this.internalCurrency;
    }

    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
    }

    public BeneficiaryAggregateData supplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getSupplierAmount() {
        return this.supplierAmount;
    }

    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
    }

    public BeneficiaryAggregateData internalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getInternalAmount() {
        return this.internalAmount;
    }

    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeneficiaryAggregateData beneficiaryAggregateData = (BeneficiaryAggregateData)o;
        return Objects.equals(this.accountIdentifier, beneficiaryAggregateData.accountIdentifier) && Objects.equals(this.accountName, beneficiaryAggregateData.accountName) && Objects.equals((Object)this.type, (Object)beneficiaryAggregateData.type) && Objects.equals(this.totalItemsSold, beneficiaryAggregateData.totalItemsSold) && Objects.equals(this.supplierCurrency, beneficiaryAggregateData.supplierCurrency) && Objects.equals(this.internalCurrency, beneficiaryAggregateData.internalCurrency) && Objects.equals(this.supplierAmount, beneficiaryAggregateData.supplierAmount) && Objects.equals(this.internalAmount, beneficiaryAggregateData.internalAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.accountName, this.type, this.totalItemsSold, this.supplierCurrency, this.internalCurrency, this.supplierAmount, this.internalAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeneficiaryAggregateData {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    totalItemsSold: ").append(this.toIndentedString(this.totalItemsSold)).append("\n");
        sb.append("    supplierCurrency: ").append(this.toIndentedString(this.supplierCurrency)).append("\n");
        sb.append("    internalCurrency: ").append(this.toIndentedString(this.internalCurrency)).append("\n");
        sb.append("    supplierAmount: ").append(this.toIndentedString(this.supplierAmount)).append("\n");
        sb.append("    internalAmount: ").append(this.toIndentedString(this.internalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        TRIP_PAY("TRIP_PAY"),
        SALE("SALE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

