/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Objects;

@JsonPropertyOrder(value={"date", "price", "displayPrice", "supplierPrice", "internalPrice", "capturePrice"})
public class DailyRate {
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDate date;
    public static final String JSON_PROPERTY_PRICE = "price";
    private CustomMonetaryAmount price;
    public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
    private CustomMonetaryAmount displayPrice;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
    private CustomMonetaryAmount supplierPrice;
    public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
    private CustomMonetaryAmount internalPrice;
    public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
    private CustomMonetaryAmount capturePrice;

    public DailyRate date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public DailyRate price(CustomMonetaryAmount price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(CustomMonetaryAmount price) {
        this.price = price;
    }

    public DailyRate displayPrice(CustomMonetaryAmount displayPrice) {
        this.displayPrice = displayPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getDisplayPrice() {
        return this.displayPrice;
    }

    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPrice(CustomMonetaryAmount displayPrice) {
        this.displayPrice = displayPrice;
    }

    public DailyRate supplierPrice(CustomMonetaryAmount supplierPrice) {
        this.supplierPrice = supplierPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getSupplierPrice() {
        return this.supplierPrice;
    }

    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPrice(CustomMonetaryAmount supplierPrice) {
        this.supplierPrice = supplierPrice;
    }

    public DailyRate internalPrice(CustomMonetaryAmount internalPrice) {
        this.internalPrice = internalPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getInternalPrice() {
        return this.internalPrice;
    }

    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPrice(CustomMonetaryAmount internalPrice) {
        this.internalPrice = internalPrice;
    }

    public DailyRate capturePrice(CustomMonetaryAmount capturePrice) {
        this.capturePrice = capturePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getCapturePrice() {
        return this.capturePrice;
    }

    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePrice(CustomMonetaryAmount capturePrice) {
        this.capturePrice = capturePrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyRate dailyRate = (DailyRate)o;
        return Objects.equals(this.date, dailyRate.date) && Objects.equals(this.price, dailyRate.price) && Objects.equals(this.displayPrice, dailyRate.displayPrice) && Objects.equals(this.supplierPrice, dailyRate.supplierPrice) && Objects.equals(this.internalPrice, dailyRate.internalPrice) && Objects.equals(this.capturePrice, dailyRate.capturePrice);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.price, this.displayPrice, this.supplierPrice, this.internalPrice, this.capturePrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyRate {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    displayPrice: ").append(this.toIndentedString(this.displayPrice)).append("\n");
        sb.append("    supplierPrice: ").append(this.toIndentedString(this.supplierPrice)).append("\n");
        sb.append("    internalPrice: ").append(this.toIndentedString(this.internalPrice)).append("\n");
        sb.append("    capturePrice: ").append(this.toIndentedString(this.capturePrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

