package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.ActivityStream;
import io.trippay.sdk.payment.model.UpsertActivityStreamRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-07-30T17:54:54.161486528+07:00[Asia/Bangkok]")
public class ActivityStreamApi {
    private ApiClient apiClient;

    public ActivityStreamApi() {
        this(new ApiClient());
    }

    @Autowired
    public ActivityStreamApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Activity Stream
     * Add a new activity stream entry.
     * <p><b>201</b> - Created
     * @param upsertActivityStreamRequest The upsertActivityStreamRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ActivityStream
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createActivityRequestCreation(UpsertActivityStreamRequest upsertActivityStreamRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertActivityStreamRequest;
        // verify the required parameter 'upsertActivityStreamRequest' is set
        if (upsertActivityStreamRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityStreamRequest' when calling createActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>() {};
        return apiClient.invokeAPI("/api/activity-stream", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Activity Stream
     * Add a new activity stream entry.
     * <p><b>201</b> - Created
     * @param upsertActivityStreamRequest The upsertActivityStreamRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ActivityStream
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ActivityStream> createActivity(UpsertActivityStreamRequest upsertActivityStreamRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>() {};
        return createActivityRequestCreation(upsertActivityStreamRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Activity Stream
     * Add a new activity stream entry.
     * <p><b>201</b> - Created
     * @param upsertActivityStreamRequest The upsertActivityStreamRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ActivityStream&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ActivityStream>> createActivityWithHttpInfo(UpsertActivityStreamRequest upsertActivityStreamRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>() {};
        return createActivityRequestCreation(upsertActivityStreamRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Activity Stream
     * Add a new activity stream entry.
     * <p><b>201</b> - Created
     * @param upsertActivityStreamRequest The upsertActivityStreamRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createActivityWithResponseSpec(UpsertActivityStreamRequest upsertActivityStreamRequest, String winkVersion) throws WebClientResponseException {
        return createActivityRequestCreation(upsertActivityStreamRequest, winkVersion);
    }
    /**
     * Show Activity Stream
     * Displays activity stream for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ActivityStream&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showStreamRequestCreation(String entityIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'entityIdentifier' is set
        if (entityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'entityIdentifier' when calling showStream", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("entityIdentifier", entityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>() {};
        return apiClient.invokeAPI("/api/activity-stream/{entityIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activity Stream
     * Displays activity stream for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ActivityStream&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ActivityStream> showStream(String entityIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>() {};
        return showStreamRequestCreation(entityIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Activity Stream
     * Displays activity stream for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;ActivityStream&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ActivityStream>>> showStreamWithHttpInfo(String entityIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>() {};
        return showStreamRequestCreation(entityIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Activity Stream
     * Displays activity stream for specified entity ID.
     * <p><b>200</b> - OK
     * @param entityIdentifier ID of entity to retrieve stream for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showStreamWithResponseSpec(String entityIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showStreamRequestCreation(entityIdentifier, winkVersion, accept);
    }
}
