/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import io.trippay.sdk.payment.model.DailyRate;
import io.trippay.sdk.payment.model.GuestUser;
import io.trippay.sdk.payment.model.RawBeneficiary;
import io.trippay.sdk.payment.model.SimpleDateTimeItinerary;
import io.trippay.sdk.payment.model.SupplierContractItemPolicy;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"user", "nameInEnglish", "descriptionInEnglish", "price", "displayPrice", "supplierPrice", "internalPrice", "capturePrice", "itinerary", "pricingType", "type", "beneficiaryList", "payable", "policy", "externalIdentifier", "dailyRateList", "metadata"})
public class PricedSupplierContractItemWithAcquirer {
    public static final String JSON_PROPERTY_USER = "user";
    private GuestUser user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_PRICE = "price";
    private CustomMonetaryAmount price;
    public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
    private CustomMonetaryAmount displayPrice;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
    private CustomMonetaryAmount supplierPrice;
    public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
    private CustomMonetaryAmount internalPrice;
    public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
    private CustomMonetaryAmount capturePrice;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private SimpleDateTimeItinerary itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    private List<RawBeneficiary> beneficiaryList = new ArrayList<RawBeneficiary>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private SupplierContractItemPolicy policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    private String externalIdentifier;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    private List<DailyRate> dailyRateList;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();

    public PricedSupplierContractItemWithAcquirer user(GuestUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GuestUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(GuestUser user) {
        this.user = user;
    }

    public PricedSupplierContractItemWithAcquirer nameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public PricedSupplierContractItemWithAcquirer descriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public PricedSupplierContractItemWithAcquirer price(CustomMonetaryAmount price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(CustomMonetaryAmount price) {
        this.price = price;
    }

    public PricedSupplierContractItemWithAcquirer displayPrice(CustomMonetaryAmount displayPrice) {
        this.displayPrice = displayPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getDisplayPrice() {
        return this.displayPrice;
    }

    @JsonProperty(value="displayPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPrice(CustomMonetaryAmount displayPrice) {
        this.displayPrice = displayPrice;
    }

    public PricedSupplierContractItemWithAcquirer supplierPrice(CustomMonetaryAmount supplierPrice) {
        this.supplierPrice = supplierPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getSupplierPrice() {
        return this.supplierPrice;
    }

    @JsonProperty(value="supplierPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPrice(CustomMonetaryAmount supplierPrice) {
        this.supplierPrice = supplierPrice;
    }

    public PricedSupplierContractItemWithAcquirer internalPrice(CustomMonetaryAmount internalPrice) {
        this.internalPrice = internalPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getInternalPrice() {
        return this.internalPrice;
    }

    @JsonProperty(value="internalPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPrice(CustomMonetaryAmount internalPrice) {
        this.internalPrice = internalPrice;
    }

    public PricedSupplierContractItemWithAcquirer capturePrice(CustomMonetaryAmount capturePrice) {
        this.capturePrice = capturePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getCapturePrice() {
        return this.capturePrice;
    }

    @JsonProperty(value="capturePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePrice(CustomMonetaryAmount capturePrice) {
        this.capturePrice = capturePrice;
    }

    public PricedSupplierContractItemWithAcquirer itinerary(SimpleDateTimeItinerary itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SimpleDateTimeItinerary getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(SimpleDateTimeItinerary itinerary) {
        this.itinerary = itinerary;
    }

    public PricedSupplierContractItemWithAcquirer pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public PricedSupplierContractItemWithAcquirer type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PricedSupplierContractItemWithAcquirer beneficiaryList(List<RawBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public PricedSupplierContractItemWithAcquirer addBeneficiaryListItem(RawBeneficiary beneficiaryListItem) {
        if (this.beneficiaryList == null) {
            this.beneficiaryList = new ArrayList<RawBeneficiary>();
        }
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RawBeneficiary> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(List<RawBeneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public PricedSupplierContractItemWithAcquirer payable(PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(PayableEnum payable) {
        this.payable = payable;
    }

    public PricedSupplierContractItemWithAcquirer policy(SupplierContractItemPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(SupplierContractItemPolicy policy) {
        this.policy = policy;
    }

    public PricedSupplierContractItemWithAcquirer externalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public PricedSupplierContractItemWithAcquirer dailyRateList(List<DailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public PricedSupplierContractItemWithAcquirer addDailyRateListItem(DailyRate dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<DailyRate>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DailyRate> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(List<DailyRate> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public PricedSupplierContractItemWithAcquirer metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PricedSupplierContractItemWithAcquirer putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PricedSupplierContractItemWithAcquirer pricedSupplierContractItemWithAcquirer = (PricedSupplierContractItemWithAcquirer)o;
        return Objects.equals(this.user, pricedSupplierContractItemWithAcquirer.user) && Objects.equals(this.nameInEnglish, pricedSupplierContractItemWithAcquirer.nameInEnglish) && Objects.equals(this.descriptionInEnglish, pricedSupplierContractItemWithAcquirer.descriptionInEnglish) && Objects.equals(this.price, pricedSupplierContractItemWithAcquirer.price) && Objects.equals(this.displayPrice, pricedSupplierContractItemWithAcquirer.displayPrice) && Objects.equals(this.supplierPrice, pricedSupplierContractItemWithAcquirer.supplierPrice) && Objects.equals(this.internalPrice, pricedSupplierContractItemWithAcquirer.internalPrice) && Objects.equals(this.capturePrice, pricedSupplierContractItemWithAcquirer.capturePrice) && Objects.equals(this.itinerary, pricedSupplierContractItemWithAcquirer.itinerary) && Objects.equals((Object)this.pricingType, (Object)pricedSupplierContractItemWithAcquirer.pricingType) && Objects.equals((Object)this.type, (Object)pricedSupplierContractItemWithAcquirer.type) && Objects.equals(this.beneficiaryList, pricedSupplierContractItemWithAcquirer.beneficiaryList) && Objects.equals((Object)this.payable, (Object)pricedSupplierContractItemWithAcquirer.payable) && Objects.equals(this.policy, pricedSupplierContractItemWithAcquirer.policy) && Objects.equals(this.externalIdentifier, pricedSupplierContractItemWithAcquirer.externalIdentifier) && Objects.equals(this.dailyRateList, pricedSupplierContractItemWithAcquirer.dailyRateList) && Objects.equals(this.metadata, pricedSupplierContractItemWithAcquirer.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.nameInEnglish, this.descriptionInEnglish, this.price, this.displayPrice, this.supplierPrice, this.internalPrice, this.capturePrice, this.itinerary, this.pricingType, this.type, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.dailyRateList, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PricedSupplierContractItemWithAcquirer {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    displayPrice: ").append(this.toIndentedString(this.displayPrice)).append("\n");
        sb.append("    supplierPrice: ").append(this.toIndentedString(this.supplierPrice)).append("\n");
        sb.append("    internalPrice: ").append(this.toIndentedString(this.internalPrice)).append("\n");
        sb.append("    capturePrice: ").append(this.toIndentedString(this.capturePrice)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING("LODGING"),
        RAIL("RAIL"),
        AIR("AIR"),
        CAR("CAR"),
        CRUISE("CRUISE"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        RENTAL("RENTAL"),
        EXPERIENCE("EXPERIENCE"),
        ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
        ANCILLARY_FEE("ANCILLARY_FEE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE("IMMEDIATE"),
        ARRIVAL("ARRIVAL"),
        DEPARTURE("DEPARTURE"),
        AGENT("AGENT");

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

