/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.2.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.RawSupplierContractItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Details of the booking entries that went in for one particular supplier directly.
 */
@JsonPropertyOrder({
  RawSupplierContract.JSON_PROPERTY_IDENTIFIER,
  RawSupplierContract.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  RawSupplierContract.JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE,
  RawSupplierContract.JSON_PROPERTY_CONTRACT_ITEM_LIST,
  RawSupplierContract.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  RawSupplierContract.JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER,
  RawSupplierContract.JSON_PROPERTY_METADATA
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-05T21:30:57.667873207+07:00[Asia/Bangkok]")
public class RawSupplierContract {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  /**
   * Indicates whether the supplierIdentifier can be found internally or is mapped via an external identifier
   */
  public enum SupplierIdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    SupplierIdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SupplierIdentifierTypeEnum fromValue(String value) {
      for (SupplierIdentifierTypeEnum b : SupplierIdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE = "supplierIdentifierType";
  private SupplierIdentifierTypeEnum supplierIdentifierType;

  public static final String JSON_PROPERTY_CONTRACT_ITEM_LIST = "contractItemList";
  private List<RawSupplierContractItem> contractItemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
  private String externalTransactionIdentifier;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public RawSupplierContract() {
  }

  public RawSupplierContract identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier used to track the contract. Will auto-generate on if doesn&#39;t exist.
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RawSupplierContract supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier 
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public RawSupplierContract supplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
    
    this.supplierIdentifierType = supplierIdentifierType;
    return this;
  }

   /**
   * Indicates whether the supplierIdentifier can be found internally or is mapped via an external identifier
   * @return supplierIdentifierType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SupplierIdentifierTypeEnum getSupplierIdentifierType() {
    return supplierIdentifierType;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
    this.supplierIdentifierType = supplierIdentifierType;
  }


  public RawSupplierContract contractItemList(List<RawSupplierContractItem> contractItemList) {
    
    this.contractItemList = contractItemList;
    return this;
  }

  public RawSupplierContract addContractItemListItem(RawSupplierContractItem contractItemListItem) {
    if (this.contractItemList == null) {
      this.contractItemList = new ArrayList<>();
    }
    this.contractItemList.add(contractItemListItem);
    return this;
  }

   /**
   * Get contractItemList
   * @return contractItemList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_CONTRACT_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RawSupplierContractItem> getContractItemList() {
    return contractItemList;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContractItemList(List<RawSupplierContractItem> contractItemList) {
    this.contractItemList = contractItemList;
  }


  public RawSupplierContract externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public RawSupplierContract externalTransactionIdentifier(String externalTransactionIdentifier) {
    
    this.externalTransactionIdentifier = externalTransactionIdentifier;
    return this;
  }

   /**
   * External transaction identifier populated when agent responsible for acquiring
   * @return externalTransactionIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalTransactionIdentifier() {
    return externalTransactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
    this.externalTransactionIdentifier = externalTransactionIdentifier;
  }


  public RawSupplierContract metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public RawSupplierContract putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Place to add more data related to the booking contract.
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RawSupplierContract rawSupplierContract = (RawSupplierContract) o;
    return Objects.equals(this.identifier, rawSupplierContract.identifier) &&
        Objects.equals(this.supplierIdentifier, rawSupplierContract.supplierIdentifier) &&
        Objects.equals(this.supplierIdentifierType, rawSupplierContract.supplierIdentifierType) &&
        Objects.equals(this.contractItemList, rawSupplierContract.contractItemList) &&
        Objects.equals(this.externalSupplierBookingCode, rawSupplierContract.externalSupplierBookingCode) &&
        Objects.equals(this.externalTransactionIdentifier, rawSupplierContract.externalTransactionIdentifier) &&
        Objects.equals(this.metadata, rawSupplierContract.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, supplierIdentifier, supplierIdentifierType, contractItemList, externalSupplierBookingCode, externalTransactionIdentifier, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RawSupplierContract {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierIdentifierType: ").append(toIndentedString(supplierIdentifierType)).append("\n");
    sb.append("    contractItemList: ").append(toIndentedString(contractItemList)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    externalTransactionIdentifier: ").append(toIndentedString(externalTransactionIdentifier)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

