/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.4.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CustomMonetaryAmount;
import io.trippay.sdk.payment.model.PayoutFee;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Payout keeps track of all outgoing funds for a certain account.
 */
@JsonPropertyOrder({
  Payout.JSON_PROPERTY_VENDOR,
  Payout.JSON_PROPERTY_VENDOR_IDENTIFIER,
  Payout.JSON_PROPERTY_VENDOR_NAME,
  Payout.JSON_PROPERTY_VENDOR_TOKEN_KEY,
  Payout.JSON_PROPERTY_IDENTIFIER,
  Payout.JSON_PROPERTY_BENEFICIARY_IDENTIFIER,
  Payout.JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER,
  Payout.JSON_PROPERTY_TYPE,
  Payout.JSON_PROPERTY_ENTRY,
  Payout.JSON_PROPERTY_FEES,
  Payout.JSON_PROPERTY_CREATED,
  Payout.JSON_PROPERTY_DESCRIPTION,
  Payout.JSON_PROPERTY_PAYOUT_ID,
  Payout.JSON_PROPERTY_REFERENCE_CODE,
  Payout.JSON_PROPERTY_REFERENCE_CODE_DATE,
  Payout.JSON_PROPERTY_STATUS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T21:59:59.953237150+07:00[Asia/Bangkok]")
public class Payout {
  /**
   * Name of integration vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    AGENT("AGENT"),
    
    NMI("NMI"),
    
    WISE("WISE");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  public static final String JSON_PROPERTY_VENDOR_IDENTIFIER = "vendorIdentifier";
  private String vendorIdentifier;

  public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
  private String vendorName;

  public static final String JSON_PROPERTY_VENDOR_TOKEN_KEY = "vendorTokenKey";
  private String vendorTokenKey;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_BENEFICIARY_IDENTIFIER = "beneficiaryIdentifier";
  private UUID beneficiaryIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER = "externalPayeeIdentifier";
  private String externalPayeeIdentifier;

  /**
   * Type of withdrawal.
   */
  public enum TypeEnum {
    BANK_TRANSFER("BANK_TRANSFER"),
    
    VCC("VCC");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_ENTRY = "entry";
  private CustomMonetaryAmount entry;

  public static final String JSON_PROPERTY_FEES = "fees";
  private List<PayoutFee> fees;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
  private String payoutId;

  public static final String JSON_PROPERTY_REFERENCE_CODE = "referenceCode";
  private String referenceCode;

  public static final String JSON_PROPERTY_REFERENCE_CODE_DATE = "referenceCodeDate";
  private java.time.LocalDateTime referenceCodeDate;

  /**
   * Status of withdrawal.
   */
  public enum StatusEnum {
    INITIATED("INITIATED"),
    
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    FAILED("FAILED"),
    
    CANCELLED("CANCELLED"),
    
    COMPLETE("COMPLETE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public Payout() {
  }

  public Payout vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of integration vendor
   * @return vendor
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public Payout vendorIdentifier(String vendorIdentifier) {
    
    this.vendorIdentifier = vendorIdentifier;
    return this;
  }

   /**
   * Which acquirer account we return fund from.
   * @return vendorIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVendorIdentifier() {
    return vendorIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorIdentifier(String vendorIdentifier) {
    this.vendorIdentifier = vendorIdentifier;
  }


  public Payout vendorName(String vendorName) {
    
    this.vendorName = vendorName;
    return this;
  }

   /**
   * Name of regional acquirer account.
   * @return vendorName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVendorName() {
    return vendorName;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorName(String vendorName) {
    this.vendorName = vendorName;
  }


  public Payout vendorTokenKey(String vendorTokenKey) {
    
    this.vendorTokenKey = vendorTokenKey;
    return this;
  }

   /**
   * Key to help load Stripe for the correct region. Could be helpful for other vendors as well.
   * @return vendorTokenKey
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR_TOKEN_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVendorTokenKey() {
    return vendorTokenKey;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_TOKEN_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorTokenKey(String vendorTokenKey) {
    this.vendorTokenKey = vendorTokenKey;
  }


  public Payout identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique system ID.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public Payout beneficiaryIdentifier(UUID beneficiaryIdentifier) {
    
    this.beneficiaryIdentifier = beneficiaryIdentifier;
    return this;
  }

   /**
   * Beneficiary ID.
   * @return beneficiaryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BENEFICIARY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getBeneficiaryIdentifier() {
    return beneficiaryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryIdentifier(UUID beneficiaryIdentifier) {
    this.beneficiaryIdentifier = beneficiaryIdentifier;
  }


  public Payout externalPayeeIdentifier(String externalPayeeIdentifier) {
    
    this.externalPayeeIdentifier = externalPayeeIdentifier;
    return this;
  }

   /**
   * This would be the cardholder ID for VCCs.
   * @return externalPayeeIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalPayeeIdentifier() {
    return externalPayeeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalPayeeIdentifier(String externalPayeeIdentifier) {
    this.externalPayeeIdentifier = externalPayeeIdentifier;
  }


  public Payout type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of withdrawal.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Payout entry(CustomMonetaryAmount entry) {
    
    this.entry = entry;
    return this;
  }

   /**
   * Get entry
   * @return entry
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getEntry() {
    return entry;
  }


  @JsonProperty(JSON_PROPERTY_ENTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEntry(CustomMonetaryAmount entry) {
    this.entry = entry;
  }


  public Payout fees(List<PayoutFee> fees) {
    
    this.fees = fees;
    return this;
  }

  public Payout addFeesItem(PayoutFee feesItem) {
    if (this.fees == null) {
      this.fees = new ArrayList<>();
    }
    this.fees.add(feesItem);
    return this;
  }

   /**
   * Fees incurred when making the withdrawal.
   * @return fees
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PayoutFee> getFees() {
    return fees;
  }


  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFees(List<PayoutFee> fees) {
    this.fees = fees;
  }


  public Payout created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * When the payout record was created.
   * @return created
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public Payout description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Textual response from provider
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Payout payoutId(String payoutId) {
    
    this.payoutId = payoutId;
    return this;
  }

   /**
   * The identifier that was generated when scheduling the payout. This will come from the payout provider such as Stripe.
   * @return payoutId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAYOUT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutId() {
    return payoutId;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutId(String payoutId) {
    this.payoutId = payoutId;
  }


  public Payout referenceCode(String referenceCode) {
    
    this.referenceCode = referenceCode;
    return this;
  }

   /**
   * The transaction code that was generated when the funds move out of TripPay&#39;s account. This will come from the payout provider such as Stripe. E.g. For VCCs, it will occur when an authorization takes place.
   * @return referenceCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReferenceCode() {
    return referenceCode;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceCode(String referenceCode) {
    this.referenceCode = referenceCode;
  }


  public Payout referenceCodeDate(java.time.LocalDateTime referenceCodeDate) {
    
    this.referenceCodeDate = referenceCodeDate;
    return this;
  }

   /**
   * The time the funds were withdrawn
   * @return referenceCodeDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getReferenceCodeDate() {
    return referenceCodeDate;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceCodeDate(java.time.LocalDateTime referenceCodeDate) {
    this.referenceCodeDate = referenceCodeDate;
  }


  public Payout status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Status of withdrawal.
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payout payout = (Payout) o;
    return Objects.equals(this.vendor, payout.vendor) &&
        Objects.equals(this.vendorIdentifier, payout.vendorIdentifier) &&
        Objects.equals(this.vendorName, payout.vendorName) &&
        Objects.equals(this.vendorTokenKey, payout.vendorTokenKey) &&
        Objects.equals(this.identifier, payout.identifier) &&
        Objects.equals(this.beneficiaryIdentifier, payout.beneficiaryIdentifier) &&
        Objects.equals(this.externalPayeeIdentifier, payout.externalPayeeIdentifier) &&
        Objects.equals(this.type, payout.type) &&
        Objects.equals(this.entry, payout.entry) &&
        Objects.equals(this.fees, payout.fees) &&
        Objects.equals(this.created, payout.created) &&
        Objects.equals(this.description, payout.description) &&
        Objects.equals(this.payoutId, payout.payoutId) &&
        Objects.equals(this.referenceCode, payout.referenceCode) &&
        Objects.equals(this.referenceCodeDate, payout.referenceCodeDate) &&
        Objects.equals(this.status, payout.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(vendor, vendorIdentifier, vendorName, vendorTokenKey, identifier, beneficiaryIdentifier, externalPayeeIdentifier, type, entry, fees, created, description, payoutId, referenceCode, referenceCodeDate, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payout {\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    vendorIdentifier: ").append(toIndentedString(vendorIdentifier)).append("\n");
    sb.append("    vendorName: ").append(toIndentedString(vendorName)).append("\n");
    sb.append("    vendorTokenKey: ").append(toIndentedString(vendorTokenKey)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    beneficiaryIdentifier: ").append(toIndentedString(beneficiaryIdentifier)).append("\n");
    sb.append("    externalPayeeIdentifier: ").append(toIndentedString(externalPayeeIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    entry: ").append(toIndentedString(entry)).append("\n");
    sb.append("    fees: ").append(toIndentedString(fees)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    payoutId: ").append(toIndentedString(payoutId)).append("\n");
    sb.append("    referenceCode: ").append(toIndentedString(referenceCode)).append("\n");
    sb.append("    referenceCodeDate: ").append(toIndentedString(referenceCodeDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

