/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.PayableContractSupplierItem;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"identifier", "supplierIdentifier", "supplierIdentifierType", "contractItemList", "externalSupplierBookingCode", "externalTransactionIdentifier", "metadata"})
public class PayableContractSupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE = "supplierIdentifierType";
    private SupplierIdentifierTypeEnum supplierIdentifierType;
    public static final String JSON_PROPERTY_CONTRACT_ITEM_LIST = "contractItemList";
    private List<PayableContractSupplierItem> contractItemList = new ArrayList<PayableContractSupplierItem>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();

    public PayableContractSupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public PayableContractSupplier supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public PayableContractSupplier supplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
        this.supplierIdentifierType = supplierIdentifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SupplierIdentifierTypeEnum getSupplierIdentifierType() {
        return this.supplierIdentifierType;
    }

    @JsonProperty(value="supplierIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
        this.supplierIdentifierType = supplierIdentifierType;
    }

    public PayableContractSupplier contractItemList(List<PayableContractSupplierItem> contractItemList) {
        this.contractItemList = contractItemList;
        return this;
    }

    public PayableContractSupplier addContractItemListItem(PayableContractSupplierItem contractItemListItem) {
        if (this.contractItemList == null) {
            this.contractItemList = new ArrayList<PayableContractSupplierItem>();
        }
        this.contractItemList.add(contractItemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="contractItemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<PayableContractSupplierItem> getContractItemList() {
        return this.contractItemList;
    }

    @JsonProperty(value="contractItemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractItemList(List<PayableContractSupplierItem> contractItemList) {
        this.contractItemList = contractItemList;
    }

    public PayableContractSupplier externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public PayableContractSupplier externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public PayableContractSupplier metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PayableContractSupplier putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayableContractSupplier payableContractSupplier = (PayableContractSupplier)o;
        return Objects.equals(this.identifier, payableContractSupplier.identifier) && Objects.equals(this.supplierIdentifier, payableContractSupplier.supplierIdentifier) && Objects.equals((Object)this.supplierIdentifierType, (Object)payableContractSupplier.supplierIdentifierType) && Objects.equals(this.contractItemList, payableContractSupplier.contractItemList) && Objects.equals(this.externalSupplierBookingCode, payableContractSupplier.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, payableContractSupplier.externalTransactionIdentifier) && Objects.equals(this.metadata, payableContractSupplier.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.supplierIdentifier, this.supplierIdentifierType, this.contractItemList, this.externalSupplierBookingCode, this.externalTransactionIdentifier, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayableContractSupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierIdentifierType: ").append(this.toIndentedString((Object)this.supplierIdentifierType)).append("\n");
        sb.append("    contractItemList: ").append(this.toIndentedString(this.contractItemList)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SupplierIdentifierTypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private SupplierIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupplierIdentifierTypeEnum fromValue(String value) {
            for (SupplierIdentifierTypeEnum b : SupplierIdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

