/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.8.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.Personal;
import io.trippay.sdk.payment.model.Preferences;
import io.trippay.sdk.payment.model.ProfileUser;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Optional profile record
 */
@JsonPropertyOrder({
  Profile.JSON_PROPERTY_PROFILE_IDENTIFIER,
  Profile.JSON_PROPERTY_USER_IDENTIFIER,
  Profile.JSON_PROPERTY_SHARE,
  Profile.JSON_PROPERTY_USER,
  Profile.JSON_PROPERTY_PERSONAL,
  Profile.JSON_PROPERTY_PREFERENCES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-11-25T16:28:27.720080561+07:00[Asia/Bangkok]")
public class Profile {
  public static final String JSON_PROPERTY_PROFILE_IDENTIFIER = "profileIdentifier";
  private UUID profileIdentifier;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_SHARE = "share";
  private Boolean share;

  public static final String JSON_PROPERTY_USER = "user";
  private ProfileUser user;

  public static final String JSON_PROPERTY_PERSONAL = "personal";
  private Personal personal;

  public static final String JSON_PROPERTY_PREFERENCES = "preferences";
  private Preferences preferences;

  public Profile() {
  }

  public Profile profileIdentifier(UUID profileIdentifier) {
    
    this.profileIdentifier = profileIdentifier;
    return this;
  }

   /**
   * Profile identifier
   * @return profileIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PROFILE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getProfileIdentifier() {
    return profileIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProfileIdentifier(UUID profileIdentifier) {
    this.profileIdentifier = profileIdentifier;
  }


  public Profile userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * User identifier
   * @return userIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public Profile share(Boolean share) {
    
    this.share = share;
    return this;
  }

   /**
   * Indicates whether the user wants to share this profile of themselves with hotel(s)
   * @return share
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SHARE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getShare() {
    return share;
  }


  @JsonProperty(JSON_PROPERTY_SHARE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShare(Boolean share) {
    this.share = share;
  }


  public Profile user(ProfileUser user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ProfileUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(ProfileUser user) {
    this.user = user;
  }


  public Profile personal(Personal personal) {
    
    this.personal = personal;
    return this;
  }

   /**
   * Get personal
   * @return personal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PERSONAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Personal getPersonal() {
    return personal;
  }


  @JsonProperty(JSON_PROPERTY_PERSONAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPersonal(Personal personal) {
    this.personal = personal;
  }


  public Profile preferences(Preferences preferences) {
    
    this.preferences = preferences;
    return this;
  }

   /**
   * Get preferences
   * @return preferences
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Preferences getPreferences() {
    return preferences;
  }


  @JsonProperty(JSON_PROPERTY_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPreferences(Preferences preferences) {
    this.preferences = preferences;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Profile profile = (Profile) o;
    return Objects.equals(this.profileIdentifier, profile.profileIdentifier) &&
        Objects.equals(this.userIdentifier, profile.userIdentifier) &&
        Objects.equals(this.share, profile.share) &&
        Objects.equals(this.user, profile.user) &&
        Objects.equals(this.personal, profile.personal) &&
        Objects.equals(this.preferences, profile.preferences);
  }

  @Override
  public int hashCode() {
    return Objects.hash(profileIdentifier, userIdentifier, share, user, personal, preferences);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Profile {\n");
    sb.append("    profileIdentifier: ").append(toIndentedString(profileIdentifier)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    share: ").append(toIndentedString(share)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    personal: ").append(toIndentedString(personal)).append("\n");
    sb.append("    preferences: ").append(toIndentedString(preferences)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

