/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.Account;
import io.trippay.sdk.payment.model.AccountStatusResponse;
import io.trippay.sdk.payment.model.CreateAccountRequest;
import io.trippay.sdk.payment.model.KeyValuePair;
import io.trippay.sdk.payment.model.PageAccount;
import io.trippay.sdk.payment.model.RemoveEntryResponse;
import io.trippay.sdk.payment.model.SetTaxIdentifierRequest;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.UniqueResult;
import io.trippay.sdk.payment.model.UpsertAccountRequest;
import io.trippay.sdk.payment.model.UpsertBankAccountRequest;
import io.trippay.sdk.payment.model.VerifyAccountRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AccountApi {
    private ApiClient apiClient;

    public AccountApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec checkAccountStatusRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling checkAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/status", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AccountStatusResponse> checkAccountStatus(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkAccountStatusRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AccountStatusResponse>> checkAccountStatusWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkAccountStatusRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec checkAccountStatusWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return this.checkAccountStatusRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec checkExternalAccountStatusRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling checkExternalAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/status", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AccountStatusResponse> checkExternalAccountStatus(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkExternalAccountStatusRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AccountStatusResponse>> checkExternalAccountStatusWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkExternalAccountStatusRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec checkExternalAccountStatusWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return this.checkExternalAccountStatusRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec createAccountRequestCreation(CreateAccountRequest createAccountRequest, String winkVersion) throws WebClientResponseException {
        CreateAccountRequest postBody = createAccountRequest;
        if (createAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAccountRequest' when calling createAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createAccount(CreateAccountRequest createAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountRequestCreation(createAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountWithHttpInfo(CreateAccountRequest createAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountRequestCreation(createAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAccountWithResponseSpec(CreateAccountRequest createAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.createAccountRequestCreation(createAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec createAccountBankAccountRequestCreation(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/bank-account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createAccountBankAccount(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountBankAccountWithHttpInfo(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAccountBankAccountWithResponseSpec(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec createExternalAccountBankAccountRequestCreation(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/bank-account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createExternalAccountBankAccount(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createExternalAccountBankAccountWithHttpInfo(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createExternalAccountBankAccountWithResponseSpec(String id, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec deleteAccountRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> deleteAccount(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteAccountRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> deleteAccountWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteAccountRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteAccountWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return this.deleteAccountRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec isAccountNameUniqueRequestCreation(String name, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling isAccountNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("name", name);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "identifier", identifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(this){};
        return this.apiClient.invokeAPI("/api/account/unique/{name}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResult> isAccountNameUnique(String name, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(this){};
        return this.isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isAccountNameUniqueWithHttpInfo(String name, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(this){};
        return this.isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isAccountNameUniqueWithResponseSpec(String name, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> loadAccount(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> loadAccountWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return this.loadAccountRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountByNameRequestCreation(String name, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling loadAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("name", name);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/name/{name}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> loadAccountByName(String name, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameRequestCreation(name, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountByNameWithHttpInfo(String name, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameRequestCreation(name, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountByNameWithResponseSpec(String name, String winkVersion, String accept) throws WebClientResponseException {
        return this.loadAccountByNameRequestCreation(name, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountByNameLikeRequestCreation(String name, Boolean ignoreCase, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling loadAccountByNameLike", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "name", name));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "ignore-case", ignoreCase));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/name", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> loadAccountByNameLike(String name, Boolean ignoreCase, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountByNameLikeWithHttpInfo(String name, Boolean ignoreCase, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountByNameLikeWithResponseSpec(String name, Boolean ignoreCase, String winkVersion, String accept) throws WebClientResponseException {
        return this.loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountGridForAuthenticatedUserRequestCreation(State state, String winkVersion) throws WebClientResponseException {
        State postBody = state;
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling loadAccountGridForAuthenticatedUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>(this){};
        return this.apiClient.invokeAPI("/api/account/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageAccount> loadAccountGridForAuthenticatedUser(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>(this){};
        return this.loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageAccount>> loadAccountGridForAuthenticatedUserWithHttpInfo(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>(this){};
        return this.loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountGridForAuthenticatedUserWithResponseSpec(State state, String winkVersion) throws WebClientResponseException {
        return this.loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion);
    }

    private WebClient.ResponseSpec loadAccountsForAuthenticatedUserRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> loadAccountsForAuthenticatedUser(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountsForAuthenticatedUserWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountsForAuthenticatedUserWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec loadExternalAccountRequestCreation(String externalAccountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling loadExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> loadExternalAccount(String externalAccountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> loadExternalAccountWithHttpInfo(String externalAccountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadExternalAccountWithResponseSpec(String externalAccountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeAccountBankAccountRequestCreation(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/bank-account/{bankAccountId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> removeAccountBankAccount(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountBankAccountWithHttpInfo(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAccountBankAccountWithResponseSpec(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeExternalAccountBankAccountRequestCreation(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/bank-account/{bankAccountId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> removeExternalAccountBankAccount(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeExternalAccountBankAccountWithHttpInfo(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeExternalAccountBankAccountWithResponseSpec(String id, String bankAccountId, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchAccountByNameRequestCreation(String name, Boolean ignorecase, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling searchAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("name", name);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "ignorecase", ignorecase));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.apiClient.invokeAPI("/api/account/search/{name}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> searchAccountByName(String name, Boolean ignorecase, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> searchAccountByNameWithHttpInfo(String name, Boolean ignorecase, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchAccountByNameWithResponseSpec(String name, Boolean ignorecase, String winkVersion, String accept) throws WebClientResponseException {
        return this.searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAccountsByOwnerRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/owner/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> showAccountsByOwner(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.showAccountsByOwnerRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> showAccountsByOwnerWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.showAccountsByOwnerRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAccountsByOwnerWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showAccountsByOwnerRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateAccountRequestCreation(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        UpsertAccountRequest postBody = upsertAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountRequest' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateAccount(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateAccountRequestCreation(id, upsertAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountWithHttpInfo(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateAccountRequestCreation(id, upsertAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAccountWithResponseSpec(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.updateAccountRequestCreation(id, upsertAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateExternalAccountRequestCreation(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        UpsertAccountRequest postBody = upsertAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountRequest' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateExternalAccount(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateExternalAccountWithHttpInfo(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateExternalAccountWithResponseSpec(String id, UpsertAccountRequest upsertAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateNationalIdentifierRequestCreation(String id, String taskId, SetTaxIdentifierRequest setTaxIdentifierRequest, String winkVersion) throws WebClientResponseException {
        SetTaxIdentifierRequest postBody = setTaxIdentifierRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (taskId == null) {
            throw new WebClientResponseException("Missing the required parameter 'taskId' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (setTaxIdentifierRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'setTaxIdentifierRequest' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("taskId", taskId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/task/{taskId}/tid", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateNationalIdentifier(String id, String taskId, SetTaxIdentifierRequest setTaxIdentifierRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateNationalIdentifierWithHttpInfo(String id, String taskId, SetTaxIdentifierRequest setTaxIdentifierRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateNationalIdentifierWithResponseSpec(String id, String taskId, SetTaxIdentifierRequest setTaxIdentifierRequest, String winkVersion) throws WebClientResponseException {
        return this.updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion);
    }

    private WebClient.ResponseSpec upsertAccountBankAccountRequestCreation(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/bank-account/{bankAccountId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> upsertAccountBankAccount(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertAccountBankAccountWithHttpInfo(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec upsertAccountBankAccountWithResponseSpec(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec upsertExternalAccountBankAccountRequestCreation(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/bank-account/{bankAccountId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> upsertExternalAccountBankAccount(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertExternalAccountBankAccountWithHttpInfo(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec upsertExternalAccountBankAccountWithResponseSpec(String id, String bankAccountId, UpsertBankAccountRequest upsertBankAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec verifyAccountRequestCreation(String id, VerifyAccountRequest verifyAccountRequest, String winkVersion) throws WebClientResponseException {
        VerifyAccountRequest postBody = verifyAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (verifyAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'verifyAccountRequest' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/verify", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> verifyAccount(String id, VerifyAccountRequest verifyAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> verifyAccountWithHttpInfo(String id, VerifyAccountRequest verifyAccountRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec verifyAccountWithResponseSpec(String id, VerifyAccountRequest verifyAccountRequest, String winkVersion) throws WebClientResponseException {
        return this.verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion);
    }
}

