package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.CreateMappingRequest;
import io.trippay.sdk.payment.model.Mapping;
import io.trippay.sdk.payment.model.UpdateMappingRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-24T15:43:56.636470962+07:00[Asia/Bangkok]")
public class MappingApi {
    private ApiClient apiClient;

    public MappingApi() {
        this(new ApiClient());
    }

    @Autowired
    public MappingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Mapping
     * Create a mapping between two accounts
     * <p><b>201</b> - Created
     * @param createMappingRequest The createMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createMappingRequestCreation(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createMappingRequest;
        // verify the required parameter 'createMappingRequest' is set
        if (createMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMappingRequest' when calling createMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Mapping
     * Create a mapping between two accounts
     * <p><b>201</b> - Created
     * @param createMappingRequest The createMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> createMapping(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createMappingRequestCreation(createMappingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Mapping
     * Create a mapping between two accounts
     * <p><b>201</b> - Created
     * @param createMappingRequest The createMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> createMappingWithHttpInfo(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return createMappingRequestCreation(createMappingRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Mapping
     * Create a mapping between two accounts
     * <p><b>201</b> - Created
     * @param createMappingRequest The createMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createMappingWithResponseSpec(CreateMappingRequest createMappingRequest, String winkVersion) throws WebClientResponseException {
        return createMappingRequestCreation(createMappingRequest, winkVersion);
    }
    /**
     * Show Mapping
     * Show a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadMappingRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Mapping
     * Show a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> loadMapping(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Mapping
     * Show a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> loadMappingWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Mapping
     * Show a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadMappingWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return loadMappingRequestCreation(id, winkVersion, accept);
    }
    /**
     * Show External Mapping
     * Show a specific mapping contract by external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadMappingByExternalIdentifierRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show External Mapping
     * Show a specific mapping contract by external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> loadMappingByExternalIdentifier(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingByExternalIdentifierRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show External Mapping
     * Show a specific mapping contract by external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> loadMappingByExternalIdentifierWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingByExternalIdentifierRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show External Mapping
     * Show a specific mapping contract by external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadMappingByExternalIdentifierWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return loadMappingByExternalIdentifierRequestCreation(id, winkVersion, accept);
    }
    /**
     * Show Mappings
     * List all mappings
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadMappingsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Mappings
     * List all mappings
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Mapping> loadMappings(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Mappings
     * List all mappings
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Mapping&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Mapping>>> loadMappingsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return loadMappingsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Mappings
     * List all mappings
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadMappingsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return loadMappingsRequestCreation(winkVersion, accept);
    }
    /**
     * Delete Mapping
     * Delete a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMappingRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Mapping
     * Delete a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> removeMapping(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Mapping
     * Delete a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> removeMappingWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Mapping
     * Delete a specific mapping contract
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMappingWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return removeMappingRequestCreation(id, winkVersion, accept);
    }
    /**
     * Delete External Mapping
     * Delete a specific mapping contract based on its external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMappingByExternalIdentifierRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete External Mapping
     * Delete a specific mapping contract based on its external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> removeMappingByExternalIdentifier(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingByExternalIdentifierRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete External Mapping
     * Delete a specific mapping contract based on its external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> removeMappingByExternalIdentifierWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return removeMappingByExternalIdentifierRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete External Mapping
     * Delete a specific mapping contract based on its external identifier
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMappingByExternalIdentifierWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return removeMappingByExternalIdentifierRequestCreation(id, winkVersion, accept);
    }
    /**
     * Update Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMappingRequestCreation(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = updateMappingRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateMappingRequest' is set
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> updateMapping(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingRequestCreation(id, updateMappingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> updateMappingWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingRequestCreation(id, updateMappingRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMappingWithResponseSpec(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        return updateMappingRequestCreation(id, updateMappingRequest, winkVersion);
    }
    /**
     * Update External Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMappingByExternalIdentifierRequestCreation(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = updateMappingRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateMappingRequest' is set
        if (updateMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMappingRequest' when calling updateMappingByExternalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return apiClient.invokeAPI("/api/mapping/external/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update External Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Mapping
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Mapping> updateMappingByExternalIdentifier(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update External Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Mapping&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Mapping>> updateMappingByExternalIdentifierWithHttpInfo(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>() {};
        return updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update External Mapping
     * Update a mapping name only
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param updateMappingRequest The updateMappingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMappingByExternalIdentifierWithResponseSpec(String id, UpdateMappingRequest updateMappingRequest, String winkVersion) throws WebClientResponseException {
        return updateMappingByExternalIdentifierRequestCreation(id, updateMappingRequest, winkVersion);
    }
}
