/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.12.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Application
 */
@JsonPropertyOrder({
  Application.JSON_PROPERTY_ID,
  Application.JSON_PROPERTY_OWNER_IDENTIFIER,
  Application.JSON_PROPERTY_OWNER_NAME,
  Application.JSON_PROPERTY_OWNER_TYPE,
  Application.JSON_PROPERTY_NAME,
  Application.JSON_PROPERTY_REDIRECT_URIS,
  Application.JSON_PROPERTY_CLIENT_ID
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-24T15:43:56.636470962+07:00[Asia/Bangkok]")
public class Application {
  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  /**
   * Type of entity.
   */
  public enum OwnerTypeEnum {
    USER("USER"),
    
    COMPANY("COMPANY"),
    
    ACCOUNT("ACCOUNT");

    private String value;

    OwnerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OwnerTypeEnum fromValue(String value) {
      for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
  private List<String> redirectUris;

  public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
  private String clientId;

  public Application() {
  }

  public Application id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Unique identifier.
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(UUID id) {
    this.id = id;
  }


  public Application ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Unique owner record identifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public Application ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of company owner.
   * @return ownerName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public Application ownerType(OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

   /**
   * Type of entity.
   * @return ownerType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerType(OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }


  public Application name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of this engine application. The first engine for every integrator will have the same name as its company name.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Application redirectUris(List<String> redirectUris) {
    
    this.redirectUris = redirectUris;
    return this;
  }

  public Application addRedirectUrisItem(String redirectUrisItem) {
    if (this.redirectUris == null) {
      this.redirectUris = new ArrayList<>();
    }
    this.redirectUris.add(redirectUrisItem);
    return this;
  }

   /**
   * Where to redirect after web components successfully authenticate. For OAuth2 purposes.
   * @return redirectUris
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRedirectUris() {
    return redirectUris;
  }


  @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectUris(List<String> redirectUris) {
    this.redirectUris = redirectUris;
  }


  public Application clientId(String clientId) {
    
    this.clientId = clientId;
    return this;
  }

   /**
   * Client identifier used to authenticate an Oauth2 or web component request.
   * @return clientId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getClientId() {
    return clientId;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Application application = (Application) o;
    return Objects.equals(this.id, application.id) &&
        Objects.equals(this.ownerIdentifier, application.ownerIdentifier) &&
        Objects.equals(this.ownerName, application.ownerName) &&
        Objects.equals(this.ownerType, application.ownerType) &&
        Objects.equals(this.name, application.name) &&
        Objects.equals(this.redirectUris, application.redirectUris) &&
        Objects.equals(this.clientId, application.clientId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, ownerIdentifier, ownerName, ownerType, name, redirectUris, clientId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Application {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    redirectUris: ").append(toIndentedString(redirectUris)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

