/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.5.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.BeneficiaryCharge;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PayableContractSupplierItemBeneficiary is a registered account with rights to compensation within a booking.
 */
@JsonPropertyOrder({
  PayableContractSupplierItemBeneficiary.JSON_PROPERTY_IDENTIFIER,
  PayableContractSupplierItemBeneficiary.JSON_PROPERTY_IDENTIFIER_TYPE,
  PayableContractSupplierItemBeneficiary.JSON_PROPERTY_AMOUNT_DUE,
  PayableContractSupplierItemBeneficiary.JSON_PROPERTY_TYPE,
  PayableContractSupplierItemBeneficiary.JSON_PROPERTY_METADATA
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T18:25:21.624211675+07:00[Asia/Bangkok]")
public class PayableContractSupplierItemBeneficiary {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  /**
   * The identifierType tells us what type of identifier this is
   */
  public enum IdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    IdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IdentifierTypeEnum fromValue(String value) {
      for (IdentifierTypeEnum b : IdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_IDENTIFIER_TYPE = "identifierType";
  private IdentifierTypeEnum identifierType;

  public static final String JSON_PROPERTY_AMOUNT_DUE = "amountDue";
  private BeneficiaryCharge amountDue;

  /**
   * The type of beneficiary payment.
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    TRIP_PAY("TRIP_PAY"),
    
    SALE("SALE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public PayableContractSupplierItemBeneficiary() {
  }

  public PayableContractSupplierItemBeneficiary identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * identifier of beneficiary that can map to an account with us
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public PayableContractSupplierItemBeneficiary identifierType(IdentifierTypeEnum identifierType) {
    
    this.identifierType = identifierType;
    return this;
  }

   /**
   * The identifierType tells us what type of identifier this is
   * @return identifierType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public IdentifierTypeEnum getIdentifierType() {
    return identifierType;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifierType(IdentifierTypeEnum identifierType) {
    this.identifierType = identifierType;
  }


  public PayableContractSupplierItemBeneficiary amountDue(BeneficiaryCharge amountDue) {
    
    this.amountDue = amountDue;
    return this;
  }

   /**
   * Get amountDue
   * @return amountDue
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BeneficiaryCharge getAmountDue() {
    return amountDue;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDue(BeneficiaryCharge amountDue) {
    this.amountDue = amountDue;
  }


  public PayableContractSupplierItemBeneficiary type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of beneficiary payment.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public PayableContractSupplierItemBeneficiary metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public PayableContractSupplierItemBeneficiary putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Place to add more data related to the booking contract.
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayableContractSupplierItemBeneficiary payableContractSupplierItemBeneficiary = (PayableContractSupplierItemBeneficiary) o;
    return Objects.equals(this.identifier, payableContractSupplierItemBeneficiary.identifier) &&
        Objects.equals(this.identifierType, payableContractSupplierItemBeneficiary.identifierType) &&
        Objects.equals(this.amountDue, payableContractSupplierItemBeneficiary.amountDue) &&
        Objects.equals(this.type, payableContractSupplierItemBeneficiary.type) &&
        Objects.equals(this.metadata, payableContractSupplierItemBeneficiary.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, identifierType, amountDue, type, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayableContractSupplierItemBeneficiary {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    identifierType: ").append(toIndentedString(identifierType)).append("\n");
    sb.append("    amountDue: ").append(toIndentedString(amountDue)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

