/*
 * Wink Payment API
 * A programmatic way to create bookings, receive payment and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.5.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.UpsertAddressRequest;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertAccountRequest
 */
@JsonPropertyOrder({
  UpsertAccountRequest.JSON_PROPERTY_NAME,
  UpsertAccountRequest.JSON_PROPERTY_LEGAL_NAME,
  UpsertAccountRequest.JSON_PROPERTY_DESCRIPTION,
  UpsertAccountRequest.JSON_PROPERTY_URL,
  UpsertAccountRequest.JSON_PROPERTY_ACCOUNT_EMAIL,
  UpsertAccountRequest.JSON_PROPERTY_ACCOUNT_PHONE_NUMBER,
  UpsertAccountRequest.JSON_PROPERTY_CURRENCY_CODE,
  UpsertAccountRequest.JSON_PROPERTY_ADDRESS,
  UpsertAccountRequest.JSON_PROPERTY_PREFERRED_DISBURSEMENT_TYPE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T18:25:21.624211675+07:00[Asia/Bangkok]")
public class UpsertAccountRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_ACCOUNT_EMAIL = "accountEmail";
  private String accountEmail;

  public static final String JSON_PROPERTY_ACCOUNT_PHONE_NUMBER = "accountPhoneNumber";
  private String accountPhoneNumber;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private UpsertAddressRequest address;

  /**
   * The preferred method which the account holder wishes to be paid. This will play a role if we choose to automate the payout flow.
   */
  public enum PreferredDisbursementTypeEnum {
    VIRTUAL_CREDIT_CARD("VIRTUAL_CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER");

    private String value;

    PreferredDisbursementTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PreferredDisbursementTypeEnum fromValue(String value) {
      for (PreferredDisbursementTypeEnum b : PreferredDisbursementTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PREFERRED_DISBURSEMENT_TYPE = "preferredDisbursementType";
  private PreferredDisbursementTypeEnum preferredDisbursementType = PreferredDisbursementTypeEnum.BANK_TRANSFER;

  public UpsertAccountRequest() {
  }

  public UpsertAccountRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company / full name of person
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertAccountRequest legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of entity if other than name
   * @return legalName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public UpsertAccountRequest description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Short company / person description.
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public UpsertAccountRequest url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Company website. If private person with no personal website, link to main social network account.
   * @return url
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public UpsertAccountRequest accountEmail(String accountEmail) {
    
    this.accountEmail = accountEmail;
    return this;
  }

   /**
   * Company website. If private person with no personal website, link to main social network account.
   * @return accountEmail
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountEmail() {
    return accountEmail;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountEmail(String accountEmail) {
    this.accountEmail = accountEmail;
  }


  public UpsertAccountRequest accountPhoneNumber(String accountPhoneNumber) {
    
    this.accountPhoneNumber = accountPhoneNumber;
    return this;
  }

   /**
   * Account phone number is mostly used for KYC purchases
   * @return accountPhoneNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCOUNT_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountPhoneNumber() {
    return accountPhoneNumber;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountPhoneNumber(String accountPhoneNumber) {
    this.accountPhoneNumber = accountPhoneNumber;
  }


  public UpsertAccountRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Account&#39;s main currency.
   * @return currencyCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=3,max=3)
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public UpsertAccountRequest address(UpsertAddressRequest address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UpsertAddressRequest getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(UpsertAddressRequest address) {
    this.address = address;
  }


  public UpsertAccountRequest preferredDisbursementType(PreferredDisbursementTypeEnum preferredDisbursementType) {
    
    this.preferredDisbursementType = preferredDisbursementType;
    return this;
  }

   /**
   * The preferred method which the account holder wishes to be paid. This will play a role if we choose to automate the payout flow.
   * @return preferredDisbursementType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREFERRED_DISBURSEMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PreferredDisbursementTypeEnum getPreferredDisbursementType() {
    return preferredDisbursementType;
  }


  @JsonProperty(JSON_PROPERTY_PREFERRED_DISBURSEMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferredDisbursementType(PreferredDisbursementTypeEnum preferredDisbursementType) {
    this.preferredDisbursementType = preferredDisbursementType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertAccountRequest upsertAccountRequest = (UpsertAccountRequest) o;
    return Objects.equals(this.name, upsertAccountRequest.name) &&
        Objects.equals(this.legalName, upsertAccountRequest.legalName) &&
        Objects.equals(this.description, upsertAccountRequest.description) &&
        Objects.equals(this.url, upsertAccountRequest.url) &&
        Objects.equals(this.accountEmail, upsertAccountRequest.accountEmail) &&
        Objects.equals(this.accountPhoneNumber, upsertAccountRequest.accountPhoneNumber) &&
        Objects.equals(this.currencyCode, upsertAccountRequest.currencyCode) &&
        Objects.equals(this.address, upsertAccountRequest.address) &&
        Objects.equals(this.preferredDisbursementType, upsertAccountRequest.preferredDisbursementType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, legalName, description, url, accountEmail, accountPhoneNumber, currencyCode, address, preferredDisbursementType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertAccountRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    accountEmail: ").append(toIndentedString(accountEmail)).append("\n");
    sb.append("    accountPhoneNumber: ").append(toIndentedString(accountPhoneNumber)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    preferredDisbursementType: ").append(toIndentedString(preferredDisbursementType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

