/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.13.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.AffiliateInformation;
import io.trippay.sdk.payment.model.Integrator;
import io.trippay.sdk.payment.model.PricedSupplierContractWithAcquirer;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A contract record is what gets saved upon pricing and converted to a BookingContract on reactive and subsequently removed.
 */
@JsonPropertyOrder({
  PayableContract.JSON_PROPERTY_ID,
  PayableContract.JSON_PROPERTY_CREATED_DATE,
  PayableContract.JSON_PROPERTY_LAST_UPDATE,
  PayableContract.JSON_PROPERTY_VERSION,
  PayableContract.JSON_PROPERTY_AFFILIATE,
  PayableContract.JSON_PROPERTY_DISPLAY_CURRENCY,
  PayableContract.JSON_PROPERTY_REDIRECT_URL,
  PayableContract.JSON_PROPERTY_CONTRACT,
  PayableContract.JSON_PROPERTY_ACQUIRER_LIST,
  PayableContract.JSON_PROPERTY_METADATA,
  PayableContract.JSON_PROPERTY_INSTANT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-05T14:34:29.480943721+07:00[Asia/Bangkok]")
public class PayableContract {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public static final String JSON_PROPERTY_AFFILIATE = "affiliate";
  private AffiliateInformation affiliate;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency = "USD";

  public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
  private String redirectUrl;

  public static final String JSON_PROPERTY_CONTRACT = "contract";
  private PricedSupplierContractWithAcquirer contract;

  public static final String JSON_PROPERTY_ACQUIRER_LIST = "acquirerList";
  private List<Integrator> acquirerList = new ArrayList<>();

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_INSTANT = "instant";
  private java.time.LocalDateTime instant;

  public PayableContract() {
  }

  public PayableContract id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public PayableContract createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public PayableContract lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public PayableContract version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public PayableContract affiliate(AffiliateInformation affiliate) {
    
    this.affiliate = affiliate;
    return this;
  }

   /**
   * Get affiliate
   * @return affiliate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AFFILIATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AffiliateInformation getAffiliate() {
    return affiliate;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliate(AffiliateInformation affiliate) {
    this.affiliate = affiliate;
  }


  public PayableContract displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The desired quote
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public PayableContract redirectUrl(String redirectUrl) {
    
    this.redirectUrl = redirectUrl;
    return this;
  }

   /**
   * Where to redirect to after booking [in-]complete
   * @return redirectUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRedirectUrl() {
    return redirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRedirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
  }


  public PayableContract contract(PricedSupplierContractWithAcquirer contract) {
    
    this.contract = contract;
    return this;
  }

   /**
   * Get contract
   * @return contract
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricedSupplierContractWithAcquirer getContract() {
    return contract;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContract(PricedSupplierContractWithAcquirer contract) {
    this.contract = contract;
  }


  public PayableContract acquirerList(List<Integrator> acquirerList) {
    
    this.acquirerList = acquirerList;
    return this;
  }

  public PayableContract addAcquirerListItem(Integrator acquirerListItem) {
    if (this.acquirerList == null) {
      this.acquirerList = new ArrayList<>();
    }
    this.acquirerList.add(acquirerListItem);
    return this;
  }

   /**
   * Get acquirerList
   * @return acquirerList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ACQUIRER_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Integrator> getAcquirerList() {
    return acquirerList;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerList(List<Integrator> acquirerList) {
    this.acquirerList = acquirerList;
  }


  public PayableContract metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public PayableContract putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Depending on the acquirer, we put in required data for creating the payment.
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public PayableContract instant(java.time.LocalDateTime instant) {
    
    this.instant = instant;
    return this;
  }

   /**
   * Date to attach TTL. Self-deletes after 1 hour of unuse.
   * @return instant
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INSTANT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getInstant() {
    return instant;
  }


  @JsonProperty(JSON_PROPERTY_INSTANT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInstant(java.time.LocalDateTime instant) {
    this.instant = instant;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayableContract payableContract = (PayableContract) o;
    return Objects.equals(this.id, payableContract.id) &&
        Objects.equals(this.createdDate, payableContract.createdDate) &&
        Objects.equals(this.lastUpdate, payableContract.lastUpdate) &&
        Objects.equals(this.version, payableContract.version) &&
        Objects.equals(this.affiliate, payableContract.affiliate) &&
        Objects.equals(this.displayCurrency, payableContract.displayCurrency) &&
        Objects.equals(this.redirectUrl, payableContract.redirectUrl) &&
        Objects.equals(this.contract, payableContract.contract) &&
        Objects.equals(this.acquirerList, payableContract.acquirerList) &&
        Objects.equals(this.metadata, payableContract.metadata) &&
        Objects.equals(this.instant, payableContract.instant);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, affiliate, displayCurrency, redirectUrl, contract, acquirerList, metadata, instant);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayableContract {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    affiliate: ").append(toIndentedString(affiliate)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    redirectUrl: ").append(toIndentedString(redirectUrl)).append("\n");
    sb.append("    contract: ").append(toIndentedString(contract)).append("\n");
    sb.append("    acquirerList: ").append(toIndentedString(acquirerList)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    instant: ").append(toIndentedString(instant)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

