package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.AggregateBookingContractCancellationState;
import io.trippay.sdk.payment.model.AggregateBookingContractCaptureCurrenciesByAccountResponse;
import io.trippay.sdk.payment.model.BeneficiaryAggregateData;
import io.trippay.sdk.payment.model.BookingContract;
import io.trippay.sdk.payment.model.BookingContractCancellableResponse;
import io.trippay.sdk.payment.model.BookingContractGridResponse;
import io.trippay.sdk.payment.model.CancelBookingContractRequest;
import io.trippay.sdk.payment.model.ExternalBookingContract;
import io.trippay.sdk.payment.model.ImmediateRefundRequest;
import io.trippay.sdk.payment.model.PayableContract;
import io.trippay.sdk.payment.model.PayableContractRequest;
import io.trippay.sdk.payment.model.PayableContractResponse;
import io.trippay.sdk.payment.model.RefundRequest;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.TotalAggregateFunds;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T14:54:12.025630330+07:00[Asia/Bangkok]")
public class ContractApi {
    private ApiClient apiClient;

    public ContractApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContractApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingContractRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> cancelBookingContract(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> cancelBookingContractWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Cancel booking
     * Cancels a booking contract. Based on the type of cancellation policy, will do a refund or partial refund to the payment method.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelBookingContractWithResponseSpec(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return cancelBookingContractRequestCreation(identifier, cancelBookingContractRequest, winkVersion);
    }
    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelGroupBookingContractRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling cancelGroupBookingContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> cancelGroupBookingContract(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BookingContract&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContract>>> cancelGroupBookingContractWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Cancel group bookings
     * Cancels a group booking contract. All bookings under the same traceId.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelGroupBookingContractWithResponseSpec(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return cancelGroupBookingContractRequestCreation(traceId, cancelBookingContractRequest, winkVersion);
    }
    /**
     * Create payable contracts
     * Returns a list of contracts that can be used alongside reactive widget to initiate a reactive.
     * <p><b>200</b> - OK
     * @param payableContractRequest The payableContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;PayableContractResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPayableContractsRequestCreation(PayableContractRequest payableContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = payableContractRequest;
        // verify the required parameter 'payableContractRequest' is set
        if (payableContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'payableContractRequest' when calling createPayableContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PayableContractResponse> localVarReturnType = new ParameterizedTypeReference<PayableContractResponse>() {};
        return apiClient.invokeAPI("/api/contract/payable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create payable contracts
     * Returns a list of contracts that can be used alongside reactive widget to initiate a reactive.
     * <p><b>200</b> - OK
     * @param payableContractRequest The payableContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;PayableContractResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<PayableContractResponse> createPayableContracts(PayableContractRequest payableContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PayableContractResponse> localVarReturnType = new ParameterizedTypeReference<PayableContractResponse>() {};
        return createPayableContractsRequestCreation(payableContractRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Create payable contracts
     * Returns a list of contracts that can be used alongside reactive widget to initiate a reactive.
     * <p><b>200</b> - OK
     * @param payableContractRequest The payableContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;PayableContractResponse&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<PayableContractResponse>>> createPayableContractsWithHttpInfo(PayableContractRequest payableContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PayableContractResponse> localVarReturnType = new ParameterizedTypeReference<PayableContractResponse>() {};
        return createPayableContractsRequestCreation(payableContractRequest, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Create payable contracts
     * Returns a list of contracts that can be used alongside reactive widget to initiate a reactive.
     * <p><b>200</b> - OK
     * @param payableContractRequest The payableContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPayableContractsWithResponseSpec(PayableContractRequest payableContractRequest, String winkVersion) throws WebClientResponseException {
        return createPayableContractsRequestCreation(payableContractRequest, winkVersion);
    }
    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec immediateGroupRefundRequestCreation(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = immediateRefundRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling immediateGroupRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'immediateRefundRequest' is set
        if (immediateRefundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'immediateRefundRequest' when calling immediateGroupRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/immediate-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> immediateGroupRefund(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BookingContract&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContract>>> immediateGroupRefundWithHttpInfo(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Immediate group refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec immediateGroupRefundWithResponseSpec(String traceId, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        return immediateGroupRefundRequestCreation(traceId, immediateRefundRequest, winkVersion);
    }
    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec immediateRefundRequestCreation(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = immediateRefundRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling immediateRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'immediateRefundRequest' is set
        if (immediateRefundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'immediateRefundRequest' when calling immediateRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/immediate-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> immediateRefund(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> immediateRefundWithHttpInfo(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Immediate refund
     * In the event that a booking is not possible on the partner site due to lack of availability, or similar. This endpoint offers a 3-minute window to let that partner refund the traveler 100% of her funds.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param immediateRefundRequest Accompanying payload that described the optional reason for using this endpoint.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec immediateRefundWithResponseSpec(String identifier, ImmediateRefundRequest immediateRefundRequest, String winkVersion) throws WebClientResponseException {
        return immediateRefundRequestCreation(identifier, immediateRefundRequest, winkVersion);
    }
    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isContractCancellableRequestCreation(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContractCancellableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractCancellableResponse> isContractCancellable(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContractCancellableResponse>> isContractCancellableWithHttpInfo(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isContractCancellableWithResponseSpec(String identifier, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion) throws WebClientResponseException {
        return isContractCancellableRequestCreation(identifier, cancelBookingContractRequest, winkVersion);
    }
    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isGroupContractCancellableRequestCreation(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = cancelBookingContractRequest;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancelBookingContractRequest' is set
        if (cancelBookingContractRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancelBookingContractRequest' when calling isGroupContractCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}/cancellable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingContractCancellableResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContractCancellableResponse> isGroupContractCancellable(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BookingContractCancellableResponse&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContractCancellableResponse>>> isGroupContractCancellableWithHttpInfo(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractCancellableResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractCancellableResponse>() {};
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Group contract cancellable
     * Returns whether a booking can be cancelled or not and any rules associated with cancelling.
     * <p><b>200</b> - OK
     * @param traceId Booking contract traceId
     * @param cancelBookingContractRequest The cancelBookingContractRequest parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isGroupContractCancellableWithResponseSpec(String traceId, CancelBookingContractRequest cancelBookingContractRequest, String winkVersion, String accept) throws WebClientResponseException {
        return isGroupContractCancellableRequestCreation(traceId, cancelBookingContractRequest, winkVersion, accept);
    }
    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec requestRefundRequestCreation(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = refundRequest;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'refundRequest' is set
        if (refundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'refundRequest' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}/request-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> requestRefund(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return requestRefundRequestCreation(identifier, refundRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> requestRefundWithHttpInfo(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return requestRefundRequestCreation(identifier, refundRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Request refund
     * Requests a refund for a booking contract. Creates a refund request record that needs to be approved by a payment admin.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param refundRequest The refundRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec requestRefundWithResponseSpec(String identifier, RefundRequest refundRequest, String winkVersion) throws WebClientResponseException {
        return requestRefundRequestCreation(identifier, refundRequest, winkVersion);
    }
    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateBookingContractDataRequestCreation(String accountIdentifier, String type, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateBookingContractData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/beneficiary", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BeneficiaryAggregateData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BeneficiaryAggregateData> showAggregateBookingContractData(String accountIdentifier, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BeneficiaryAggregateData&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BeneficiaryAggregateData>>> showAggregateBookingContractDataWithHttpInfo(String accountIdentifier, String type, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BeneficiaryAggregateData> localVarReturnType = new ParameterizedTypeReference<BeneficiaryAggregateData>() {};
        return showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Retrieve aggregate beneficiary data
     * Returns aggregate contract data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param type The type parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAggregateBookingContractDataWithResponseSpec(String accountIdentifier, String type, String winkVersion, String accept) throws WebClientResponseException {
        return showAggregateBookingContractDataRequestCreation(accountIdentifier, type, winkVersion, accept);
    }
    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAggregateCancellationDataRequestCreation(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showAggregateCancellationData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/aggregate/cancellation", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AggregateBookingContractCancellationState&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AggregateBookingContractCancellationState> showAggregateCancellationData(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;AggregateBookingContractCancellationState&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<AggregateBookingContractCancellationState>>> showAggregateCancellationDataWithHttpInfo(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCancellationState> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCancellationState>() {};
        return showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Retrieve aggregate cancellation data
     * Returns aggregate cancellation data this account identifier has participated in.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAggregateCancellationDataWithResponseSpec(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAggregateCancellationDataRequestCreation(accountIdentifier, winkVersion, accept);
    }
    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AggregateBookingContractCaptureCurrenciesByAccountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCaptureCurrenciesRequestCreation(String accountIdentifier, String state, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showCaptureCurrencies", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/capture", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AggregateBookingContractCaptureCurrenciesByAccountResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AggregateBookingContractCaptureCurrenciesByAccountResponse> showCaptureCurrencies(String accountIdentifier, String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AggregateBookingContractCaptureCurrenciesByAccountResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AggregateBookingContractCaptureCurrenciesByAccountResponse>> showCaptureCurrenciesWithHttpInfo(String accountIdentifier, String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse> localVarReturnType = new ParameterizedTypeReference<AggregateBookingContractCaptureCurrenciesByAccountResponse>() {};
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Retrieve capture currencies
     * Returns a list of capture currencies and amounts for the account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The accountIdentifier parameter
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCaptureCurrenciesWithResponseSpec(String accountIdentifier, String state, String winkVersion, String accept) throws WebClientResponseException {
        return showCaptureCurrenciesRequestCreation(accountIdentifier, state, winkVersion, accept);
    }
    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractRequestCreation(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContract> showContract(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContract>> showContractWithHttpInfo(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractRequestCreation(identifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Retrieve single contract
     * Returns a booking contract by its unique identifier.
     * <p><b>200</b> - OK
     * @param identifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractWithResponseSpec(String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return showContractRequestCreation(identifier, winkVersion, accept);
    }
    /**
     * Retrieve single contract for external account
     * Loads a booking contract based on external account identifier and actual contract identifier.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param bookingContractIdentifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ExternalBookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractForExternalAccountRequestCreation(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'externalAccountIdentifier' is set
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling showContractForExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingContractIdentifier' is set
        if (bookingContractIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingContractIdentifier' when calling showContractForExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);
        pathParams.put("bookingContractIdentifier", bookingContractIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>() {};
        return apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}/contract/{bookingContractIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve single contract for external account
     * Loads a booking contract based on external account identifier and actual contract identifier.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param bookingContractIdentifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ExternalBookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ExternalBookingContract> showContractForExternalAccount(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>() {};
        return showContractForExternalAccountRequestCreation(externalAccountIdentifier, bookingContractIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve single contract for external account
     * Loads a booking contract based on external account identifier and actual contract identifier.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param bookingContractIdentifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ExternalBookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ExternalBookingContract>> showContractForExternalAccountWithHttpInfo(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>() {};
        return showContractForExternalAccountRequestCreation(externalAccountIdentifier, bookingContractIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Retrieve single contract for external account
     * Loads a booking contract based on external account identifier and actual contract identifier.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param bookingContractIdentifier Booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractForExternalAccountWithResponseSpec(String externalAccountIdentifier, String bookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showContractForExternalAccountRequestCreation(externalAccountIdentifier, bookingContractIdentifier, winkVersion, accept);
    }
    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return TotalAggregateFunds
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractFundsRequestCreation(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showContractFunds", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "accountFundsOnly", accountFundsOnly));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/funds", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return TotalAggregateFunds
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<TotalAggregateFunds> showContractFunds(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>() {};
        return showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;TotalAggregateFunds&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<TotalAggregateFunds>> showContractFundsWithHttpInfo(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TotalAggregateFunds> localVarReturnType = new ParameterizedTypeReference<TotalAggregateFunds>() {};
        return showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Retrieve contract funds
     * Returns booking contract funds for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractFundsWithResponseSpec(String accountIdentifier, String state, Boolean accountFundsOnly, String winkVersion, String accept) throws WebClientResponseException {
        return showContractFundsRequestCreation(accountIdentifier, state, accountFundsOnly, winkVersion, accept);
    }
    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state2 The optional state to filter on
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return BookingContractGridResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractGridRequestCreation(String accountIdentifier, State state2, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        Object postBody = state2;
        // verify the required parameter 'accountIdentifier' is set
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showContractGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'state2' is set
        if (state2 == null) {
            throw new WebClientResponseException("Missing the required parameter 'state2' when calling showContractGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("accountIdentifier", accountIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "accountFundsOnly", accountFundsOnly));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return apiClient.invokeAPI("/api/account/{accountIdentifier}/contract/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state2 The optional state to filter on
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return BookingContractGridResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingContractGridResponse> showContractGrid(String accountIdentifier, State state2, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return showContractGridRequestCreation(accountIdentifier, state2, state, accountFundsOnly, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state2 The optional state to filter on
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingContractGridResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingContractGridResponse>> showContractGridWithHttpInfo(String accountIdentifier, State state2, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContractGridResponse> localVarReturnType = new ParameterizedTypeReference<BookingContractGridResponse>() {};
        return showContractGridRequestCreation(accountIdentifier, state2, state, accountFundsOnly, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Retrieve contract grid
     * Returns booking contracts for account identifier.
     * <p><b>200</b> - OK
     * @param accountIdentifier The account owner
     * @param state2 The optional state to filter on
     * @param state The optional state to want to receive funds for
     * @param accountFundsOnly Whether to only returns funds for that account identifier or total funds that account identifier was part of. (defaults to false).
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractGridWithResponseSpec(String accountIdentifier, State state2, String state, Boolean accountFundsOnly, String winkVersion) throws WebClientResponseException {
        return showContractGridRequestCreation(accountIdentifier, state2, state, accountFundsOnly, winkVersion);
    }
    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContractsRequestCreation(String traceId, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'traceId' is set
        if (traceId == null) {
            throw new WebClientResponseException("Missing the required parameter 'traceId' when calling showContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("traceId", traceId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return apiClient.invokeAPI("/api/contract/list/{traceId}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingContract> showContracts(String traceId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BookingContract&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingContract>>> showContractsWithHttpInfo(String traceId, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingContract> localVarReturnType = new ParameterizedTypeReference<BookingContract>() {};
        return showContractsRequestCreation(traceId, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Retrieve multiple contracts
     * Returns booking contracts matching traceId.
     * <p><b>200</b> - OK
     * @param traceId Trace identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContractsWithResponseSpec(String traceId, String winkVersion, String accept) throws WebClientResponseException {
        return showContractsRequestCreation(traceId, winkVersion, accept);
    }
    /**
     * Retrieve single contract for external
     * Loads a booking contract based on external account and contract identifiers.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param externalBookingContractIdentifier External booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ExternalBookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showExternalContractRequestCreation(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'externalAccountIdentifier' is set
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling showExternalContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'externalBookingContractIdentifier' is set
        if (externalBookingContractIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalBookingContractIdentifier' when calling showExternalContract", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);
        pathParams.put("externalBookingContractIdentifier", externalBookingContractIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>() {};
        return apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}/contract/external/{externalBookingContractIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve single contract for external
     * Loads a booking contract based on external account and contract identifiers.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param externalBookingContractIdentifier External booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ExternalBookingContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ExternalBookingContract> showExternalContract(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>() {};
        return showExternalContractRequestCreation(externalAccountIdentifier, externalBookingContractIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Retrieve single contract for external
     * Loads a booking contract based on external account and contract identifiers.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param externalBookingContractIdentifier External booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ExternalBookingContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ExternalBookingContract>> showExternalContractWithHttpInfo(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalBookingContract> localVarReturnType = new ParameterizedTypeReference<ExternalBookingContract>() {};
        return showExternalContractRequestCreation(externalAccountIdentifier, externalBookingContractIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Retrieve single contract for external
     * Loads a booking contract based on external account and contract identifiers.
     * <p><b>200</b> - OK
     * @param externalAccountIdentifier Show contract owned by this external account
     * @param externalBookingContractIdentifier External booking contract identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showExternalContractWithResponseSpec(String externalAccountIdentifier, String externalBookingContractIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showExternalContractRequestCreation(externalAccountIdentifier, externalBookingContractIdentifier, winkVersion, accept);
    }
    /**
     * Load payable contracts
     * Returns a transient contract based on specified identifier.
     * <p><b>200</b> - OK
     * @param transientContractIdentifier Transient contract to retrieve
     * @param currency Desired currency
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PayableContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPayableContractsRequestCreation(String transientContractIdentifier, String currency, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'transientContractIdentifier' is set
        if (transientContractIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'transientContractIdentifier' when calling showPayableContracts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("transientContractIdentifier", transientContractIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "currency", currency));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PayableContract> localVarReturnType = new ParameterizedTypeReference<PayableContract>() {};
        return apiClient.invokeAPI("/api/contract/payable/{transientContractIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Load payable contracts
     * Returns a transient contract based on specified identifier.
     * <p><b>200</b> - OK
     * @param transientContractIdentifier Transient contract to retrieve
     * @param currency Desired currency
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PayableContract
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PayableContract> showPayableContracts(String transientContractIdentifier, String currency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PayableContract> localVarReturnType = new ParameterizedTypeReference<PayableContract>() {};
        return showPayableContractsRequestCreation(transientContractIdentifier, currency, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Load payable contracts
     * Returns a transient contract based on specified identifier.
     * <p><b>200</b> - OK
     * @param transientContractIdentifier Transient contract to retrieve
     * @param currency Desired currency
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PayableContract&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PayableContract>> showPayableContractsWithHttpInfo(String transientContractIdentifier, String currency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PayableContract> localVarReturnType = new ParameterizedTypeReference<PayableContract>() {};
        return showPayableContractsRequestCreation(transientContractIdentifier, currency, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Load payable contracts
     * Returns a transient contract based on specified identifier.
     * <p><b>200</b> - OK
     * @param transientContractIdentifier Transient contract to retrieve
     * @param currency Desired currency
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPayableContractsWithResponseSpec(String transientContractIdentifier, String currency, String winkVersion, String accept) throws WebClientResponseException {
        return showPayableContractsRequestCreation(transientContractIdentifier, currency, winkVersion, accept);
    }
}
