/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.16.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SendNotification
 */
@JsonPropertyOrder({
  SendNotification.JSON_PROPERTY_IDENTIFIERS,
  SendNotification.JSON_PROPERTY_PRIORITY,
  SendNotification.JSON_PROPERTY_TYPE,
  SendNotification.JSON_PROPERTY_RECIPIENT_TYPE,
  SendNotification.JSON_PROPERTY_APPLICATION,
  SendNotification.JSON_PROPERTY_MESSAGE_TEMPLATE_ID,
  SendNotification.JSON_PROPERTY_NOTIFY_VIA_EMAIL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T14:54:12.025630330+07:00[Asia/Bangkok]")
public class SendNotification {
  public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
  private List<String> identifiers;

  /**
   * Notification importance
   */
  public enum PriorityEnum {
    HIGH("HIGH"),
    
    MEDIUM("MEDIUM"),
    
    LOW("LOW");

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private PriorityEnum priority;

  /**
   * Notification type
   */
  public enum TypeEnum {
    ALERT("ALERT"),
    
    MESSAGE("MESSAGE"),
    
    FEATURE("FEATURE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Recipient type
   */
  public enum RecipientTypeEnum {
    USER("USER"),
    
    ACCOUNT("ACCOUNT");

    private String value;

    RecipientTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecipientTypeEnum fromValue(String value) {
      for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECIPIENT_TYPE = "recipientType";
  private RecipientTypeEnum recipientType;

  /**
   * Application domain
   */
  public enum ApplicationEnum {
    EXTRANET("EXTRANET"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    STUDIO("STUDIO"),
    
    PAYMENT("PAYMENT");

    private String value;

    ApplicationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ApplicationEnum fromValue(String value) {
      for (ApplicationEnum b : ApplicationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_APPLICATION = "application";
  private ApplicationEnum application;

  public static final String JSON_PROPERTY_MESSAGE_TEMPLATE_ID = "messageTemplateId";
  private String messageTemplateId;

  public static final String JSON_PROPERTY_NOTIFY_VIA_EMAIL = "notifyViaEmail";
  private Boolean notifyViaEmail;

  public SendNotification() {
  }

  public SendNotification identifiers(List<String> identifiers) {
    
    this.identifiers = identifiers;
    return this;
  }

  public SendNotification addIdentifiersItem(String identifiersItem) {
    if (this.identifiers == null) {
      this.identifiers = new ArrayList<>();
    }
    this.identifiers.add(identifiersItem);
    return this;
  }

   /**
   * identifiers of entities we want to create a announcement for
   * @return identifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getIdentifiers() {
    return identifiers;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifiers(List<String> identifiers) {
    this.identifiers = identifiers;
  }


  public SendNotification priority(PriorityEnum priority) {
    
    this.priority = priority;
    return this;
  }

   /**
   * Notification importance
   * @return priority
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PriorityEnum getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }


  public SendNotification type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Notification type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public SendNotification recipientType(RecipientTypeEnum recipientType) {
    
    this.recipientType = recipientType;
    return this;
  }

   /**
   * Recipient type
   * @return recipientType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_RECIPIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RecipientTypeEnum getRecipientType() {
    return recipientType;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRecipientType(RecipientTypeEnum recipientType) {
    this.recipientType = recipientType;
  }


  public SendNotification application(ApplicationEnum application) {
    
    this.application = application;
    return this;
  }

   /**
   * Application domain
   * @return application
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_APPLICATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ApplicationEnum getApplication() {
    return application;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setApplication(ApplicationEnum application) {
    this.application = application;
  }


  public SendNotification messageTemplateId(String messageTemplateId) {
    
    this.messageTemplateId = messageTemplateId;
    return this;
  }

   /**
   * Which text template to use
   * @return messageTemplateId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MESSAGE_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMessageTemplateId() {
    return messageTemplateId;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMessageTemplateId(String messageTemplateId) {
    this.messageTemplateId = messageTemplateId;
  }


  public SendNotification notifyViaEmail(Boolean notifyViaEmail) {
    
    this.notifyViaEmail = notifyViaEmail;
    return this;
  }

   /**
   * Whether to also send this announcement via email
   * @return notifyViaEmail
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NOTIFY_VIA_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getNotifyViaEmail() {
    return notifyViaEmail;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFY_VIA_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNotifyViaEmail(Boolean notifyViaEmail) {
    this.notifyViaEmail = notifyViaEmail;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendNotification sendNotification = (SendNotification) o;
    return Objects.equals(this.identifiers, sendNotification.identifiers) &&
        Objects.equals(this.priority, sendNotification.priority) &&
        Objects.equals(this.type, sendNotification.type) &&
        Objects.equals(this.recipientType, sendNotification.recipientType) &&
        Objects.equals(this.application, sendNotification.application) &&
        Objects.equals(this.messageTemplateId, sendNotification.messageTemplateId) &&
        Objects.equals(this.notifyViaEmail, sendNotification.notifyViaEmail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifiers, priority, type, recipientType, application, messageTemplateId, notifyViaEmail);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendNotification {\n");
    sb.append("    identifiers: ").append(toIndentedString(identifiers)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    recipientType: ").append(toIndentedString(recipientType)).append("\n");
    sb.append("    application: ").append(toIndentedString(application)).append("\n");
    sb.append("    messageTemplateId: ").append(toIndentedString(messageTemplateId)).append("\n");
    sb.append("    notifyViaEmail: ").append(toIndentedString(notifyViaEmail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

