/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.CountResponse;
import io.trippay.sdk.payment.model.NotificationView;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec removeNotificationRequestCreation(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/message/{messageIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<NotificationView> removeNotification(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.removeNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<NotificationView>> removeNotificationWithHttpInfo(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.removeNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeNotificationWithResponseSpec(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showNotificationRequestCreation(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (messageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'messageIdentifier' when calling showNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("messageIdentifier", messageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/message/{messageIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<NotificationView> showNotification(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.showNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<NotificationView>> showNotificationWithHttpInfo(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.showNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showNotificationWithResponseSpec(String accountIdentifier, String messageIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showNotificationRequestCreation(accountIdentifier, messageIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showNotificationsRequestCreation(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/message/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<NotificationView> showNotifications(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.showNotificationsRequestCreation(accountIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<NotificationView>>> showNotificationsWithHttpInfo(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationView> localVarReturnType = new ParameterizedTypeReference<NotificationView>(this){};
        return this.showNotificationsRequestCreation(accountIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showNotificationsWithResponseSpec(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showNotificationsRequestCreation(accountIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showUnreadMessageCountRequestCreation(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling showUnreadMessageCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/message/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CountResponse> showUnreadMessageCount(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(this){};
        return this.showUnreadMessageCountRequestCreation(accountIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponse>> showUnreadMessageCountWithHttpInfo(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(this){};
        return this.showUnreadMessageCountRequestCreation(accountIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUnreadMessageCountWithResponseSpec(String accountIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showUnreadMessageCountRequestCreation(accountIdentifier, winkVersion, accept);
    }
}

