/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"identifier", "ownerIdentifier", "priority", "type", "recipientType", "application", "messageTemplateId", "subject", "body", "ctaUrl", "read", "markedAsRemoved", "notifyViaEmail"})
public class Notification {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_RECIPIENT_TYPE = "recipientType";
    private RecipientTypeEnum recipientType;
    public static final String JSON_PROPERTY_APPLICATION = "application";
    private ApplicationEnum application;
    public static final String JSON_PROPERTY_MESSAGE_TEMPLATE_ID = "messageTemplateId";
    private String messageTemplateId;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;
    public static final String JSON_PROPERTY_BODY = "body";
    private String body;
    public static final String JSON_PROPERTY_CTA_URL = "ctaUrl";
    private String ctaUrl;
    public static final String JSON_PROPERTY_READ = "read";
    private Boolean read;
    public static final String JSON_PROPERTY_MARKED_AS_REMOVED = "markedAsRemoved";
    private Boolean markedAsRemoved;
    public static final String JSON_PROPERTY_NOTIFY_VIA_EMAIL = "notifyViaEmail";
    private Boolean notifyViaEmail;

    public Notification identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public Notification ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public Notification priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public Notification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Notification recipientType(RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="recipientType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RecipientTypeEnum getRecipientType() {
        return this.recipientType;
    }

    @JsonProperty(value="recipientType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipientType(RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
    }

    public Notification application(ApplicationEnum application) {
        this.application = application;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ApplicationEnum getApplication() {
        return this.application;
    }

    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApplication(ApplicationEnum application) {
        this.application = application;
    }

    public Notification messageTemplateId(String messageTemplateId) {
        this.messageTemplateId = messageTemplateId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="messageTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessageTemplateId() {
        return this.messageTemplateId;
    }

    @JsonProperty(value="messageTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessageTemplateId(String messageTemplateId) {
        this.messageTemplateId = messageTemplateId;
    }

    public Notification subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Notification body(String body) {
        this.body = body;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBody(String body) {
        this.body = body;
    }

    public Notification ctaUrl(String ctaUrl) {
        this.ctaUrl = ctaUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ctaUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCtaUrl() {
        return this.ctaUrl;
    }

    @JsonProperty(value="ctaUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCtaUrl(String ctaUrl) {
        this.ctaUrl = ctaUrl;
    }

    public Notification read(Boolean read) {
        this.read = read;
        return this;
    }

    @Nullable
    @JsonProperty(value="read")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRead() {
        return this.read;
    }

    @JsonProperty(value="read")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRead(Boolean read) {
        this.read = read;
    }

    public Notification markedAsRemoved(Boolean markedAsRemoved) {
        this.markedAsRemoved = markedAsRemoved;
        return this;
    }

    @Nullable
    @JsonProperty(value="markedAsRemoved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMarkedAsRemoved() {
        return this.markedAsRemoved;
    }

    @JsonProperty(value="markedAsRemoved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarkedAsRemoved(Boolean markedAsRemoved) {
        this.markedAsRemoved = markedAsRemoved;
    }

    public Notification notifyViaEmail(Boolean notifyViaEmail) {
        this.notifyViaEmail = notifyViaEmail;
        return this;
    }

    @Nullable
    @JsonProperty(value="notifyViaEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyViaEmail() {
        return this.notifyViaEmail;
    }

    @JsonProperty(value="notifyViaEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyViaEmail(Boolean notifyViaEmail) {
        this.notifyViaEmail = notifyViaEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification notification = (Notification)o;
        return Objects.equals(this.identifier, notification.identifier) && Objects.equals(this.ownerIdentifier, notification.ownerIdentifier) && Objects.equals((Object)this.priority, (Object)notification.priority) && Objects.equals((Object)this.type, (Object)notification.type) && Objects.equals((Object)this.recipientType, (Object)notification.recipientType) && Objects.equals((Object)this.application, (Object)notification.application) && Objects.equals(this.messageTemplateId, notification.messageTemplateId) && Objects.equals(this.subject, notification.subject) && Objects.equals(this.body, notification.body) && Objects.equals(this.ctaUrl, notification.ctaUrl) && Objects.equals(this.read, notification.read) && Objects.equals(this.markedAsRemoved, notification.markedAsRemoved) && Objects.equals(this.notifyViaEmail, notification.notifyViaEmail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.ownerIdentifier, this.priority, this.type, this.recipientType, this.application, this.messageTemplateId, this.subject, this.body, this.ctaUrl, this.read, this.markedAsRemoved, this.notifyViaEmail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Notification {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    recipientType: ").append(this.toIndentedString((Object)this.recipientType)).append("\n");
        sb.append("    application: ").append(this.toIndentedString((Object)this.application)).append("\n");
        sb.append("    messageTemplateId: ").append(this.toIndentedString(this.messageTemplateId)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    ctaUrl: ").append(this.toIndentedString(this.ctaUrl)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    markedAsRemoved: ").append(this.toIndentedString(this.markedAsRemoved)).append("\n");
        sb.append("    notifyViaEmail: ").append(this.toIndentedString(this.notifyViaEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PriorityEnum {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ALERT("ALERT"),
        MESSAGE("MESSAGE"),
        FEATURE("FEATURE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecipientTypeEnum {
        USER("USER"),
        ACCOUNT("ACCOUNT");

        private String value;

        private RecipientTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecipientTypeEnum fromValue(String value) {
            for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ApplicationEnum {
        EXTRANET("EXTRANET"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        STUDIO("STUDIO"),
        PAYMENT("PAYMENT");

        private String value;

        private ApplicationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ApplicationEnum fromValue(String value) {
            for (ApplicationEnum b : ApplicationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

