/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"identifiers", "priority", "type", "recipientType", "application", "messageTemplateId", "notifyViaEmail"})
public class SendNotification {
    public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
    private List<String> identifiers;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_RECIPIENT_TYPE = "recipientType";
    private RecipientTypeEnum recipientType;
    public static final String JSON_PROPERTY_APPLICATION = "application";
    private ApplicationEnum application;
    public static final String JSON_PROPERTY_MESSAGE_TEMPLATE_ID = "messageTemplateId";
    private String messageTemplateId;
    public static final String JSON_PROPERTY_NOTIFY_VIA_EMAIL = "notifyViaEmail";
    private Boolean notifyViaEmail;

    public SendNotification identifiers(List<String> identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public SendNotification addIdentifiersItem(String identifiersItem) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<String>();
        }
        this.identifiers.add(identifiersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifiers(List<String> identifiers) {
        this.identifiers = identifiers;
    }

    public SendNotification priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public SendNotification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SendNotification recipientType(RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="recipientType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RecipientTypeEnum getRecipientType() {
        return this.recipientType;
    }

    @JsonProperty(value="recipientType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipientType(RecipientTypeEnum recipientType) {
        this.recipientType = recipientType;
    }

    public SendNotification application(ApplicationEnum application) {
        this.application = application;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ApplicationEnum getApplication() {
        return this.application;
    }

    @JsonProperty(value="application")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApplication(ApplicationEnum application) {
        this.application = application;
    }

    public SendNotification messageTemplateId(String messageTemplateId) {
        this.messageTemplateId = messageTemplateId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="messageTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessageTemplateId() {
        return this.messageTemplateId;
    }

    @JsonProperty(value="messageTemplateId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessageTemplateId(String messageTemplateId) {
        this.messageTemplateId = messageTemplateId;
    }

    public SendNotification notifyViaEmail(Boolean notifyViaEmail) {
        this.notifyViaEmail = notifyViaEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="notifyViaEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getNotifyViaEmail() {
        return this.notifyViaEmail;
    }

    @JsonProperty(value="notifyViaEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNotifyViaEmail(Boolean notifyViaEmail) {
        this.notifyViaEmail = notifyViaEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendNotification sendNotification = (SendNotification)o;
        return Objects.equals(this.identifiers, sendNotification.identifiers) && Objects.equals((Object)this.priority, (Object)sendNotification.priority) && Objects.equals((Object)this.type, (Object)sendNotification.type) && Objects.equals((Object)this.recipientType, (Object)sendNotification.recipientType) && Objects.equals((Object)this.application, (Object)sendNotification.application) && Objects.equals(this.messageTemplateId, sendNotification.messageTemplateId) && Objects.equals(this.notifyViaEmail, sendNotification.notifyViaEmail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifiers, this.priority, this.type, this.recipientType, this.application, this.messageTemplateId, this.notifyViaEmail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendNotification {\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifiers)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    recipientType: ").append(this.toIndentedString((Object)this.recipientType)).append("\n");
        sb.append("    application: ").append(this.toIndentedString((Object)this.application)).append("\n");
        sb.append("    messageTemplateId: ").append(this.toIndentedString(this.messageTemplateId)).append("\n");
        sb.append("    notifyViaEmail: ").append(this.toIndentedString(this.notifyViaEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PriorityEnum {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ALERT("ALERT"),
        MESSAGE("MESSAGE"),
        FEATURE("FEATURE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecipientTypeEnum {
        USER("USER"),
        ACCOUNT("ACCOUNT");

        private String value;

        private RecipientTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecipientTypeEnum fromValue(String value) {
            for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ApplicationEnum {
        EXTRANET("EXTRANET"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        STUDIO("STUDIO"),
        PAYMENT("PAYMENT");

        private String value;

        private ApplicationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ApplicationEnum fromValue(String value) {
            for (ApplicationEnum b : ApplicationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

