package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;

import io.trippay.sdk.payment.model.Notification;
import io.trippay.sdk.payment.model.SendNotification;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-23T17:03:09.606308420+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class SendNotificationControllerApi {
    private ApiClient apiClient;

    public SendNotificationControllerApi() {
        this(new ApiClient());
    }

    @Autowired
    public SendNotificationControllerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * 
     * 
     * <p><b>201</b> - Created
     * @param sendNotification The sendNotification parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;Notification&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createNotificationRequestCreation(@jakarta.annotation.Nonnull SendNotification sendNotification, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = sendNotification;
        // verify the required parameter 'sendNotification' is set
        if (sendNotification == null) {
            throw new WebClientResponseException("Missing the required parameter 'sendNotification' when calling createNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return apiClient.invokeAPI("/api/administration/notification", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>201</b> - Created
     * @param sendNotification The sendNotification parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;Notification&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Notification> createNotification(@jakarta.annotation.Nonnull SendNotification sendNotification, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return createNotificationRequestCreation(sendNotification, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>201</b> - Created
     * @param sendNotification The sendNotification parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;Notification&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Notification>>> createNotificationWithHttpInfo(@jakarta.annotation.Nonnull SendNotification sendNotification, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Notification> localVarReturnType = new ParameterizedTypeReference<Notification>() {};
        return createNotificationRequestCreation(sendNotification, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>201</b> - Created
     * @param sendNotification The sendNotification parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createNotificationWithResponseSpec(@jakarta.annotation.Nonnull SendNotification sendNotification, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createNotificationRequestCreation(sendNotification, winkVersion);
    }
}
