/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Contact
 */
@JsonPropertyOrder({
  Contact.JSON_PROPERTY_FIRST_NAME,
  Contact.JSON_PROPERTY_LAST_NAME,
  Contact.JSON_PROPERTY_EMAIL,
  Contact.JSON_PROPERTY_SECONDARY_EMAIL,
  Contact.JSON_PROPERTY_PHONE_NUMBER,
  Contact.JSON_PROPERTY_FULL_NAME,
  Contact.JSON_PROPERTY_SUMMARY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-23T17:03:09.606308420+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class Contact {
  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  @jakarta.annotation.Nullable
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  @jakarta.annotation.Nullable
  private String lastName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  @jakarta.annotation.Nullable
  private String email;

  public static final String JSON_PROPERTY_SECONDARY_EMAIL = "secondaryEmail";
  @jakarta.annotation.Nullable
  private String secondaryEmail;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  @jakarta.annotation.Nullable
  private String phoneNumber;

  public static final String JSON_PROPERTY_FULL_NAME = "fullName";
  @jakarta.annotation.Nullable
  private String fullName;

  public static final String JSON_PROPERTY_SUMMARY = "summary";
  @jakarta.annotation.Nullable
  private String summary;

  public Contact() {
  }
  /**
   * Constructor with only readonly parameters
   */
  @JsonCreator
  public Contact(
    @JsonProperty(JSON_PROPERTY_FULL_NAME) String fullName, 
    @JsonProperty(JSON_PROPERTY_SUMMARY) String summary
  ) {
    this();
    this.fullName = fullName;
    this.summary = summary;
  }

  public Contact firstName(@jakarta.annotation.Nullable String firstName) {
    
    this.firstName = firstName;
    return this;
  }

  /**
   * Contact first name
   * @return firstName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstName(@jakarta.annotation.Nullable String firstName) {
    this.firstName = firstName;
  }

  public Contact lastName(@jakarta.annotation.Nullable String lastName) {
    
    this.lastName = lastName;
    return this;
  }

  /**
   * Contact last name
   * @return lastName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastName(@jakarta.annotation.Nullable String lastName) {
    this.lastName = lastName;
  }

  public Contact email(@jakarta.annotation.Nullable String email) {
    
    this.email = email;
    return this;
  }

  /**
   * Contact E-mail
   * @return email
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(@jakarta.annotation.Nullable String email) {
    this.email = email;
  }

  public Contact secondaryEmail(@jakarta.annotation.Nullable String secondaryEmail) {
    
    this.secondaryEmail = secondaryEmail;
    return this;
  }

  /**
   * Contact secondary Email
   * @return secondaryEmail
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECONDARY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecondaryEmail() {
    return secondaryEmail;
  }


  @JsonProperty(JSON_PROPERTY_SECONDARY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecondaryEmail(@jakarta.annotation.Nullable String secondaryEmail) {
    this.secondaryEmail = secondaryEmail;
  }

  public Contact phoneNumber(@jakarta.annotation.Nullable String phoneNumber) {
    
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Contact phone number
   * @return phoneNumber
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhoneNumber() {
    return phoneNumber;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(@jakarta.annotation.Nullable String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  /**
   * First and last name
   * @return fullName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullName() {
    return fullName;
  }



  /**
   * Summary
   * @return summary
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUMMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSummary() {
    return summary;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Contact contact = (Contact) o;
    return Objects.equals(this.firstName, contact.firstName) &&
        Objects.equals(this.lastName, contact.lastName) &&
        Objects.equals(this.email, contact.email) &&
        Objects.equals(this.secondaryEmail, contact.secondaryEmail) &&
        Objects.equals(this.phoneNumber, contact.phoneNumber) &&
        Objects.equals(this.fullName, contact.fullName) &&
        Objects.equals(this.summary, contact.summary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(firstName, lastName, email, secondaryEmail, phoneNumber, fullName, summary);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Contact {\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    secondaryEmail: ").append(toIndentedString(secondaryEmail)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

