/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Country
 */
@JsonPropertyOrder({
  CountryLightweight.JSON_PROPERTY_ISO,
  CountryLightweight.JSON_PROPERTY_ISO3,
  CountryLightweight.JSON_PROPERTY_ISO_NUMERIC,
  CountryLightweight.JSON_PROPERTY_FIPS,
  CountryLightweight.JSON_PROPERTY_NAME,
  CountryLightweight.JSON_PROPERTY_CAPITAL,
  CountryLightweight.JSON_PROPERTY_AREA,
  CountryLightweight.JSON_PROPERTY_POPULATION,
  CountryLightweight.JSON_PROPERTY_CONTINENT,
  CountryLightweight.JSON_PROPERTY_TOP_LEVEL_DOMAIN,
  CountryLightweight.JSON_PROPERTY_CURRENCY_CODE,
  CountryLightweight.JSON_PROPERTY_CURRENCY_NAME,
  CountryLightweight.JSON_PROPERTY_PHONE,
  CountryLightweight.JSON_PROPERTY_POSTAL_CODE_FORMAT,
  CountryLightweight.JSON_PROPERTY_POSTAL_CODE_REG_EX,
  CountryLightweight.JSON_PROPERTY_LANGUAGES,
  CountryLightweight.JSON_PROPERTY_GEO_NAME_ID,
  CountryLightweight.JSON_PROPERTY_NEIGHBORS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-23T17:03:09.606308420+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class CountryLightweight {
  public static final String JSON_PROPERTY_ISO = "iso";
  @jakarta.annotation.Nullable
  private String iso;

  public static final String JSON_PROPERTY_ISO3 = "iso3";
  @jakarta.annotation.Nullable
  private String iso3;

  public static final String JSON_PROPERTY_ISO_NUMERIC = "isoNumeric";
  @jakarta.annotation.Nullable
  private Integer isoNumeric;

  public static final String JSON_PROPERTY_FIPS = "fips";
  @jakarta.annotation.Nullable
  private String fips;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_CAPITAL = "capital";
  @jakarta.annotation.Nullable
  private String capital;

  public static final String JSON_PROPERTY_AREA = "area";
  @jakarta.annotation.Nullable
  private Float area;

  public static final String JSON_PROPERTY_POPULATION = "population";
  @jakarta.annotation.Nullable
  private Long population;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  @jakarta.annotation.Nullable
  private String continent;

  public static final String JSON_PROPERTY_TOP_LEVEL_DOMAIN = "topLevelDomain";
  @jakarta.annotation.Nullable
  private String topLevelDomain;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nullable
  private String currencyCode;

  public static final String JSON_PROPERTY_CURRENCY_NAME = "currencyName";
  @jakarta.annotation.Nullable
  private String currencyName;

  public static final String JSON_PROPERTY_PHONE = "phone";
  @jakarta.annotation.Nullable
  private String phone;

  public static final String JSON_PROPERTY_POSTAL_CODE_FORMAT = "postalCodeFormat";
  @jakarta.annotation.Nullable
  private String postalCodeFormat;

  public static final String JSON_PROPERTY_POSTAL_CODE_REG_EX = "postalCodeRegEx";
  @jakarta.annotation.Nullable
  private String postalCodeRegEx;

  public static final String JSON_PROPERTY_LANGUAGES = "languages";
  @jakarta.annotation.Nullable
  private List<Object> languages = new ArrayList<>();

  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  @jakarta.annotation.Nullable
  private String geoNameId;

  public static final String JSON_PROPERTY_NEIGHBORS = "neighbors";
  @jakarta.annotation.Nullable
  private List<Object> neighbors = new ArrayList<>();

  public CountryLightweight() {
  }

  public CountryLightweight iso(@jakarta.annotation.Nullable String iso) {
    
    this.iso = iso;
    return this;
  }

  /**
   * ISO code
   * @return iso
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso() {
    return iso;
  }


  @JsonProperty(JSON_PROPERTY_ISO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso(@jakarta.annotation.Nullable String iso) {
    this.iso = iso;
  }

  public CountryLightweight iso3(@jakarta.annotation.Nullable String iso3) {
    
    this.iso3 = iso3;
    return this;
  }

  /**
   * 3 character ISO code
   * @return iso3
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso3() {
    return iso3;
  }


  @JsonProperty(JSON_PROPERTY_ISO3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso3(@jakarta.annotation.Nullable String iso3) {
    this.iso3 = iso3;
  }

  public CountryLightweight isoNumeric(@jakarta.annotation.Nullable Integer isoNumeric) {
    
    this.isoNumeric = isoNumeric;
    return this;
  }

  /**
   * Numeric ISO code
   * @return isoNumeric
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISO_NUMERIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getIsoNumeric() {
    return isoNumeric;
  }


  @JsonProperty(JSON_PROPERTY_ISO_NUMERIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsoNumeric(@jakarta.annotation.Nullable Integer isoNumeric) {
    this.isoNumeric = isoNumeric;
  }

  public CountryLightweight fips(@jakarta.annotation.Nullable String fips) {
    
    this.fips = fips;
    return this;
  }

  /**
   * FIPS country code
   * @return fips
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFips() {
    return fips;
  }


  @JsonProperty(JSON_PROPERTY_FIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFips(@jakarta.annotation.Nullable String fips) {
    this.fips = fips;
  }

  public CountryLightweight name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Country name
   * @return name
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public CountryLightweight capital(@jakarta.annotation.Nullable String capital) {
    
    this.capital = capital;
    return this;
  }

  /**
   * Country capital
   * @return capital
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CAPITAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCapital() {
    return capital;
  }


  @JsonProperty(JSON_PROPERTY_CAPITAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapital(@jakarta.annotation.Nullable String capital) {
    this.capital = capital;
  }

  public CountryLightweight area(@jakarta.annotation.Nullable Float area) {
    
    this.area = area;
    return this;
  }

  /**
   * Area in square kilometers
   * @return area
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getArea() {
    return area;
  }


  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArea(@jakarta.annotation.Nullable Float area) {
    this.area = area;
  }

  public CountryLightweight population(@jakarta.annotation.Nullable Long population) {
    
    this.population = population;
    return this;
  }

  /**
   * Country population
   * @return population
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPopulation() {
    return population;
  }


  @JsonProperty(JSON_PROPERTY_POPULATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopulation(@jakarta.annotation.Nullable Long population) {
    this.population = population;
  }

  public CountryLightweight continent(@jakarta.annotation.Nullable String continent) {
    
    this.continent = continent;
    return this;
  }

  /**
   * Continent code
   * @return continent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(@jakarta.annotation.Nullable String continent) {
    this.continent = continent;
  }

  public CountryLightweight topLevelDomain(@jakarta.annotation.Nullable String topLevelDomain) {
    
    this.topLevelDomain = topLevelDomain;
    return this;
  }

  /**
   * Country TLD
   * @return topLevelDomain
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOP_LEVEL_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTopLevelDomain() {
    return topLevelDomain;
  }


  @JsonProperty(JSON_PROPERTY_TOP_LEVEL_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTopLevelDomain(@jakarta.annotation.Nullable String topLevelDomain) {
    this.topLevelDomain = topLevelDomain;
  }

  public CountryLightweight currencyCode(@jakarta.annotation.Nullable String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Currency code
   * @return currencyCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(@jakarta.annotation.Nullable String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public CountryLightweight currencyName(@jakarta.annotation.Nullable String currencyName) {
    
    this.currencyName = currencyName;
    return this;
  }

  /**
   * Currency name
   * @return currencyName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyName() {
    return currencyName;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyName(@jakarta.annotation.Nullable String currencyName) {
    this.currencyName = currencyName;
  }

  public CountryLightweight phone(@jakarta.annotation.Nullable String phone) {
    
    this.phone = phone;
    return this;
  }

  /**
   * Calling code
   * @return phone
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhone() {
    return phone;
  }


  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(@jakarta.annotation.Nullable String phone) {
    this.phone = phone;
  }

  public CountryLightweight postalCodeFormat(@jakarta.annotation.Nullable String postalCodeFormat) {
    
    this.postalCodeFormat = postalCodeFormat;
    return this;
  }

  /**
   * Postal code format
   * @return postalCodeFormat
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCodeFormat() {
    return postalCodeFormat;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCodeFormat(@jakarta.annotation.Nullable String postalCodeFormat) {
    this.postalCodeFormat = postalCodeFormat;
  }

  public CountryLightweight postalCodeRegEx(@jakarta.annotation.Nullable String postalCodeRegEx) {
    
    this.postalCodeRegEx = postalCodeRegEx;
    return this;
  }

  /**
   * Postal code regular expression
   * @return postalCodeRegEx
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE_REG_EX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCodeRegEx() {
    return postalCodeRegEx;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE_REG_EX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCodeRegEx(@jakarta.annotation.Nullable String postalCodeRegEx) {
    this.postalCodeRegEx = postalCodeRegEx;
  }

  public CountryLightweight languages(@jakarta.annotation.Nullable List<Object> languages) {
    
    this.languages = languages;
    return this;
  }

  public CountryLightweight addLanguagesItem(Object languagesItem) {
    if (this.languages == null) {
      this.languages = new ArrayList<>();
    }
    this.languages.add(languagesItem);
    return this;
  }

  /**
   * Get languages
   * @return languages
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getLanguages() {
    return languages;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguages(@jakarta.annotation.Nullable List<Object> languages) {
    this.languages = languages;
  }

  public CountryLightweight geoNameId(@jakarta.annotation.Nullable String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

  /**
   * Country GeoNames identifier
   * @return geoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(@jakarta.annotation.Nullable String geoNameId) {
    this.geoNameId = geoNameId;
  }

  public CountryLightweight neighbors(@jakarta.annotation.Nullable List<Object> neighbors) {
    
    this.neighbors = neighbors;
    return this;
  }

  public CountryLightweight addNeighborsItem(Object neighborsItem) {
    if (this.neighbors == null) {
      this.neighbors = new ArrayList<>();
    }
    this.neighbors.add(neighborsItem);
    return this;
  }

  /**
   * Get neighbors
   * @return neighbors
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NEIGHBORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getNeighbors() {
    return neighbors;
  }


  @JsonProperty(JSON_PROPERTY_NEIGHBORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNeighbors(@jakarta.annotation.Nullable List<Object> neighbors) {
    this.neighbors = neighbors;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CountryLightweight countryLightweight = (CountryLightweight) o;
    return Objects.equals(this.iso, countryLightweight.iso) &&
        Objects.equals(this.iso3, countryLightweight.iso3) &&
        Objects.equals(this.isoNumeric, countryLightweight.isoNumeric) &&
        Objects.equals(this.fips, countryLightweight.fips) &&
        Objects.equals(this.name, countryLightweight.name) &&
        Objects.equals(this.capital, countryLightweight.capital) &&
        Objects.equals(this.area, countryLightweight.area) &&
        Objects.equals(this.population, countryLightweight.population) &&
        Objects.equals(this.continent, countryLightweight.continent) &&
        Objects.equals(this.topLevelDomain, countryLightweight.topLevelDomain) &&
        Objects.equals(this.currencyCode, countryLightweight.currencyCode) &&
        Objects.equals(this.currencyName, countryLightweight.currencyName) &&
        Objects.equals(this.phone, countryLightweight.phone) &&
        Objects.equals(this.postalCodeFormat, countryLightweight.postalCodeFormat) &&
        Objects.equals(this.postalCodeRegEx, countryLightweight.postalCodeRegEx) &&
        Objects.equals(this.languages, countryLightweight.languages) &&
        Objects.equals(this.geoNameId, countryLightweight.geoNameId) &&
        Objects.equals(this.neighbors, countryLightweight.neighbors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(iso, iso3, isoNumeric, fips, name, capital, area, population, continent, topLevelDomain, currencyCode, currencyName, phone, postalCodeFormat, postalCodeRegEx, languages, geoNameId, neighbors);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CountryLightweight {\n");
    sb.append("    iso: ").append(toIndentedString(iso)).append("\n");
    sb.append("    iso3: ").append(toIndentedString(iso3)).append("\n");
    sb.append("    isoNumeric: ").append(toIndentedString(isoNumeric)).append("\n");
    sb.append("    fips: ").append(toIndentedString(fips)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    capital: ").append(toIndentedString(capital)).append("\n");
    sb.append("    area: ").append(toIndentedString(area)).append("\n");
    sb.append("    population: ").append(toIndentedString(population)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    topLevelDomain: ").append(toIndentedString(topLevelDomain)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    currencyName: ").append(toIndentedString(currencyName)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    postalCodeFormat: ").append(toIndentedString(postalCodeFormat)).append("\n");
    sb.append("    postalCodeRegEx: ").append(toIndentedString(postalCodeRegEx)).append("\n");
    sb.append("    languages: ").append(toIndentedString(languages)).append("\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    neighbors: ").append(toIndentedString(neighbors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

