/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.CountryLightweight;
import io.trippay.sdk.payment.model.GeoJsonPoint;
import io.trippay.sdk.payment.model.SubCountryLightweight;
import io.trippay.sdk.payment.model.SubSubCountryLightweight;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNames have been created at [https://geonames.org](https://geonames.org) and contain geographical destinations we use as geoname data to associate travel inventory with a location.
 */
@JsonPropertyOrder({
  GeoNameLightweight.JSON_PROPERTY_GEO_NAME_ID,
  GeoNameLightweight.JSON_PROPERTY_TYPE,
  GeoNameLightweight.JSON_PROPERTY_NAME,
  GeoNameLightweight.JSON_PROPERTY_URL_NAME,
  GeoNameLightweight.JSON_PROPERTY_ASCII_NAME,
  GeoNameLightweight.JSON_PROPERTY_ALTERNATE_NAMES,
  GeoNameLightweight.JSON_PROPERTY_LOCATION,
  GeoNameLightweight.JSON_PROPERTY_FEATURE_CLASS,
  GeoNameLightweight.JSON_PROPERTY_FEATURE_CODE,
  GeoNameLightweight.JSON_PROPERTY_COUNTRY_CODE,
  GeoNameLightweight.JSON_PROPERTY_ALTERNATE_COUNTRY_CODES,
  GeoNameLightweight.JSON_PROPERTY_ADMIN1_CODE,
  GeoNameLightweight.JSON_PROPERTY_ADMIN2_CODE,
  GeoNameLightweight.JSON_PROPERTY_ADMIN3_CODE,
  GeoNameLightweight.JSON_PROPERTY_ADMIN4_CODE,
  GeoNameLightweight.JSON_PROPERTY_POPULATION,
  GeoNameLightweight.JSON_PROPERTY_ELEVATION,
  GeoNameLightweight.JSON_PROPERTY_DIGITAL_ELEVATION_MODEL,
  GeoNameLightweight.JSON_PROPERTY_TIMEZONE,
  GeoNameLightweight.JSON_PROPERTY_MODIFICATION_DATE,
  GeoNameLightweight.JSON_PROPERTY_RADIUS_IN_METERS,
  GeoNameLightweight.JSON_PROPERTY_COUNTRY,
  GeoNameLightweight.JSON_PROPERTY_SUB_COUNTRY,
  GeoNameLightweight.JSON_PROPERTY_SUB_SUB_COUNTRY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-23T17:03:09.606308420+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class GeoNameLightweight {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  @jakarta.annotation.Nullable
  private String geoNameId;

  /**
   * GeoNameLightweight type
   */
  public enum TypeEnum {
    CITY(String.valueOf("CITY")),
    
    ISLAND(String.valueOf("ISLAND")),
    
    OTHER(String.valueOf("OTHER"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nullable
  private TypeEnum type;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  @jakarta.annotation.Nullable
  private String urlName;

  public static final String JSON_PROPERTY_ASCII_NAME = "asciiName";
  @jakarta.annotation.Nullable
  private String asciiName;

  public static final String JSON_PROPERTY_ALTERNATE_NAMES = "alternateNames";
  @jakarta.annotation.Nullable
  private List<Object> alternateNames = new ArrayList<>();

  public static final String JSON_PROPERTY_LOCATION = "location";
  @jakarta.annotation.Nullable
  private GeoJsonPoint location;

  public static final String JSON_PROPERTY_FEATURE_CLASS = "featureClass";
  @jakarta.annotation.Nullable
  private String featureClass;

  public static final String JSON_PROPERTY_FEATURE_CODE = "featureCode";
  @jakarta.annotation.Nullable
  private String featureCode;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  @jakarta.annotation.Nullable
  private String countryCode;

  public static final String JSON_PROPERTY_ALTERNATE_COUNTRY_CODES = "alternateCountryCodes";
  @jakarta.annotation.Nullable
  private List<String> alternateCountryCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_ADMIN1_CODE = "admin1Code";
  @jakarta.annotation.Nullable
  private String admin1Code;

  public static final String JSON_PROPERTY_ADMIN2_CODE = "admin2Code";
  @jakarta.annotation.Nullable
  private String admin2Code;

  public static final String JSON_PROPERTY_ADMIN3_CODE = "admin3Code";
  @jakarta.annotation.Nullable
  private String admin3Code;

  public static final String JSON_PROPERTY_ADMIN4_CODE = "admin4Code";
  @jakarta.annotation.Nullable
  private String admin4Code;

  public static final String JSON_PROPERTY_POPULATION = "population";
  @jakarta.annotation.Nullable
  private Long population;

  public static final String JSON_PROPERTY_ELEVATION = "elevation";
  @jakarta.annotation.Nullable
  private Integer elevation;

  public static final String JSON_PROPERTY_DIGITAL_ELEVATION_MODEL = "digitalElevationModel";
  @jakarta.annotation.Nullable
  private String digitalElevationModel;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  @jakarta.annotation.Nullable
  private String timezone;

  public static final String JSON_PROPERTY_MODIFICATION_DATE = "modificationDate";
  @jakarta.annotation.Nullable
  private LocalDate modificationDate;

  public static final String JSON_PROPERTY_RADIUS_IN_METERS = "radiusInMeters";
  @jakarta.annotation.Nullable
  private Long radiusInMeters;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nullable
  private CountryLightweight country;

  public static final String JSON_PROPERTY_SUB_COUNTRY = "subCountry";
  @jakarta.annotation.Nullable
  private SubCountryLightweight subCountry;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY = "subSubCountry";
  @jakarta.annotation.Nullable
  private SubSubCountryLightweight subSubCountry;

  public GeoNameLightweight() {
  }

  public GeoNameLightweight geoNameId(@jakarta.annotation.Nullable String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

  /**
   * GeoName identifier
   * @return geoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(@jakarta.annotation.Nullable String geoNameId) {
    this.geoNameId = geoNameId;
  }

  public GeoNameLightweight type(@jakarta.annotation.Nullable TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * GeoNameLightweight type
   * @return type
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@jakarta.annotation.Nullable TypeEnum type) {
    this.type = type;
  }

  public GeoNameLightweight name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of city
   * @return name
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public GeoNameLightweight urlName(@jakarta.annotation.Nullable String urlName) {
    
    this.urlName = urlName;
    return this;
  }

  /**
   * Url name
   * @return urlName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(@jakarta.annotation.Nullable String urlName) {
    this.urlName = urlName;
  }

  public GeoNameLightweight asciiName(@jakarta.annotation.Nullable String asciiName) {
    
    this.asciiName = asciiName;
    return this;
  }

  /**
   * Ascii name of city
   * @return asciiName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAsciiName() {
    return asciiName;
  }


  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsciiName(@jakarta.annotation.Nullable String asciiName) {
    this.asciiName = asciiName;
  }

  public GeoNameLightweight alternateNames(@jakarta.annotation.Nullable List<Object> alternateNames) {
    
    this.alternateNames = alternateNames;
    return this;
  }

  public GeoNameLightweight addAlternateNamesItem(Object alternateNamesItem) {
    if (this.alternateNames == null) {
      this.alternateNames = new ArrayList<>();
    }
    this.alternateNames.add(alternateNamesItem);
    return this;
  }

  /**
   * Get alternateNames
   * @return alternateNames
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALTERNATE_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getAlternateNames() {
    return alternateNames;
  }


  @JsonProperty(JSON_PROPERTY_ALTERNATE_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlternateNames(@jakarta.annotation.Nullable List<Object> alternateNames) {
    this.alternateNames = alternateNames;
  }

  public GeoNameLightweight location(@jakarta.annotation.Nullable GeoJsonPoint location) {
    
    this.location = location;
    return this;
  }

  /**
   * Coordinate points of the city
   * @return location
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPoint getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(@jakarta.annotation.Nullable GeoJsonPoint location) {
    this.location = location;
  }

  public GeoNameLightweight featureClass(@jakarta.annotation.Nullable String featureClass) {
    
    this.featureClass = featureClass;
    return this;
  }

  /**
   * Get featureClass
   * @return featureClass
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEATURE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureClass() {
    return featureClass;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureClass(@jakarta.annotation.Nullable String featureClass) {
    this.featureClass = featureClass;
  }

  public GeoNameLightweight featureCode(@jakarta.annotation.Nullable String featureCode) {
    
    this.featureCode = featureCode;
    return this;
  }

  /**
   * Get featureCode
   * @return featureCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureCode() {
    return featureCode;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureCode(@jakarta.annotation.Nullable String featureCode) {
    this.featureCode = featureCode;
  }

  public GeoNameLightweight countryCode(@jakarta.annotation.Nullable String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Get countryCode
   * @return countryCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(@jakarta.annotation.Nullable String countryCode) {
    this.countryCode = countryCode;
  }

  public GeoNameLightweight alternateCountryCodes(@jakarta.annotation.Nullable List<String> alternateCountryCodes) {
    
    this.alternateCountryCodes = alternateCountryCodes;
    return this;
  }

  public GeoNameLightweight addAlternateCountryCodesItem(String alternateCountryCodesItem) {
    if (this.alternateCountryCodes == null) {
      this.alternateCountryCodes = new ArrayList<>();
    }
    this.alternateCountryCodes.add(alternateCountryCodesItem);
    return this;
  }

  /**
   * Get alternateCountryCodes
   * @return alternateCountryCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALTERNATE_COUNTRY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAlternateCountryCodes() {
    return alternateCountryCodes;
  }


  @JsonProperty(JSON_PROPERTY_ALTERNATE_COUNTRY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlternateCountryCodes(@jakarta.annotation.Nullable List<String> alternateCountryCodes) {
    this.alternateCountryCodes = alternateCountryCodes;
  }

  public GeoNameLightweight admin1Code(@jakarta.annotation.Nullable String admin1Code) {
    
    this.admin1Code = admin1Code;
    return this;
  }

  /**
   * Get admin1Code
   * @return admin1Code
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin1Code() {
    return admin1Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin1Code(@jakarta.annotation.Nullable String admin1Code) {
    this.admin1Code = admin1Code;
  }

  public GeoNameLightweight admin2Code(@jakarta.annotation.Nullable String admin2Code) {
    
    this.admin2Code = admin2Code;
    return this;
  }

  /**
   * Get admin2Code
   * @return admin2Code
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin2Code() {
    return admin2Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin2Code(@jakarta.annotation.Nullable String admin2Code) {
    this.admin2Code = admin2Code;
  }

  public GeoNameLightweight admin3Code(@jakarta.annotation.Nullable String admin3Code) {
    
    this.admin3Code = admin3Code;
    return this;
  }

  /**
   * Get admin3Code
   * @return admin3Code
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN3_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin3Code() {
    return admin3Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN3_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin3Code(@jakarta.annotation.Nullable String admin3Code) {
    this.admin3Code = admin3Code;
  }

  public GeoNameLightweight admin4Code(@jakarta.annotation.Nullable String admin4Code) {
    
    this.admin4Code = admin4Code;
    return this;
  }

  /**
   * Get admin4Code
   * @return admin4Code
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN4_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin4Code() {
    return admin4Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN4_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin4Code(@jakarta.annotation.Nullable String admin4Code) {
    this.admin4Code = admin4Code;
  }

  public GeoNameLightweight population(@jakarta.annotation.Nullable Long population) {
    
    this.population = population;
    return this;
  }

  /**
   * Population of the city
   * @return population
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPopulation() {
    return population;
  }


  @JsonProperty(JSON_PROPERTY_POPULATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopulation(@jakarta.annotation.Nullable Long population) {
    this.population = population;
  }

  public GeoNameLightweight elevation(@jakarta.annotation.Nullable Integer elevation) {
    
    this.elevation = elevation;
    return this;
  }

  /**
   * City elevation
   * @return elevation
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ELEVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getElevation() {
    return elevation;
  }


  @JsonProperty(JSON_PROPERTY_ELEVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElevation(@jakarta.annotation.Nullable Integer elevation) {
    this.elevation = elevation;
  }

  public GeoNameLightweight digitalElevationModel(@jakarta.annotation.Nullable String digitalElevationModel) {
    
    this.digitalElevationModel = digitalElevationModel;
    return this;
  }

  /**
   * Get digitalElevationModel
   * @return digitalElevationModel
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DIGITAL_ELEVATION_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDigitalElevationModel() {
    return digitalElevationModel;
  }


  @JsonProperty(JSON_PROPERTY_DIGITAL_ELEVATION_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDigitalElevationModel(@jakarta.annotation.Nullable String digitalElevationModel) {
    this.digitalElevationModel = digitalElevationModel;
  }

  public GeoNameLightweight timezone(@jakarta.annotation.Nullable String timezone) {
    
    this.timezone = timezone;
    return this;
  }

  /**
   * Timezone
   * @return timezone
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(@jakarta.annotation.Nullable String timezone) {
    this.timezone = timezone;
  }

  public GeoNameLightweight modificationDate(@jakarta.annotation.Nullable LocalDate modificationDate) {
    
    this.modificationDate = modificationDate;
    return this;
  }

  /**
   * Get modificationDate
   * @return modificationDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getModificationDate() {
    return modificationDate;
  }


  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationDate(@jakarta.annotation.Nullable LocalDate modificationDate) {
    this.modificationDate = modificationDate;
  }

  public GeoNameLightweight radiusInMeters(@jakarta.annotation.Nullable Long radiusInMeters) {
    
    this.radiusInMeters = radiusInMeters;
    return this;
  }

  /**
   * Get radiusInMeters
   * @return radiusInMeters
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RADIUS_IN_METERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRadiusInMeters() {
    return radiusInMeters;
  }


  @JsonProperty(JSON_PROPERTY_RADIUS_IN_METERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRadiusInMeters(@jakarta.annotation.Nullable Long radiusInMeters) {
    this.radiusInMeters = radiusInMeters;
  }

  public GeoNameLightweight country(@jakarta.annotation.Nullable CountryLightweight country) {
    
    this.country = country;
    return this;
  }

  /**
   * Country
   * @return country
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CountryLightweight getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(@jakarta.annotation.Nullable CountryLightweight country) {
    this.country = country;
  }

  public GeoNameLightweight subCountry(@jakarta.annotation.Nullable SubCountryLightweight subCountry) {
    
    this.subCountry = subCountry;
    return this;
  }

  /**
   * Country sub division
   * @return subCountry
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubCountryLightweight getSubCountry() {
    return subCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountry(@jakarta.annotation.Nullable SubCountryLightweight subCountry) {
    this.subCountry = subCountry;
  }

  public GeoNameLightweight subSubCountry(@jakarta.annotation.Nullable SubSubCountryLightweight subSubCountry) {
    
    this.subSubCountry = subSubCountry;
    return this;
  }

  /**
   * Country sub sub division
   * @return subSubCountry
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubSubCountryLightweight getSubSubCountry() {
    return subSubCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountry(@jakarta.annotation.Nullable SubSubCountryLightweight subSubCountry) {
    this.subSubCountry = subSubCountry;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoNameLightweight geoNameLightweight = (GeoNameLightweight) o;
    return Objects.equals(this.geoNameId, geoNameLightweight.geoNameId) &&
        Objects.equals(this.type, geoNameLightweight.type) &&
        Objects.equals(this.name, geoNameLightweight.name) &&
        Objects.equals(this.urlName, geoNameLightweight.urlName) &&
        Objects.equals(this.asciiName, geoNameLightweight.asciiName) &&
        Objects.equals(this.alternateNames, geoNameLightweight.alternateNames) &&
        Objects.equals(this.location, geoNameLightweight.location) &&
        Objects.equals(this.featureClass, geoNameLightweight.featureClass) &&
        Objects.equals(this.featureCode, geoNameLightweight.featureCode) &&
        Objects.equals(this.countryCode, geoNameLightweight.countryCode) &&
        Objects.equals(this.alternateCountryCodes, geoNameLightweight.alternateCountryCodes) &&
        Objects.equals(this.admin1Code, geoNameLightweight.admin1Code) &&
        Objects.equals(this.admin2Code, geoNameLightweight.admin2Code) &&
        Objects.equals(this.admin3Code, geoNameLightweight.admin3Code) &&
        Objects.equals(this.admin4Code, geoNameLightweight.admin4Code) &&
        Objects.equals(this.population, geoNameLightweight.population) &&
        Objects.equals(this.elevation, geoNameLightweight.elevation) &&
        Objects.equals(this.digitalElevationModel, geoNameLightweight.digitalElevationModel) &&
        Objects.equals(this.timezone, geoNameLightweight.timezone) &&
        Objects.equals(this.modificationDate, geoNameLightweight.modificationDate) &&
        Objects.equals(this.radiusInMeters, geoNameLightweight.radiusInMeters) &&
        Objects.equals(this.country, geoNameLightweight.country) &&
        Objects.equals(this.subCountry, geoNameLightweight.subCountry) &&
        Objects.equals(this.subSubCountry, geoNameLightweight.subSubCountry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, type, name, urlName, asciiName, alternateNames, location, featureClass, featureCode, countryCode, alternateCountryCodes, admin1Code, admin2Code, admin3Code, admin4Code, population, elevation, digitalElevationModel, timezone, modificationDate, radiusInMeters, country, subCountry, subSubCountry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoNameLightweight {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    asciiName: ").append(toIndentedString(asciiName)).append("\n");
    sb.append("    alternateNames: ").append(toIndentedString(alternateNames)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    featureClass: ").append(toIndentedString(featureClass)).append("\n");
    sb.append("    featureCode: ").append(toIndentedString(featureCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    alternateCountryCodes: ").append(toIndentedString(alternateCountryCodes)).append("\n");
    sb.append("    admin1Code: ").append(toIndentedString(admin1Code)).append("\n");
    sb.append("    admin2Code: ").append(toIndentedString(admin2Code)).append("\n");
    sb.append("    admin3Code: ").append(toIndentedString(admin3Code)).append("\n");
    sb.append("    admin4Code: ").append(toIndentedString(admin4Code)).append("\n");
    sb.append("    population: ").append(toIndentedString(population)).append("\n");
    sb.append("    elevation: ").append(toIndentedString(elevation)).append("\n");
    sb.append("    digitalElevationModel: ").append(toIndentedString(digitalElevationModel)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    modificationDate: ").append(toIndentedString(modificationDate)).append("\n");
    sb.append("    radiusInMeters: ").append(toIndentedString(radiusInMeters)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    subCountry: ").append(toIndentedString(subCountry)).append("\n");
    sb.append("    subSubCountry: ").append(toIndentedString(subSubCountry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

