/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trippay.sdk.payment.model.AcquirerCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Payment method with the details describing how to make a payment happen
 */
@JsonPropertyOrder({
  Integrator.JSON_PROPERTY_IDENTIFIER,
  Integrator.JSON_PROPERTY_NAME,
  Integrator.JSON_PROPERTY_PRIORITY,
  Integrator.JSON_PROPERTY_VENDOR,
  Integrator.JSON_PROPERTY_TYPE,
  Integrator.JSON_PROPERTY_CURRENCY_CODE,
  Integrator.JSON_PROPERTY_CREDENTIALS,
  Integrator.JSON_PROPERTY_WEBHOOK_SECRET,
  Integrator.JSON_PROPERTY_PUBLIC_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-23T17:03:09.606308420+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class Integrator {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private String identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  @jakarta.annotation.Nonnull
  private Integer priority;

  /**
   * Name of acquiring vendor
   */
  public enum VendorEnum {
    STRIPE(String.valueOf("STRIPE")),
    
    AGENT(String.valueOf("AGENT")),
    
    NMI(String.valueOf("NMI")),
    
    WISE(String.valueOf("WISE")),
    
    TEST(String.valueOf("TEST"));

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  @jakarta.annotation.Nonnull
  private VendorEnum vendor;

  /**
   * Technology taking the charge
   */
  public enum TypeEnum {
    CREDIT_CARD(String.valueOf("CREDIT_CARD")),
    
    BANK_TRANSFER(String.valueOf("BANK_TRANSFER")),
    
    PAY_PAL(String.valueOf("PAY_PAL")),
    
    CRYPTO(String.valueOf("CRYPTO")),
    
    AGENT(String.valueOf("AGENT")),
    
    CASH(String.valueOf("CASH"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nonnull
  private String currencyCode;

  public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
  @jakarta.annotation.Nonnull
  private List<@Valid AcquirerCredentials> credentials = new ArrayList<>();

  public static final String JSON_PROPERTY_WEBHOOK_SECRET = "webhookSecret";
  @jakarta.annotation.Nullable
  private String webhookSecret;

  public static final String JSON_PROPERTY_PUBLIC_TOKEN = "publicToken";
  @jakarta.annotation.Nullable
  private String publicToken;

  public Integrator() {
  }

  public Integrator identifier(@jakarta.annotation.Nonnull String identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique identifier.
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull String identifier) {
    this.identifier = identifier;
  }

  public Integrator name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Integrator.
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public Integrator priority(@jakarta.annotation.Nonnull Integer priority) {
    
    this.priority = priority;
    return this;
  }

  /**
   * Determines how vendors are displayed in a list
   * @return priority
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPriority(@jakarta.annotation.Nonnull Integer priority) {
    this.priority = priority;
  }

  public Integrator vendor(@jakarta.annotation.Nonnull VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

  /**
   * Name of acquiring vendor
   * @return vendor
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(@jakarta.annotation.Nonnull VendorEnum vendor) {
    this.vendor = vendor;
  }

  public Integrator type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Technology taking the charge
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public Integrator currencyCode(@jakarta.annotation.Nonnull String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Currency in coverage region.
   * @return currencyCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(@jakarta.annotation.Nonnull String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Integrator credentials(@jakarta.annotation.Nonnull List<@Valid AcquirerCredentials> credentials) {
    
    this.credentials = credentials;
    return this;
  }

  public Integrator addCredentialsItem(AcquirerCredentials credentialsItem) {
    if (this.credentials == null) {
      this.credentials = new ArrayList<>();
    }
    this.credentials.add(credentialsItem);
    return this;
  }

  /**
   * Get credentials
   * @return credentials
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid AcquirerCredentials> getCredentials() {
    return credentials;
  }


  @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCredentials(@jakarta.annotation.Nonnull List<@Valid AcquirerCredentials> credentials) {
    this.credentials = credentials;
  }

  public Integrator webhookSecret(@jakarta.annotation.Nullable String webhookSecret) {
    
    this.webhookSecret = webhookSecret;
    return this;
  }

  /**
   * Get webhookSecret
   * @return webhookSecret
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEBHOOK_SECRET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWebhookSecret() {
    return webhookSecret;
  }


  @JsonProperty(JSON_PROPERTY_WEBHOOK_SECRET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebhookSecret(@jakarta.annotation.Nullable String webhookSecret) {
    this.webhookSecret = webhookSecret;
  }

  public Integrator publicToken(@jakarta.annotation.Nullable String publicToken) {
    
    this.publicToken = publicToken;
    return this;
  }

  /**
   * Get publicToken
   * @return publicToken
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PUBLIC_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPublicToken() {
    return publicToken;
  }


  @JsonProperty(JSON_PROPERTY_PUBLIC_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublicToken(@jakarta.annotation.Nullable String publicToken) {
    this.publicToken = publicToken;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Integrator integrator = (Integrator) o;
    return Objects.equals(this.identifier, integrator.identifier) &&
        Objects.equals(this.name, integrator.name) &&
        Objects.equals(this.priority, integrator.priority) &&
        Objects.equals(this.vendor, integrator.vendor) &&
        Objects.equals(this.type, integrator.type) &&
        Objects.equals(this.currencyCode, integrator.currencyCode) &&
        Objects.equals(this.credentials, integrator.credentials) &&
        Objects.equals(this.webhookSecret, integrator.webhookSecret) &&
        Objects.equals(this.publicToken, integrator.publicToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, priority, vendor, type, currencyCode, credentials, webhookSecret, publicToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Integrator {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
    sb.append("    webhookSecret: ").append(toIndentedString(webhookSecret)).append("\n");
    sb.append("    publicToken: ").append(toIndentedString(publicToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

