/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Personal
 */
@JsonPropertyOrder({
  Personal.JSON_PROPERTY_GENDER,
  Personal.JSON_PROPERTY_BIRTH_DATE,
  Personal.JSON_PROPERTY_MARITAL_STATUS,
  Personal.JSON_PROPERTY_CHILD_QUANTITY,
  Personal.JSON_PROPERTY_CITIZENSHIP,
  Personal.JSON_PROPERTY_ADDRESS1,
  Personal.JSON_PROPERTY_ADDRESS2,
  Personal.JSON_PROPERTY_CITY,
  Personal.JSON_PROPERTY_STATE,
  Personal.JSON_PROPERTY_POSTAL_CODE,
  Personal.JSON_PROPERTY_COUNTRY,
  Personal.JSON_PROPERTY_PREFERRED_CURRENCY,
  Personal.JSON_PROPERTY_LANGUAGE,
  Personal.JSON_PROPERTY_CONTACT_PERSON,
  Personal.JSON_PROPERTY_PHYS_CHALL_NAME,
  Personal.JSON_PROPERTY_PET_INFO
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-23T17:03:09.606308420+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class Personal {
  /**
   * Identifier the gender of the customer.
   */
  public enum GenderEnum {
    MALE(String.valueOf("MALE")),
    
    FEMALE(String.valueOf("FEMALE")),
    
    OTHER(String.valueOf("OTHER"));

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  @jakarta.annotation.Nullable
  private GenderEnum gender;

  public static final String JSON_PROPERTY_BIRTH_DATE = "birthDate";
  @jakarta.annotation.Nullable
  private LocalDate birthDate;

  /**
   * Marital status of the traveler.
   */
  public enum MaritalStatusEnum {
    ANNULLED(String.valueOf("ANNULLED")),
    
    COHABITATING(String.valueOf("COHABITATING")),
    
    DIVORCED(String.valueOf("DIVORCED")),
    
    ENGAGED(String.valueOf("ENGAGED")),
    
    MARRIED(String.valueOf("MARRIED")),
    
    SEPARATED(String.valueOf("SEPARATED")),
    
    SINGLE(String.valueOf("SINGLE")),
    
    WIDOWED(String.valueOf("WIDOWED")),
    
    UNKNOWN(String.valueOf("UNKNOWN"));

    private String value;

    MaritalStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MaritalStatusEnum fromValue(String value) {
      for (MaritalStatusEnum b : MaritalStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MARITAL_STATUS = "maritalStatus";
  @jakarta.annotation.Nullable
  private MaritalStatusEnum maritalStatus;

  public static final String JSON_PROPERTY_CHILD_QUANTITY = "childQuantity";
  @jakarta.annotation.Nullable
  private Integer childQuantity;

  public static final String JSON_PROPERTY_CITIZENSHIP = "citizenship";
  @jakarta.annotation.Nullable
  private String citizenship;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  @jakarta.annotation.Nullable
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  @jakarta.annotation.Nullable
  private String address2;

  public static final String JSON_PROPERTY_CITY = "city";
  @jakarta.annotation.Nullable
  private String city;

  public static final String JSON_PROPERTY_STATE = "state";
  @jakarta.annotation.Nullable
  private String state;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  @jakarta.annotation.Nullable
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nullable
  private String country;

  public static final String JSON_PROPERTY_PREFERRED_CURRENCY = "preferredCurrency";
  @jakarta.annotation.Nullable
  private String preferredCurrency;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @jakarta.annotation.Nullable
  private String language;

  public static final String JSON_PROPERTY_CONTACT_PERSON = "contactPerson";
  @jakarta.annotation.Nullable
  private List<Object> contactPerson = new ArrayList<>();

  public static final String JSON_PROPERTY_PHYS_CHALL_NAME = "physChallName";
  @jakarta.annotation.Nullable
  private List<Object> physChallName = new ArrayList<>();

  public static final String JSON_PROPERTY_PET_INFO = "petInfo";
  @jakarta.annotation.Nullable
  private List<Object> petInfo = new ArrayList<>();

  public Personal() {
  }

  public Personal gender(@jakarta.annotation.Nullable GenderEnum gender) {
    
    this.gender = gender;
    return this;
  }

  /**
   * Identifier the gender of the customer.
   * @return gender
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenderEnum getGender() {
    return gender;
  }


  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGender(@jakarta.annotation.Nullable GenderEnum gender) {
    this.gender = gender;
  }

  public Personal birthDate(@jakarta.annotation.Nullable LocalDate birthDate) {
    
    this.birthDate = birthDate;
    return this;
  }

  /**
   * Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
   * @return birthDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getBirthDate() {
    return birthDate;
  }


  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthDate(@jakarta.annotation.Nullable LocalDate birthDate) {
    this.birthDate = birthDate;
  }

  public Personal maritalStatus(@jakarta.annotation.Nullable MaritalStatusEnum maritalStatus) {
    
    this.maritalStatus = maritalStatus;
    return this;
  }

  /**
   * Marital status of the traveler.
   * @return maritalStatus
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MaritalStatusEnum getMaritalStatus() {
    return maritalStatus;
  }


  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaritalStatus(@jakarta.annotation.Nullable MaritalStatusEnum maritalStatus) {
    this.maritalStatus = maritalStatus;
  }

  public Personal childQuantity(@jakarta.annotation.Nullable Integer childQuantity) {
    
    this.childQuantity = childQuantity;
    return this;
  }

  /**
   * The number of children of the customer.
   * @return childQuantity
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildQuantity() {
    return childQuantity;
  }


  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildQuantity(@jakarta.annotation.Nullable Integer childQuantity) {
    this.childQuantity = childQuantity;
  }

  public Personal citizenship(@jakarta.annotation.Nullable String citizenship) {
    
    this.citizenship = citizenship;
    return this;
  }

  /**
   * Name of the (self-professed) country that is clamided for citizenship.
   * @return citizenship
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCitizenship() {
    return citizenship;
  }


  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCitizenship(@jakarta.annotation.Nullable String citizenship) {
    this.citizenship = citizenship;
  }

  public Personal address1(@jakarta.annotation.Nullable String address1) {
    
    this.address1 = address1;
    return this;
  }

  /**
   * Address line 1
   * @return address1
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress1(@jakarta.annotation.Nullable String address1) {
    this.address1 = address1;
  }

  public Personal address2(@jakarta.annotation.Nullable String address2) {
    
    this.address2 = address2;
    return this;
  }

  /**
   * Address line 2
   * @return address2
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(@jakarta.annotation.Nullable String address2) {
    this.address2 = address2;
  }

  public Personal city(@jakarta.annotation.Nullable String city) {
    
    this.city = city;
    return this;
  }

  /**
   * City
   * @return city
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(@jakarta.annotation.Nullable String city) {
    this.city = city;
  }

  public Personal state(@jakarta.annotation.Nullable String state) {
    
    this.state = state;
    return this;
  }

  /**
   * State
   * @return state
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@jakarta.annotation.Nullable String state) {
    this.state = state;
  }

  public Personal postalCode(@jakarta.annotation.Nullable String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

  /**
   * Postal code
   * @return postalCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(@jakarta.annotation.Nullable String postalCode) {
    this.postalCode = postalCode;
  }

  public Personal country(@jakarta.annotation.Nullable String country) {
    
    this.country = country;
    return this;
  }

  /**
   * Country
   * @return country
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(@jakarta.annotation.Nullable String country) {
    this.country = country;
  }

  public Personal preferredCurrency(@jakarta.annotation.Nullable String preferredCurrency) {
    
    this.preferredCurrency = preferredCurrency;
    return this;
  }

  /**
   * Type of funds preferred for reviewing monetary values, in ISO 4217 codes
   * @return preferredCurrency
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreferredCurrency() {
    return preferredCurrency;
  }


  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferredCurrency(@jakarta.annotation.Nullable String preferredCurrency) {
    this.preferredCurrency = preferredCurrency;
  }

  public Personal language(@jakarta.annotation.Nullable String language) {
    
    this.language = language;
    return this;
  }

  /**
   * The primary language of the customer
   * @return language
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(@jakarta.annotation.Nullable String language) {
    this.language = language;
  }

  public Personal contactPerson(@jakarta.annotation.Nullable List<Object> contactPerson) {
    
    this.contactPerson = contactPerson;
    return this;
  }

  public Personal addContactPersonItem(Object contactPersonItem) {
    if (this.contactPerson == null) {
      this.contactPerson = new ArrayList<>();
    }
    this.contactPerson.add(contactPersonItem);
    return this;
  }

  /**
   * Get contactPerson
   * @return contactPerson
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getContactPerson() {
    return contactPerson;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactPerson(@jakarta.annotation.Nullable List<Object> contactPerson) {
    this.contactPerson = contactPerson;
  }

  public Personal physChallName(@jakarta.annotation.Nullable List<Object> physChallName) {
    
    this.physChallName = physChallName;
    return this;
  }

  public Personal addPhysChallNameItem(Object physChallNameItem) {
    if (this.physChallName == null) {
      this.physChallName = new ArrayList<>();
    }
    this.physChallName.add(physChallNameItem);
    return this;
  }

  /**
   * Get physChallName
   * @return physChallName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPhysChallName() {
    return physChallName;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChallName(@jakarta.annotation.Nullable List<Object> physChallName) {
    this.physChallName = physChallName;
  }

  public Personal petInfo(@jakarta.annotation.Nullable List<Object> petInfo) {
    
    this.petInfo = petInfo;
    return this;
  }

  public Personal addPetInfoItem(Object petInfoItem) {
    if (this.petInfo == null) {
      this.petInfo = new ArrayList<>();
    }
    this.petInfo.add(petInfoItem);
    return this;
  }

  /**
   * Get petInfo
   * @return petInfo
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPetInfo() {
    return petInfo;
  }


  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetInfo(@jakarta.annotation.Nullable List<Object> petInfo) {
    this.petInfo = petInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Personal personal = (Personal) o;
    return Objects.equals(this.gender, personal.gender) &&
        Objects.equals(this.birthDate, personal.birthDate) &&
        Objects.equals(this.maritalStatus, personal.maritalStatus) &&
        Objects.equals(this.childQuantity, personal.childQuantity) &&
        Objects.equals(this.citizenship, personal.citizenship) &&
        Objects.equals(this.address1, personal.address1) &&
        Objects.equals(this.address2, personal.address2) &&
        Objects.equals(this.city, personal.city) &&
        Objects.equals(this.state, personal.state) &&
        Objects.equals(this.postalCode, personal.postalCode) &&
        Objects.equals(this.country, personal.country) &&
        Objects.equals(this.preferredCurrency, personal.preferredCurrency) &&
        Objects.equals(this.language, personal.language) &&
        Objects.equals(this.contactPerson, personal.contactPerson) &&
        Objects.equals(this.physChallName, personal.physChallName) &&
        Objects.equals(this.petInfo, personal.petInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(gender, birthDate, maritalStatus, childQuantity, citizenship, address1, address2, city, state, postalCode, country, preferredCurrency, language, contactPerson, physChallName, petInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Personal {\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    birthDate: ").append(toIndentedString(birthDate)).append("\n");
    sb.append("    maritalStatus: ").append(toIndentedString(maritalStatus)).append("\n");
    sb.append("    childQuantity: ").append(toIndentedString(childQuantity)).append("\n");
    sb.append("    citizenship: ").append(toIndentedString(citizenship)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    preferredCurrency: ").append(toIndentedString(preferredCurrency)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    contactPerson: ").append(toIndentedString(contactPerson)).append("\n");
    sb.append("    physChallName: ").append(toIndentedString(physChallName)).append("\n");
    sb.append("    petInfo: ").append(toIndentedString(petInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

