/*
 * Wink Payment API
 * A programmatic way to create bookings, receive reactive and disburse funds globally.  ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/trip-pay-sdk-java](https://github.com/wink-travel/trip-pay-sdk-java)  # Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md 
 *
 * The version of the OpenAPI document: 30.17.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.trippay.sdk.payment.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Preferences
 */
@JsonPropertyOrder({
  Preferences.JSON_PROPERTY_PROPERTY_LOCATION_PREF,
  Preferences.JSON_PROPERTY_PROPERTY_TYPE_PREF,
  Preferences.JSON_PROPERTY_HOTEL_CHAIN_PREF,
  Preferences.JSON_PROPERTY_PROPERTY_AMENITY_PREF,
  Preferences.JSON_PROPERTY_RECREATION_SRVC_PREF,
  Preferences.JSON_PROPERTY_BUSINESS_SRVC_PREF,
  Preferences.JSON_PROPERTY_SECURITY_FEATURE_PREF,
  Preferences.JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF,
  Preferences.JSON_PROPERTY_SMOKING_ALLOWED,
  Preferences.JSON_PROPERTY_ROOM_LOCATION_PREF,
  Preferences.JSON_PROPERTY_BED_TYPE_PREF,
  Preferences.JSON_PROPERTY_FOOD_SRVC_PREF,
  Preferences.JSON_PROPERTY_ROOM_AMENITY_PREF,
  Preferences.JSON_PROPERTY_GUEST_TYPE,
  Preferences.JSON_PROPERTY_MEAL_PREF,
  Preferences.JSON_PROPERTY_CUISINE_PREF,
  Preferences.JSON_PROPERTY_INTEREST_PREF,
  Preferences.JSON_PROPERTY_BEVERAGE_PREF,
  Preferences.JSON_PROPERTY_FOOD_PREF,
  Preferences.JSON_PROPERTY_ALLERGIES,
  Preferences.JSON_PROPERTY_PETS_PREF
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-23T17:03:09.606308420+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class Preferences {
  public static final String JSON_PROPERTY_PROPERTY_LOCATION_PREF = "propertyLocationPref";
  @jakarta.annotation.Nullable
  private String propertyLocationPref;

  public static final String JSON_PROPERTY_PROPERTY_TYPE_PREF = "propertyTypePref";
  @jakarta.annotation.Nullable
  private String propertyTypePref;

  public static final String JSON_PROPERTY_HOTEL_CHAIN_PREF = "hotelChainPref";
  @jakarta.annotation.Nullable
  private String hotelChainPref;

  public static final String JSON_PROPERTY_PROPERTY_AMENITY_PREF = "propertyAmenityPref";
  @jakarta.annotation.Nullable
  private List<String> propertyAmenityPref = new ArrayList<>();

  public static final String JSON_PROPERTY_RECREATION_SRVC_PREF = "recreationSrvcPref";
  @jakarta.annotation.Nullable
  private List<String> recreationSrvcPref = new ArrayList<>();

  public static final String JSON_PROPERTY_BUSINESS_SRVC_PREF = "businessSrvcPref";
  @jakarta.annotation.Nullable
  private List<String> businessSrvcPref = new ArrayList<>();

  public static final String JSON_PROPERTY_SECURITY_FEATURE_PREF = "securityFeaturePref";
  @jakarta.annotation.Nullable
  private List<String> securityFeaturePref = new ArrayList<>();

  public static final String JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF = "physChalFeaturePref";
  @jakarta.annotation.Nullable
  private List<String> physChalFeaturePref = new ArrayList<>();

  public static final String JSON_PROPERTY_SMOKING_ALLOWED = "smokingAllowed";
  @jakarta.annotation.Nullable
  private Boolean smokingAllowed;

  public static final String JSON_PROPERTY_ROOM_LOCATION_PREF = "roomLocationPref";
  @jakarta.annotation.Nullable
  private String roomLocationPref;

  public static final String JSON_PROPERTY_BED_TYPE_PREF = "bedTypePref";
  @jakarta.annotation.Nullable
  private String bedTypePref;

  public static final String JSON_PROPERTY_FOOD_SRVC_PREF = "foodSrvcPref";
  @jakarta.annotation.Nullable
  private String foodSrvcPref;

  public static final String JSON_PROPERTY_ROOM_AMENITY_PREF = "roomAmenityPref";
  @jakarta.annotation.Nullable
  private List<String> roomAmenityPref = new ArrayList<>();

  public static final String JSON_PROPERTY_GUEST_TYPE = "guestType";
  @jakarta.annotation.Nullable
  private String guestType;

  public static final String JSON_PROPERTY_MEAL_PREF = "mealPref";
  @jakarta.annotation.Nullable
  private String mealPref;

  public static final String JSON_PROPERTY_CUISINE_PREF = "cuisinePref";
  @jakarta.annotation.Nullable
  private String cuisinePref;

  public static final String JSON_PROPERTY_INTEREST_PREF = "interestPref";
  @jakarta.annotation.Nullable
  private List<String> interestPref = new ArrayList<>();

  public static final String JSON_PROPERTY_BEVERAGE_PREF = "beveragePref";
  @jakarta.annotation.Nullable
  private List<String> beveragePref = new ArrayList<>();

  public static final String JSON_PROPERTY_FOOD_PREF = "foodPref";
  @jakarta.annotation.Nullable
  private List<String> foodPref = new ArrayList<>();

  public static final String JSON_PROPERTY_ALLERGIES = "allergies";
  @jakarta.annotation.Nullable
  private List<String> allergies = new ArrayList<>();

  public static final String JSON_PROPERTY_PETS_PREF = "petsPref";
  @jakarta.annotation.Nullable
  private List<String> petsPref = new ArrayList<>();

  public Preferences() {
  }

  public Preferences propertyLocationPref(@jakarta.annotation.Nullable String propertyLocationPref) {
    
    this.propertyLocationPref = propertyLocationPref;
    return this;
  }

  /**
   * Indicates preference for hotel property locations.
   * @return propertyLocationPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyLocationPref() {
    return propertyLocationPref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyLocationPref(@jakarta.annotation.Nullable String propertyLocationPref) {
    this.propertyLocationPref = propertyLocationPref;
  }

  public Preferences propertyTypePref(@jakarta.annotation.Nullable String propertyTypePref) {
    
    this.propertyTypePref = propertyTypePref;
    return this;
  }

  /**
   * Indicates preference for hotel property types.
   * @return propertyTypePref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyTypePref() {
    return propertyTypePref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyTypePref(@jakarta.annotation.Nullable String propertyTypePref) {
    this.propertyTypePref = propertyTypePref;
  }

  public Preferences hotelChainPref(@jakarta.annotation.Nullable String hotelChainPref) {
    
    this.hotelChainPref = hotelChainPref;
    return this;
  }

  /**
   * Identifies a preferred company by name.
   * @return hotelChainPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChainPref() {
    return hotelChainPref;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChainPref(@jakarta.annotation.Nullable String hotelChainPref) {
    this.hotelChainPref = hotelChainPref;
  }

  public Preferences propertyAmenityPref(@jakarta.annotation.Nullable List<String> propertyAmenityPref) {
    
    this.propertyAmenityPref = propertyAmenityPref;
    return this;
  }

  public Preferences addPropertyAmenityPrefItem(String propertyAmenityPrefItem) {
    if (this.propertyAmenityPref == null) {
      this.propertyAmenityPref = new ArrayList<>();
    }
    this.propertyAmenityPref.add(propertyAmenityPrefItem);
    return this;
  }

  /**
   * Get propertyAmenityPref
   * @return propertyAmenityPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAmenityPref() {
    return propertyAmenityPref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAmenityPref(@jakarta.annotation.Nullable List<String> propertyAmenityPref) {
    this.propertyAmenityPref = propertyAmenityPref;
  }

  public Preferences recreationSrvcPref(@jakarta.annotation.Nullable List<String> recreationSrvcPref) {
    
    this.recreationSrvcPref = recreationSrvcPref;
    return this;
  }

  public Preferences addRecreationSrvcPrefItem(String recreationSrvcPrefItem) {
    if (this.recreationSrvcPref == null) {
      this.recreationSrvcPref = new ArrayList<>();
    }
    this.recreationSrvcPref.add(recreationSrvcPrefItem);
    return this;
  }

  /**
   * Get recreationSrvcPref
   * @return recreationSrvcPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECREATION_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRecreationSrvcPref() {
    return recreationSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_RECREATION_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreationSrvcPref(@jakarta.annotation.Nullable List<String> recreationSrvcPref) {
    this.recreationSrvcPref = recreationSrvcPref;
  }

  public Preferences businessSrvcPref(@jakarta.annotation.Nullable List<String> businessSrvcPref) {
    
    this.businessSrvcPref = businessSrvcPref;
    return this;
  }

  public Preferences addBusinessSrvcPrefItem(String businessSrvcPrefItem) {
    if (this.businessSrvcPref == null) {
      this.businessSrvcPref = new ArrayList<>();
    }
    this.businessSrvcPref.add(businessSrvcPrefItem);
    return this;
  }

  /**
   * Get businessSrvcPref
   * @return businessSrvcPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BUSINESS_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBusinessSrvcPref() {
    return businessSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_BUSINESS_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessSrvcPref(@jakarta.annotation.Nullable List<String> businessSrvcPref) {
    this.businessSrvcPref = businessSrvcPref;
  }

  public Preferences securityFeaturePref(@jakarta.annotation.Nullable List<String> securityFeaturePref) {
    
    this.securityFeaturePref = securityFeaturePref;
    return this;
  }

  public Preferences addSecurityFeaturePrefItem(String securityFeaturePrefItem) {
    if (this.securityFeaturePref == null) {
      this.securityFeaturePref = new ArrayList<>();
    }
    this.securityFeaturePref.add(securityFeaturePrefItem);
    return this;
  }

  /**
   * Get securityFeaturePref
   * @return securityFeaturePref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeaturePref() {
    return securityFeaturePref;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeaturePref(@jakarta.annotation.Nullable List<String> securityFeaturePref) {
    this.securityFeaturePref = securityFeaturePref;
  }

  public Preferences physChalFeaturePref(@jakarta.annotation.Nullable List<String> physChalFeaturePref) {
    
    this.physChalFeaturePref = physChalFeaturePref;
    return this;
  }

  public Preferences addPhysChalFeaturePrefItem(String physChalFeaturePrefItem) {
    if (this.physChalFeaturePref == null) {
      this.physChalFeaturePref = new ArrayList<>();
    }
    this.physChalFeaturePref.add(physChalFeaturePrefItem);
    return this;
  }

  /**
   * Indicates preferences for type of features required to meet the needs of persons with physical challenges, disabilities, etc.
   * @return physChalFeaturePref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPhysChalFeaturePref() {
    return physChalFeaturePref;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChalFeaturePref(@jakarta.annotation.Nullable List<String> physChalFeaturePref) {
    this.physChalFeaturePref = physChalFeaturePref;
  }

  public Preferences smokingAllowed(@jakarta.annotation.Nullable Boolean smokingAllowed) {
    
    this.smokingAllowed = smokingAllowed;
    return this;
  }

  /**
   * Indicates preference for smooking allowed rooms..
   * @return smokingAllowed
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SMOKING_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSmokingAllowed() {
    return smokingAllowed;
  }


  @JsonProperty(JSON_PROPERTY_SMOKING_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmokingAllowed(@jakarta.annotation.Nullable Boolean smokingAllowed) {
    this.smokingAllowed = smokingAllowed;
  }

  public Preferences roomLocationPref(@jakarta.annotation.Nullable String roomLocationPref) {
    
    this.roomLocationPref = roomLocationPref;
    return this;
  }

  /**
   * Indicates preference for hotel room locations.
   * @return roomLocationPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomLocationPref() {
    return roomLocationPref;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomLocationPref(@jakarta.annotation.Nullable String roomLocationPref) {
    this.roomLocationPref = roomLocationPref;
  }

  public Preferences bedTypePref(@jakarta.annotation.Nullable String bedTypePref) {
    
    this.bedTypePref = bedTypePref;
    return this;
  }

  /**
   * Indicates preferences for the size and features of hotel bed types.
   * @return bedTypePref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BED_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedTypePref() {
    return bedTypePref;
  }


  @JsonProperty(JSON_PROPERTY_BED_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedTypePref(@jakarta.annotation.Nullable String bedTypePref) {
    this.bedTypePref = bedTypePref;
  }

  public Preferences foodSrvcPref(@jakarta.annotation.Nullable String foodSrvcPref) {
    
    this.foodSrvcPref = foodSrvcPref;
    return this;
  }

  /**
   * Indicates preferences for type of food listener facilities in a hotel.
   * @return foodSrvcPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FOOD_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFoodSrvcPref() {
    return foodSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_FOOD_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFoodSrvcPref(@jakarta.annotation.Nullable String foodSrvcPref) {
    this.foodSrvcPref = foodSrvcPref;
  }

  public Preferences roomAmenityPref(@jakarta.annotation.Nullable List<String> roomAmenityPref) {
    
    this.roomAmenityPref = roomAmenityPref;
    return this;
  }

  public Preferences addRoomAmenityPrefItem(String roomAmenityPrefItem) {
    if (this.roomAmenityPref == null) {
      this.roomAmenityPref = new ArrayList<>();
    }
    this.roomAmenityPref.add(roomAmenityPrefItem);
    return this;
  }

  /**
   * Get roomAmenityPref
   * @return roomAmenityPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRoomAmenityPref() {
    return roomAmenityPref;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomAmenityPref(@jakarta.annotation.Nullable List<String> roomAmenityPref) {
    this.roomAmenityPref = roomAmenityPref;
  }

  public Preferences guestType(@jakarta.annotation.Nullable String guestType) {
    
    this.guestType = guestType;
    return this;
  }

  /**
   * Guest type
   * @return guestType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGuestType() {
    return guestType;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuestType(@jakarta.annotation.Nullable String guestType) {
    this.guestType = guestType;
  }

  public Preferences mealPref(@jakarta.annotation.Nullable String mealPref) {
    
    this.mealPref = mealPref;
    return this;
  }

  /**
   * Indicates meal preference.
   * @return mealPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEAL_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMealPref() {
    return mealPref;
  }


  @JsonProperty(JSON_PROPERTY_MEAL_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMealPref(@jakarta.annotation.Nullable String mealPref) {
    this.mealPref = mealPref;
  }

  public Preferences cuisinePref(@jakarta.annotation.Nullable String cuisinePref) {
    
    this.cuisinePref = cuisinePref;
    return this;
  }

  /**
   * Indicates cuisine preference.
   * @return cuisinePref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUISINE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCuisinePref() {
    return cuisinePref;
  }


  @JsonProperty(JSON_PROPERTY_CUISINE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCuisinePref(@jakarta.annotation.Nullable String cuisinePref) {
    this.cuisinePref = cuisinePref;
  }

  public Preferences interestPref(@jakarta.annotation.Nullable List<String> interestPref) {
    
    this.interestPref = interestPref;
    return this;
  }

  public Preferences addInterestPrefItem(String interestPrefItem) {
    if (this.interestPref == null) {
      this.interestPref = new ArrayList<>();
    }
    this.interestPref.add(interestPrefItem);
    return this;
  }

  /**
   * Get interestPref
   * @return interestPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTEREST_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInterestPref() {
    return interestPref;
  }


  @JsonProperty(JSON_PROPERTY_INTEREST_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterestPref(@jakarta.annotation.Nullable List<String> interestPref) {
    this.interestPref = interestPref;
  }

  public Preferences beveragePref(@jakarta.annotation.Nullable List<String> beveragePref) {
    
    this.beveragePref = beveragePref;
    return this;
  }

  public Preferences addBeveragePrefItem(String beveragePrefItem) {
    if (this.beveragePref == null) {
      this.beveragePref = new ArrayList<>();
    }
    this.beveragePref.add(beveragePrefItem);
    return this;
  }

  /**
   * Get beveragePref
   * @return beveragePref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BEVERAGE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBeveragePref() {
    return beveragePref;
  }


  @JsonProperty(JSON_PROPERTY_BEVERAGE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeveragePref(@jakarta.annotation.Nullable List<String> beveragePref) {
    this.beveragePref = beveragePref;
  }

  public Preferences foodPref(@jakarta.annotation.Nullable List<String> foodPref) {
    
    this.foodPref = foodPref;
    return this;
  }

  public Preferences addFoodPrefItem(String foodPrefItem) {
    if (this.foodPref == null) {
      this.foodPref = new ArrayList<>();
    }
    this.foodPref.add(foodPrefItem);
    return this;
  }

  /**
   * Get foodPref
   * @return foodPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FOOD_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFoodPref() {
    return foodPref;
  }


  @JsonProperty(JSON_PROPERTY_FOOD_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFoodPref(@jakarta.annotation.Nullable List<String> foodPref) {
    this.foodPref = foodPref;
  }

  public Preferences allergies(@jakarta.annotation.Nullable List<String> allergies) {
    
    this.allergies = allergies;
    return this;
  }

  public Preferences addAllergiesItem(String allergiesItem) {
    if (this.allergies == null) {
      this.allergies = new ArrayList<>();
    }
    this.allergies.add(allergiesItem);
    return this;
  }

  /**
   * Get allergies
   * @return allergies
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLERGIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAllergies() {
    return allergies;
  }


  @JsonProperty(JSON_PROPERTY_ALLERGIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllergies(@jakarta.annotation.Nullable List<String> allergies) {
    this.allergies = allergies;
  }

  public Preferences petsPref(@jakarta.annotation.Nullable List<String> petsPref) {
    
    this.petsPref = petsPref;
    return this;
  }

  public Preferences addPetsPrefItem(String petsPrefItem) {
    if (this.petsPref == null) {
      this.petsPref = new ArrayList<>();
    }
    this.petsPref.add(petsPrefItem);
    return this;
  }

  /**
   * Get petsPref
   * @return petsPref
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PETS_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPetsPref() {
    return petsPref;
  }


  @JsonProperty(JSON_PROPERTY_PETS_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetsPref(@jakarta.annotation.Nullable List<String> petsPref) {
    this.petsPref = petsPref;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Preferences preferences = (Preferences) o;
    return Objects.equals(this.propertyLocationPref, preferences.propertyLocationPref) &&
        Objects.equals(this.propertyTypePref, preferences.propertyTypePref) &&
        Objects.equals(this.hotelChainPref, preferences.hotelChainPref) &&
        Objects.equals(this.propertyAmenityPref, preferences.propertyAmenityPref) &&
        Objects.equals(this.recreationSrvcPref, preferences.recreationSrvcPref) &&
        Objects.equals(this.businessSrvcPref, preferences.businessSrvcPref) &&
        Objects.equals(this.securityFeaturePref, preferences.securityFeaturePref) &&
        Objects.equals(this.physChalFeaturePref, preferences.physChalFeaturePref) &&
        Objects.equals(this.smokingAllowed, preferences.smokingAllowed) &&
        Objects.equals(this.roomLocationPref, preferences.roomLocationPref) &&
        Objects.equals(this.bedTypePref, preferences.bedTypePref) &&
        Objects.equals(this.foodSrvcPref, preferences.foodSrvcPref) &&
        Objects.equals(this.roomAmenityPref, preferences.roomAmenityPref) &&
        Objects.equals(this.guestType, preferences.guestType) &&
        Objects.equals(this.mealPref, preferences.mealPref) &&
        Objects.equals(this.cuisinePref, preferences.cuisinePref) &&
        Objects.equals(this.interestPref, preferences.interestPref) &&
        Objects.equals(this.beveragePref, preferences.beveragePref) &&
        Objects.equals(this.foodPref, preferences.foodPref) &&
        Objects.equals(this.allergies, preferences.allergies) &&
        Objects.equals(this.petsPref, preferences.petsPref);
  }

  @Override
  public int hashCode() {
    return Objects.hash(propertyLocationPref, propertyTypePref, hotelChainPref, propertyAmenityPref, recreationSrvcPref, businessSrvcPref, securityFeaturePref, physChalFeaturePref, smokingAllowed, roomLocationPref, bedTypePref, foodSrvcPref, roomAmenityPref, guestType, mealPref, cuisinePref, interestPref, beveragePref, foodPref, allergies, petsPref);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Preferences {\n");
    sb.append("    propertyLocationPref: ").append(toIndentedString(propertyLocationPref)).append("\n");
    sb.append("    propertyTypePref: ").append(toIndentedString(propertyTypePref)).append("\n");
    sb.append("    hotelChainPref: ").append(toIndentedString(hotelChainPref)).append("\n");
    sb.append("    propertyAmenityPref: ").append(toIndentedString(propertyAmenityPref)).append("\n");
    sb.append("    recreationSrvcPref: ").append(toIndentedString(recreationSrvcPref)).append("\n");
    sb.append("    businessSrvcPref: ").append(toIndentedString(businessSrvcPref)).append("\n");
    sb.append("    securityFeaturePref: ").append(toIndentedString(securityFeaturePref)).append("\n");
    sb.append("    physChalFeaturePref: ").append(toIndentedString(physChalFeaturePref)).append("\n");
    sb.append("    smokingAllowed: ").append(toIndentedString(smokingAllowed)).append("\n");
    sb.append("    roomLocationPref: ").append(toIndentedString(roomLocationPref)).append("\n");
    sb.append("    bedTypePref: ").append(toIndentedString(bedTypePref)).append("\n");
    sb.append("    foodSrvcPref: ").append(toIndentedString(foodSrvcPref)).append("\n");
    sb.append("    roomAmenityPref: ").append(toIndentedString(roomAmenityPref)).append("\n");
    sb.append("    guestType: ").append(toIndentedString(guestType)).append("\n");
    sb.append("    mealPref: ").append(toIndentedString(mealPref)).append("\n");
    sb.append("    cuisinePref: ").append(toIndentedString(cuisinePref)).append("\n");
    sb.append("    interestPref: ").append(toIndentedString(interestPref)).append("\n");
    sb.append("    beveragePref: ").append(toIndentedString(beveragePref)).append("\n");
    sb.append("    foodPref: ").append(toIndentedString(foodPref)).append("\n");
    sb.append("    allergies: ").append(toIndentedString(allergies)).append("\n");
    sb.append("    petsPref: ").append(toIndentedString(petsPref)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

