/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.Account;
import io.trippay.sdk.payment.model.AccountStatusResponse;
import io.trippay.sdk.payment.model.CreateAccountRequest;
import io.trippay.sdk.payment.model.KeyValuePair;
import io.trippay.sdk.payment.model.PageAccount;
import io.trippay.sdk.payment.model.RemoveEntryResponse;
import io.trippay.sdk.payment.model.SetTaxIdentifierRequest;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.UniqueResult;
import io.trippay.sdk.payment.model.UpsertAccountRequest;
import io.trippay.sdk.payment.model.UpsertBankAccountRequest;
import io.trippay.sdk.payment.model.VerifyAccountRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AccountApi {
    private ApiClient apiClient;

    public AccountApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec checkAccountStatusRequestCreation(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling checkAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/status", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AccountStatusResponse> checkAccountStatus(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkAccountStatusRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AccountStatusResponse>> checkAccountStatusWithHttpInfo(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkAccountStatusRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec checkAccountStatusWithResponseSpec(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.checkAccountStatusRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec checkExternalAccountStatusRequestCreation(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling checkExternalAccountStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/status", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AccountStatusResponse> checkExternalAccountStatus(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkExternalAccountStatusRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AccountStatusResponse>> checkExternalAccountStatusWithHttpInfo(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AccountStatusResponse> localVarReturnType = new ParameterizedTypeReference<AccountStatusResponse>(this){};
        return this.checkExternalAccountStatusRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec checkExternalAccountStatusWithResponseSpec(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.checkExternalAccountStatusRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec createAccountRequestCreation(@Nonnull CreateAccountRequest createAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        CreateAccountRequest postBody = createAccountRequest;
        if (createAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAccountRequest' when calling createAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createAccount(@Nonnull CreateAccountRequest createAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountRequestCreation(createAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountWithHttpInfo(@Nonnull CreateAccountRequest createAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountRequestCreation(createAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAccountWithResponseSpec(@Nonnull CreateAccountRequest createAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createAccountRequestCreation(createAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec createAccountBankAccountRequestCreation(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling createAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/bank-account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createAccountBankAccount(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createAccountBankAccountWithHttpInfo(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAccountBankAccountWithResponseSpec(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec createExternalAccountBankAccountRequestCreation(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling createExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/bank-account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> createExternalAccountBankAccount(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> createExternalAccountBankAccountWithHttpInfo(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createExternalAccountBankAccountWithResponseSpec(@Nonnull String id, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createExternalAccountBankAccountRequestCreation(id, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec deleteAccountRequestCreation(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> deleteAccount(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteAccountRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> deleteAccountWithHttpInfo(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteAccountRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteAccountWithResponseSpec(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.deleteAccountRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec isAccountNameUniqueRequestCreation(@Nonnull String name, @Nullable String identifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling isAccountNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("name", name);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "identifier", identifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(this){};
        return this.apiClient.invokeAPI("/api/account/unique/{name}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResult> isAccountNameUnique(@Nonnull String name, @Nullable String identifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(this){};
        return this.isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isAccountNameUniqueWithHttpInfo(@Nonnull String name, @Nullable String identifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(this){};
        return this.isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isAccountNameUniqueWithResponseSpec(@Nonnull String name, @Nullable String identifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.isAccountNameUniqueRequestCreation(name, identifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountRequestCreation(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> loadAccount(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> loadAccountWithHttpInfo(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountWithResponseSpec(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.loadAccountRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountByNameRequestCreation(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling loadAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("name", name);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/name/{name}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> loadAccountByName(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameRequestCreation(name, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountByNameWithHttpInfo(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameRequestCreation(name, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountByNameWithResponseSpec(@Nonnull String name, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.loadAccountByNameRequestCreation(name, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountByNameLikeRequestCreation(@Nonnull String name, @Nullable Boolean ignoreCase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling loadAccountByNameLike", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "name", name));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "ignore-case", ignoreCase));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/name", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> loadAccountByNameLike(@Nonnull String name, @Nullable Boolean ignoreCase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountByNameLikeWithHttpInfo(@Nonnull String name, @Nullable Boolean ignoreCase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountByNameLikeWithResponseSpec(@Nonnull String name, @Nullable Boolean ignoreCase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.loadAccountByNameLikeRequestCreation(name, ignoreCase, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountGridForAuthenticatedUserRequestCreation(@Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        State postBody = state;
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling loadAccountGridForAuthenticatedUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>(this){};
        return this.apiClient.invokeAPI("/api/account/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageAccount> loadAccountGridForAuthenticatedUser(@Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>(this){};
        return this.loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageAccount>> loadAccountGridForAuthenticatedUserWithHttpInfo(@Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageAccount> localVarReturnType = new ParameterizedTypeReference<PageAccount>(this){};
        return this.loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountGridForAuthenticatedUserWithResponseSpec(@Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        return this.loadAccountGridForAuthenticatedUserRequestCreation(state, winkVersion);
    }

    private WebClient.ResponseSpec loadAccountsForAuthenticatedUserRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> loadAccountsForAuthenticatedUser(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> loadAccountsForAuthenticatedUserWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountsForAuthenticatedUserWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.loadAccountsForAuthenticatedUserRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec loadExternalAccountRequestCreation(@Nonnull String externalAccountIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (externalAccountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalAccountIdentifier' when calling loadExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("externalAccountIdentifier", externalAccountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{externalAccountIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> loadExternalAccount(@Nonnull String externalAccountIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> loadExternalAccountWithHttpInfo(@Nonnull String externalAccountIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadExternalAccountWithResponseSpec(@Nonnull String externalAccountIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.loadExternalAccountRequestCreation(externalAccountIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeAccountBankAccountRequestCreation(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/bank-account/{bankAccountId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> removeAccountBankAccount(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeAccountBankAccountWithHttpInfo(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAccountBankAccountWithResponseSpec(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeExternalAccountBankAccountRequestCreation(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling removeExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/bank-account/{bankAccountId}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> removeExternalAccountBankAccount(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> removeExternalAccountBankAccountWithHttpInfo(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeExternalAccountBankAccountWithResponseSpec(@Nonnull String id, @Nonnull String bankAccountId, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeExternalAccountBankAccountRequestCreation(id, bankAccountId, winkVersion, accept);
    }

    private WebClient.ResponseSpec searchAccountByNameRequestCreation(@Nonnull String name, @Nullable Boolean ignorecase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (name == null) {
            throw new WebClientResponseException("Missing the required parameter 'name' when calling searchAccountByName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "name", name));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "ignorecase", ignorecase));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.apiClient.invokeAPI("/api/account/search", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> searchAccountByName(@Nonnull String name, @Nullable Boolean ignorecase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> searchAccountByNameWithHttpInfo(@Nonnull String name, @Nullable Boolean ignorecase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec searchAccountByNameWithResponseSpec(@Nonnull String name, @Nullable Boolean ignorecase, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.searchAccountByNameRequestCreation(name, ignorecase, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAccountsByOwnerRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/owner/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Account> showAccountsByOwner(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.showAccountsByOwnerRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Account>>> showAccountsByOwnerWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.showAccountsByOwnerRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAccountsByOwnerWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showAccountsByOwnerRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateAccountRequestCreation(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAccountRequest postBody = upsertAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountRequest' when calling updateAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateAccount(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateAccountRequestCreation(id, upsertAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateAccountWithHttpInfo(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateAccountRequestCreation(id, upsertAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAccountWithResponseSpec(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateAccountRequestCreation(id, upsertAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateExternalAccountRequestCreation(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAccountRequest postBody = upsertAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountRequest' when calling updateExternalAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateExternalAccount(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateExternalAccountWithHttpInfo(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateExternalAccountWithResponseSpec(@Nonnull String id, @Nonnull UpsertAccountRequest upsertAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateExternalAccountRequestCreation(id, upsertAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateNationalIdentifierRequestCreation(@Nonnull String id, @Nonnull String taskId, @Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @Nullable String winkVersion) throws WebClientResponseException {
        SetTaxIdentifierRequest postBody = setTaxIdentifierRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (taskId == null) {
            throw new WebClientResponseException("Missing the required parameter 'taskId' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (setTaxIdentifierRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'setTaxIdentifierRequest' when calling updateNationalIdentifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("taskId", taskId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/task/{taskId}/tid", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> updateNationalIdentifier(@Nonnull String id, @Nonnull String taskId, @Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> updateNationalIdentifierWithHttpInfo(@Nonnull String id, @Nonnull String taskId, @Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateNationalIdentifierWithResponseSpec(@Nonnull String id, @Nonnull String taskId, @Nonnull SetTaxIdentifierRequest setTaxIdentifierRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateNationalIdentifierRequestCreation(id, taskId, setTaxIdentifierRequest, winkVersion);
    }

    private WebClient.ResponseSpec upsertAccountBankAccountRequestCreation(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling upsertAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/bank-account/{bankAccountId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> upsertAccountBankAccount(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertAccountBankAccountWithHttpInfo(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec upsertAccountBankAccountWithResponseSpec(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.upsertAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec upsertExternalAccountBankAccountRequestCreation(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertBankAccountRequest postBody = upsertBankAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bankAccountId == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankAccountId' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBankAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBankAccountRequest' when calling upsertExternalAccountBankAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        pathParams.put("bankAccountId", bankAccountId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/external/{id}/bank-account/{bankAccountId}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> upsertExternalAccountBankAccount(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> upsertExternalAccountBankAccountWithHttpInfo(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec upsertExternalAccountBankAccountWithResponseSpec(@Nonnull String id, @Nonnull String bankAccountId, @Nonnull UpsertBankAccountRequest upsertBankAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.upsertExternalAccountBankAccountRequestCreation(id, bankAccountId, upsertBankAccountRequest, winkVersion);
    }

    private WebClient.ResponseSpec verifyAccountRequestCreation(@Nonnull String id, @Nonnull VerifyAccountRequest verifyAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        VerifyAccountRequest postBody = verifyAccountRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (verifyAccountRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'verifyAccountRequest' when calling verifyAccount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.apiClient.invokeAPI("/api/account/{id}/verify", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Account> verifyAccount(@Nonnull String id, @Nonnull VerifyAccountRequest verifyAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Account>> verifyAccountWithHttpInfo(@Nonnull String id, @Nonnull VerifyAccountRequest verifyAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Account> localVarReturnType = new ParameterizedTypeReference<Account>(this){};
        return this.verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec verifyAccountWithResponseSpec(@Nonnull String id, @Nonnull VerifyAccountRequest verifyAccountRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.verifyAccountRequestCreation(id, verifyAccountRequest, winkVersion);
    }
}

