/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.Mapping;
import io.trippay.sdk.payment.model.PageMapping;
import io.trippay.sdk.payment.model.RemoveEntryResponse;
import io.trippay.sdk.payment.model.State;
import io.trippay.sdk.payment.model.UpsertAccountMappingRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class AccountMappingsApi {
    private ApiClient apiClient;

    public AccountMappingsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccountMappingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAccountMappingRequestCreation(@Nonnull String accountIdentifier, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAccountMappingRequest postBody = upsertAccountMappingRequest;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling createAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountMappingRequest' when calling createAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> createAccountMapping(@Nonnull String accountIdentifier, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.createAccountMappingRequestCreation(accountIdentifier, upsertAccountMappingRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> createAccountMappingWithHttpInfo(@Nonnull String accountIdentifier, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.createAccountMappingRequestCreation(accountIdentifier, upsertAccountMappingRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAccountMappingWithResponseSpec(@Nonnull String accountIdentifier, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createAccountMappingRequestCreation(accountIdentifier, upsertAccountMappingRequest, winkVersion);
    }

    private WebClient.ResponseSpec loadAccountMappingRequestCreation(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling loadAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> loadAccountMapping(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> loadAccountMappingWithHttpInfo(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountMappingWithResponseSpec(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.loadAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadAccountMappingGridRequestCreation(@Nonnull String accountIdentifier, @Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        State postBody = state;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling loadAccountMappingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling loadAccountMappingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageMapping> loadAccountMappingGrid(@Nonnull String accountIdentifier, @Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>(this){};
        return this.loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageMapping>> loadAccountMappingGridWithHttpInfo(@Nonnull String accountIdentifier, @Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageMapping> localVarReturnType = new ParameterizedTypeReference<PageMapping>(this){};
        return this.loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadAccountMappingGridWithResponseSpec(@Nonnull String accountIdentifier, @Nonnull State state, @Nullable String winkVersion) throws WebClientResponseException {
        return this.loadAccountMappingGridRequestCreation(accountIdentifier, state, winkVersion);
    }

    private WebClient.ResponseSpec removeAccountMappingRequestCreation(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling removeAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling removeAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeAccountMapping(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAccountMappingWithHttpInfo(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAccountMappingWithResponseSpec(@Nonnull String accountIdentifier, @Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeAccountMappingRequestCreation(accountIdentifier, id, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateAccountMappingRequestCreation(@Nonnull String accountIdentifier, @Nonnull String id, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAccountMappingRequest postBody = upsertAccountMappingRequest;
        if (accountIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'accountIdentifier' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAccountMappingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAccountMappingRequest' when calling updateAccountMapping", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("accountIdentifier", accountIdentifier);
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.apiClient.invokeAPI("/api/account/{accountIdentifier}/mapping/{id}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Mapping> updateAccountMapping(@Nonnull String accountIdentifier, @Nonnull String id, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.updateAccountMappingRequestCreation(accountIdentifier, id, upsertAccountMappingRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Mapping>> updateAccountMappingWithHttpInfo(@Nonnull String accountIdentifier, @Nonnull String id, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Mapping> localVarReturnType = new ParameterizedTypeReference<Mapping>(this){};
        return this.updateAccountMappingRequestCreation(accountIdentifier, id, upsertAccountMappingRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAccountMappingWithResponseSpec(@Nonnull String accountIdentifier, @Nonnull String id, @Nonnull UpsertAccountMappingRequest upsertAccountMappingRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateAccountMappingRequestCreation(accountIdentifier, id, upsertAccountMappingRequest, winkVersion);
    }
}

