/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.ActivityStream;
import io.trippay.sdk.payment.model.UpsertActivityStreamRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ActivityStreamApi {
    private ApiClient apiClient;

    public ActivityStreamApi() {
        this(new ApiClient());
    }

    @Autowired
    public ActivityStreamApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createActivityRequestCreation(@Nonnull UpsertActivityStreamRequest upsertActivityStreamRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertActivityStreamRequest postBody = upsertActivityStreamRequest;
        if (upsertActivityStreamRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityStreamRequest' when calling createActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>(this){};
        return this.apiClient.invokeAPI("/api/activity-stream", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ActivityStream> createActivity(@Nonnull UpsertActivityStreamRequest upsertActivityStreamRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>(this){};
        return this.createActivityRequestCreation(upsertActivityStreamRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ActivityStream>> createActivityWithHttpInfo(@Nonnull UpsertActivityStreamRequest upsertActivityStreamRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>(this){};
        return this.createActivityRequestCreation(upsertActivityStreamRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createActivityWithResponseSpec(@Nonnull UpsertActivityStreamRequest upsertActivityStreamRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createActivityRequestCreation(upsertActivityStreamRequest, winkVersion);
    }

    private WebClient.ResponseSpec showStreamRequestCreation(@Nonnull String entityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (entityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'entityIdentifier' when calling showStream", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("entityIdentifier", entityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>(this){};
        return this.apiClient.invokeAPI("/api/activity-stream/{entityIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ActivityStream> showStream(@Nonnull String entityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>(this){};
        return this.showStreamRequestCreation(entityIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ActivityStream>>> showStreamWithHttpInfo(@Nonnull String entityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ActivityStream> localVarReturnType = new ParameterizedTypeReference<ActivityStream>(this){};
        return this.showStreamRequestCreation(entityIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showStreamWithResponseSpec(@Nonnull String entityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showStreamRequestCreation(entityIdentifier, winkVersion, accept);
    }
}

