/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.api;

import io.trippay.sdk.payment.invoker.ApiClient;
import io.trippay.sdk.payment.model.Application;
import io.trippay.sdk.payment.model.CreateApplicationResponse;
import io.trippay.sdk.payment.model.ManagingEntity;
import io.trippay.sdk.payment.model.RemoveEntryResponse;
import io.trippay.sdk.payment.model.RevokeClientIdResponse;
import io.trippay.sdk.payment.model.UpdateApplicationResponse;
import io.trippay.sdk.payment.model.UpsertApplicationRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createApplicationRequestCreation(@Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertApplicationRequest postBody = upsertApplicationRequest;
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling createApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>(this){};
        return this.apiClient.invokeAPI("/api/application", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CreateApplicationResponse> createApplication(@Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>(this){};
        return this.createApplicationRequestCreation(upsertApplicationRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CreateApplicationResponse>> createApplicationWithHttpInfo(@Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>(this){};
        return this.createApplicationRequestCreation(upsertApplicationRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createApplicationWithResponseSpec(@Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createApplicationRequestCreation(upsertApplicationRequest, winkVersion);
    }

    private WebClient.ResponseSpec deleteApplicationRequestCreation(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> deleteApplication(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteApplicationRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> deleteApplicationWithHttpInfo(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteApplicationRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteApplicationWithResponseSpec(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.deleteApplicationRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadApplicationRequestCreation(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Application> loadApplication(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.loadApplicationRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Application>> loadApplicationWithHttpInfo(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.loadApplicationRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadApplicationWithResponseSpec(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.loadApplicationRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec revokeApplicationRequestCreation(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling revokeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}/revoke", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RevokeClientIdResponse> revokeApplication(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>(this){};
        return this.revokeApplicationRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RevokeClientIdResponse>> revokeApplicationWithHttpInfo(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>(this){};
        return this.revokeApplicationRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec revokeApplicationWithResponseSpec(@Nonnull String id, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.revokeApplicationRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec showApplicationsByUserRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.apiClient.invokeAPI("/api/application/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Application> showApplicationsByUser(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.showApplicationsByUserRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Application>>> showApplicationsByUserWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.showApplicationsByUserRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationsByUserWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showApplicationsByUserRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showManagingEntitiesRequestCreation(@Nonnull String managingEntityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (managingEntityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'managingEntityIdentifier' when calling showManagingEntities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("managingEntityIdentifier", managingEntityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.apiClient.invokeAPI("/api/managing-entity/{managingEntityIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ManagingEntity> showManagingEntities(@Nonnull String managingEntityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.showManagingEntitiesRequestCreation(managingEntityIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ManagingEntity>> showManagingEntitiesWithHttpInfo(@Nonnull String managingEntityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.showManagingEntitiesRequestCreation(managingEntityIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showManagingEntitiesWithResponseSpec(@Nonnull String managingEntityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showManagingEntitiesRequestCreation(managingEntityIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showManagingEntities1RequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.apiClient.invokeAPI("/api/managing-entity/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ManagingEntity> showManagingEntities1(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.showManagingEntities1RequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ManagingEntity>>> showManagingEntities1WithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.showManagingEntities1RequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showManagingEntities1WithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showManagingEntities1RequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateApplicationRequestCreation(@Nonnull String id, @Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertApplicationRequest postBody = upsertApplicationRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UpdateApplicationResponse> updateApplication(@Nonnull String id, @Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>(this){};
        return this.updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateApplicationResponse>> updateApplicationWithHttpInfo(@Nonnull String id, @Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>(this){};
        return this.updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateApplicationWithResponseSpec(@Nonnull String id, @Nonnull UpsertApplicationRequest upsertApplicationRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion);
    }
}

