/*
 * Decompiled with CFR 0.152.
 */
package io.trippay.sdk.payment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"accountIdentifier", "status", "taskList"})
public class AccountStatusResponse {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    @Nonnull
    private UUID accountIdentifier;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status;
    public static final String JSON_PROPERTY_TASK_LIST = "taskList";
    @Nullable
    private List<Object> taskList = new ArrayList<Object>();

    public AccountStatusResponse accountIdentifier(@Nonnull UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(@Nonnull UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public AccountStatusResponse status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public AccountStatusResponse taskList(@Nullable List<Object> taskList) {
        this.taskList = taskList;
        return this;
    }

    public AccountStatusResponse addTaskListItem(Object taskListItem) {
        if (this.taskList == null) {
            this.taskList = new ArrayList<Object>();
        }
        this.taskList.add(taskListItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="taskList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getTaskList() {
        return this.taskList;
    }

    @JsonProperty(value="taskList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskList(@Nullable List<Object> taskList) {
        this.taskList = taskList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountStatusResponse accountStatusResponse = (AccountStatusResponse)o;
        return Objects.equals(this.accountIdentifier, accountStatusResponse.accountIdentifier) && Objects.equals((Object)this.status, (Object)accountStatusResponse.status) && Objects.equals(this.taskList, accountStatusResponse.taskList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.status, this.taskList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountStatusResponse {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    taskList: ").append(this.toIndentedString(this.taskList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        REGISTERED(String.valueOf("REGISTERED")),
        REVIEW(String.valueOf("REVIEW")),
        APPROVED(String.valueOf("APPROVED")),
        DEACTIVATED(String.valueOf("DEACTIVATED")),
        REJECTED(String.valueOf("REJECTED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

